/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.resolver;

import com.navercorp.fixturemonkey.ArbitraryBuilder;
import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.context.MonkeyContext;
import com.navercorp.fixturemonkey.api.expression.ExpressionGenerator;
import com.navercorp.fixturemonkey.api.lazy.LazyArbitrary;
import com.navercorp.fixturemonkey.api.matcher.MatcherOperator;
import com.navercorp.fixturemonkey.api.option.FixtureMonkeyOptions;
import com.navercorp.fixturemonkey.api.property.PropertyNameResolver;
import com.navercorp.fixturemonkey.api.property.PropertySelector;
import com.navercorp.fixturemonkey.api.property.RootProperty;
import com.navercorp.fixturemonkey.api.type.LazyAnnotatedType;
import com.navercorp.fixturemonkey.api.type.Types;
import com.navercorp.fixturemonkey.customizer.ArbitraryManipulator;
import com.navercorp.fixturemonkey.customizer.ContainerInfoManipulator;
import com.navercorp.fixturemonkey.customizer.InnerSpec;
import com.navercorp.fixturemonkey.customizer.ManipulatorSet;
import com.navercorp.fixturemonkey.customizer.MonkeyManipulatorFactory;
import com.navercorp.fixturemonkey.customizer.Values;
import com.navercorp.fixturemonkey.resolver.ArbitraryBuilderContext;
import com.navercorp.fixturemonkey.resolver.ArbitraryResolver;
import com.navercorp.fixturemonkey.tree.ArbitraryTraverser;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Combinators;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"})
public final class DefaultArbitraryBuilder<T>
implements ArbitraryBuilder<T> {
    private final FixtureMonkeyOptions fixtureMonkeyOptions;
    private final RootProperty rootProperty;
    private final ArbitraryResolver resolver;
    private final ArbitraryTraverser traverser;
    private final MonkeyManipulatorFactory monkeyManipulatorFactory;
    private final ArbitraryBuilderContext context;
    private final List<MatcherOperator<? extends ArbitraryBuilder<?>>> registeredArbitraryBuilders;
    private final MonkeyContext monkeyContext;

    public DefaultArbitraryBuilder(FixtureMonkeyOptions fixtureMonkeyOptions, RootProperty rootProperty, ArbitraryResolver resolver, ArbitraryTraverser traverser, MonkeyManipulatorFactory monkeyManipulatorFactory, ArbitraryBuilderContext context, List<MatcherOperator<? extends ArbitraryBuilder<?>>> registeredArbitraryBuilders, MonkeyContext monkeyContext) {
        this.fixtureMonkeyOptions = fixtureMonkeyOptions;
        this.rootProperty = rootProperty;
        this.resolver = resolver;
        this.traverser = traverser;
        this.context = context;
        this.monkeyManipulatorFactory = monkeyManipulatorFactory;
        this.registeredArbitraryBuilders = registeredArbitraryBuilders;
        this.monkeyContext = monkeyContext;
    }

    @Override
    public ArbitraryBuilder<T> validOnly(boolean validOnly) {
        this.context.setValidOnly(validOnly);
        return this;
    }

    @Override
    public ArbitraryBuilder<T> set(String expression, @Nullable Object value, int limit) {
        if (value instanceof InnerSpec) {
            this.setInner((InnerSpec)value);
        } else {
            ArbitraryManipulator arbitraryManipulator = this.monkeyManipulatorFactory.newArbitraryManipulator(expression, value, limit);
            this.context.addManipulator(arbitraryManipulator);
        }
        return this;
    }

    @Override
    public ArbitraryBuilder<T> set(String expression, @Nullable Object value) {
        return this.set(expression, value, Integer.MAX_VALUE);
    }

    @Override
    public ArbitraryBuilder<T> set(@Nullable Object value) {
        return this.set("$", value);
    }

    @Override
    @Deprecated
    public ArbitraryBuilder<T> set(ExpressionGenerator expressionGenerator, @Nullable Object value, int limit) {
        return this.set(this.resolveExpression(expressionGenerator), value, limit);
    }

    @Override
    public ArbitraryBuilder<T> set(PropertySelector propertySelector, @Nullable Object value, int limit) {
        return this.set(this.resolveExpression(this.toExpressionGenerator(propertySelector)), value, limit);
    }

    @Override
    @Deprecated
    public ArbitraryBuilder<T> set(ExpressionGenerator expressionGenerator, @Nullable Object value) {
        return this.set(this.resolveExpression(expressionGenerator), value);
    }

    @Override
    public ArbitraryBuilder<T> set(PropertySelector propertySelector, @Nullable Object value) {
        return this.set(this.resolveExpression(this.toExpressionGenerator(propertySelector)), value);
    }

    @Override
    public ArbitraryBuilder<T> setLazy(String expression, Supplier<?> supplier, int limit) {
        ArbitraryManipulator arbitraryManipulator = this.monkeyManipulatorFactory.newArbitraryManipulator(expression, supplier, limit);
        this.context.addManipulator(arbitraryManipulator);
        return this;
    }

    @Override
    public ArbitraryBuilder<T> setLazy(String expression, Supplier<?> supplier) {
        return this.setLazy(expression, supplier, Integer.MAX_VALUE);
    }

    @Override
    @Deprecated
    public ArbitraryBuilder<T> setLazy(ExpressionGenerator expressionGenerator, Supplier<?> supplier, int limit) {
        return this.setLazy(this.resolveExpression(expressionGenerator), supplier, limit);
    }

    @Override
    public ArbitraryBuilder<T> setLazy(PropertySelector propertySelector, Supplier<?> supplier, int limit) {
        return this.setLazy(this.resolveExpression(this.toExpressionGenerator(propertySelector)), supplier, limit);
    }

    @Override
    @Deprecated
    public ArbitraryBuilder<T> setLazy(ExpressionGenerator expressionGenerator, Supplier<?> supplier) {
        return this.setLazy(this.resolveExpression(expressionGenerator), supplier, Integer.MAX_VALUE);
    }

    @Override
    public ArbitraryBuilder<T> setLazy(PropertySelector propertySelector, Supplier<?> supplier) {
        return this.setLazy(this.resolveExpression(this.toExpressionGenerator(propertySelector)), supplier, Integer.MAX_VALUE);
    }

    @Override
    public ArbitraryBuilder<T> setInner(InnerSpec innerSpec) {
        ManipulatorSet manipulatorSet = innerSpec.getManipulatorSet(this.monkeyManipulatorFactory);
        List<ArbitraryManipulator> arbitraryManipulators = manipulatorSet.getArbitraryManipulators();
        List<ContainerInfoManipulator> containerInfoManipulators = manipulatorSet.getContainerInfoManipulators();
        this.context.addManipulators(arbitraryManipulators);
        this.context.addContainerInfoManipulators(containerInfoManipulators);
        return this;
    }

    @Override
    public ArbitraryBuilder<T> minSize(String expression, int minSize) {
        return this.size(expression, minSize, minSize + 3);
    }

    @Override
    @Deprecated
    public ArbitraryBuilder<T> minSize(ExpressionGenerator expressionGenerator, int minSize) {
        return this.size(this.resolveExpression(expressionGenerator), minSize, minSize + 3);
    }

    @Override
    public ArbitraryBuilder<T> minSize(PropertySelector propertySelector, int minSize) {
        return this.size(this.resolveExpression(this.toExpressionGenerator(propertySelector)), minSize, minSize + 3);
    }

    @Override
    public ArbitraryBuilder<T> maxSize(String expression, int maxSize) {
        return this.size(expression, Math.max(0, maxSize - 3), maxSize);
    }

    @Override
    @Deprecated
    public ArbitraryBuilder<T> maxSize(ExpressionGenerator expressionGenerator, int maxSize) {
        return this.size(this.resolveExpression(expressionGenerator), Math.max(0, maxSize - 3), maxSize);
    }

    @Override
    public ArbitraryBuilder<T> maxSize(PropertySelector propertySelector, int maxSize) {
        return this.size(this.resolveExpression(this.toExpressionGenerator(propertySelector)), Math.max(0, maxSize - 3), maxSize);
    }

    @Override
    public ArbitraryBuilder<T> size(String expression, int size) {
        return this.size(expression, size, size);
    }

    @Override
    @Deprecated
    public ArbitraryBuilder<T> size(ExpressionGenerator expressionGenerator, int size) {
        return this.size(this.resolveExpression(expressionGenerator), size, size);
    }

    @Override
    public ArbitraryBuilder<T> size(PropertySelector propertySelector, int size) {
        return this.size(this.resolveExpression(this.toExpressionGenerator(propertySelector)), size, size);
    }

    @Override
    public ArbitraryBuilder<T> size(String expression, int minSize, int maxSize) {
        if (minSize > maxSize) {
            throw new IllegalArgumentException("should be min > max, min : " + minSize + " max : " + maxSize);
        }
        ContainerInfoManipulator containerInfoManipulator = this.monkeyManipulatorFactory.newContainerInfoManipulator(expression, minSize, maxSize);
        this.context.addContainerInfoManipulator(containerInfoManipulator);
        return this;
    }

    @Override
    @Deprecated
    public ArbitraryBuilder<T> size(ExpressionGenerator expressionGenerator, int minSize, int maxSize) {
        return this.size(this.resolveExpression(expressionGenerator), minSize, maxSize);
    }

    @Override
    public ArbitraryBuilder<T> size(PropertySelector propertySelector, int minSize, int maxSize) {
        return this.size(this.resolveExpression(this.toExpressionGenerator(propertySelector)), minSize, maxSize);
    }

    @Override
    public ArbitraryBuilder<T> fixed() {
        this.context.getContainerInfoManipulators().forEach(ContainerInfoManipulator::fixed);
        this.context.markFixed();
        return this;
    }

    @Override
    @Deprecated
    public ArbitraryBuilder<T> apply(BiConsumer<T, ArbitraryBuilder<T>> biConsumer) {
        return this.thenApply(biConsumer);
    }

    @Override
    public ArbitraryBuilder<T> thenApply(BiConsumer<T, ArbitraryBuilder<T>> biConsumer) {
        this.context.getContainerInfoManipulators().forEach(ContainerInfoManipulator::fixed);
        ArbitraryBuilder appliedBuilder = this.copy();
        LazyArbitrary lazyArbitrary = LazyArbitrary.lazy(() -> {
            ArbitraryBuilder lazyBuilder = appliedBuilder.copy();
            Object sampled = lazyBuilder.fixed().sample();
            biConsumer.accept(sampled, lazyBuilder);
            return lazyBuilder.sample();
        });
        ArbitraryManipulator arbitraryManipulator = this.monkeyManipulatorFactory.newArbitraryManipulator("$", lazyArbitrary);
        this.context.addManipulator(arbitraryManipulator);
        return this;
    }

    @Override
    public ArbitraryBuilder<T> acceptIf(Predicate<T> predicate, Consumer<ArbitraryBuilder<T>> consumer) {
        return this.thenApply((it, builder) -> {
            if (predicate.test(it)) {
                consumer.accept((ArbitraryBuilder)builder);
            }
        });
    }

    @Override
    public ArbitraryBuilder<T> setNull(String expression) {
        ArbitraryManipulator arbitraryManipulator = this.monkeyManipulatorFactory.newArbitraryManipulator(expression, null);
        this.context.addManipulator(arbitraryManipulator);
        return this;
    }

    @Override
    @Deprecated
    public ArbitraryBuilder<T> setNull(ExpressionGenerator expressionGenerator) {
        return this.setNull(this.resolveExpression(expressionGenerator));
    }

    @Override
    public ArbitraryBuilder<T> setNull(PropertySelector propertySelector) {
        return this.setNull(this.resolveExpression(this.toExpressionGenerator(propertySelector)));
    }

    @Override
    public ArbitraryBuilder<T> setNotNull(String expression) {
        ArbitraryManipulator arbitraryManipulator = this.monkeyManipulatorFactory.newArbitraryManipulator(expression, Values.NOT_NULL);
        this.context.addManipulator(arbitraryManipulator);
        return this;
    }

    @Override
    @Deprecated
    public ArbitraryBuilder<T> setNotNull(ExpressionGenerator expressionGenerator) {
        return this.setNotNull(this.resolveExpression(expressionGenerator));
    }

    @Override
    public ArbitraryBuilder<T> setNotNull(PropertySelector propertySelector) {
        return this.setNotNull(this.resolveExpression(this.toExpressionGenerator(propertySelector)));
    }

    @Override
    public ArbitraryBuilder<T> setPostCondition(Predicate<T> predicate) {
        return this.setPostCondition("$", Types.getActualType((Type)this.rootProperty.getType()), predicate);
    }

    @Override
    public <U> ArbitraryBuilder<T> setPostCondition(String expression, Class<U> type, Predicate<U> predicate) {
        return this.setPostCondition(expression, type, predicate, Integer.MAX_VALUE);
    }

    @Override
    public <U> ArbitraryBuilder<T> setPostCondition(String expression, Class<U> type, Predicate<U> predicate, int limit) {
        ArbitraryManipulator arbitraryManipulator = this.monkeyManipulatorFactory.newArbitraryManipulator(expression, type, predicate, limit);
        this.context.addManipulator(arbitraryManipulator);
        return this;
    }

    @Override
    @Deprecated
    public <U> ArbitraryBuilder<T> setPostCondition(ExpressionGenerator expressionGenerator, Class<U> type, Predicate<U> predicate, int limit) {
        return this.setPostCondition(this.resolveExpression(expressionGenerator), type, predicate, limit);
    }

    @Override
    public <U> ArbitraryBuilder<T> setPostCondition(PropertySelector propertySelector, Class<U> type, Predicate<U> predicate, int limit) {
        return this.setPostCondition(this.resolveExpression(this.toExpressionGenerator(propertySelector)), type, predicate, limit);
    }

    @Override
    @Deprecated
    public <U> ArbitraryBuilder<T> setPostCondition(ExpressionGenerator expressionGenerator, Class<U> type, Predicate<U> predicate) {
        return this.setPostCondition(this.resolveExpression(expressionGenerator), type, predicate);
    }

    @Override
    public <U> ArbitraryBuilder<T> setPostCondition(PropertySelector propertySelector, Class<U> type, Predicate<U> predicate) {
        return this.setPostCondition(this.resolveExpression(this.toExpressionGenerator(propertySelector)), type, predicate);
    }

    @Override
    public <U> ArbitraryBuilder<U> map(Function<T, U> mapper) {
        LazyArbitrary lazyArbitrary = LazyArbitrary.lazy(() -> mapper.apply(this.sample()));
        return this.generateArbitraryBuilderLazily(lazyArbitrary);
    }

    @Override
    public <U, R> ArbitraryBuilder<R> zipWith(ArbitraryBuilder<U> other, BiFunction<T, U, R> combinator) {
        LazyArbitrary lazyArbitrary = LazyArbitrary.lazy(() -> combinator.apply(this.sample(), other.sample()));
        return this.generateArbitraryBuilderLazily(lazyArbitrary);
    }

    @Override
    public <U, V, R> ArbitraryBuilder<R> zipWith(ArbitraryBuilder<U> other, ArbitraryBuilder<V> another, Combinators.F3<T, U, V, R> combinator) {
        LazyArbitrary lazyArbitrary = LazyArbitrary.lazy(() -> combinator.apply(this.sample(), other.sample(), another.sample()));
        return this.generateArbitraryBuilderLazily(lazyArbitrary);
    }

    @Override
    public <U, V, W, R> ArbitraryBuilder<R> zipWith(ArbitraryBuilder<U> other, ArbitraryBuilder<V> another, ArbitraryBuilder<W> theOther, Combinators.F4<T, U, V, W, R> combinator) {
        LazyArbitrary lazyArbitrary = LazyArbitrary.lazy(() -> combinator.apply(this.sample(), other.sample(), another.sample(), theOther.sample()));
        return this.generateArbitraryBuilderLazily(lazyArbitrary);
    }

    @Override
    public <R> ArbitraryBuilder<R> zipWith(List<ArbitraryBuilder<?>> others, Function<List<?>, R> combinator) {
        LazyArbitrary lazyArbitrary = LazyArbitrary.lazy(() -> {
            ArrayList combinedList = new ArrayList();
            combinedList.add(this.sample());
            for (ArbitraryBuilder other : others) {
                combinedList.add(other.sample());
            }
            return combinator.apply(combinedList);
        });
        return this.generateArbitraryBuilderLazily(lazyArbitrary);
    }

    @Override
    public Arbitrary<T> build() {
        ArbitraryBuilderContext buildContext = this.context.copy();
        return Arbitraries.ofSuppliers((Supplier[])new Supplier[]{() -> this.resolveArbitrary(buildContext).combined()});
    }

    @Override
    public T sample() {
        return (T)this.resolveArbitrary(this.context).combined();
    }

    @Override
    public Stream<T> sampleStream() {
        return this.build().sampleStream();
    }

    @Override
    public List<T> sampleList(int size) {
        return this.sampleStream().limit(size).collect(Collectors.toList());
    }

    @Override
    public ArbitraryBuilder<T> copy() {
        return new DefaultArbitraryBuilder<T>(this.fixtureMonkeyOptions, this.rootProperty, this.resolver, this.traverser, this.monkeyManipulatorFactory, this.context.copy(), this.registeredArbitraryBuilders, this.monkeyContext);
    }

    public ArbitraryBuilderContext getContext() {
        return this.context;
    }

    private CombinableArbitrary<?> resolveArbitrary(ArbitraryBuilderContext context) {
        if (context.isFixed()) {
            if (context.getFixedCombinableArbitrary() == null || context.fixedExpired()) {
                Object fixed = this.resolver.resolve(this.rootProperty, context).combined();
                context.addManipulator(this.monkeyManipulatorFactory.newArbitraryManipulator("$", fixed));
                context.renewFixed(CombinableArbitrary.from((Object)fixed));
            }
            return context.getFixedCombinableArbitrary();
        }
        return this.resolver.resolve(this.rootProperty, context);
    }

    private String resolveExpression(ExpressionGenerator expressionGenerator) {
        return expressionGenerator.generate(property -> {
            PropertyNameResolver propertyNameResolver = this.fixtureMonkeyOptions.getPropertyNameResolver(property);
            return propertyNameResolver.resolve(property);
        });
    }

    private <R> DefaultArbitraryBuilder<R> generateArbitraryBuilderLazily(LazyArbitrary<R> lazyArbitrary) {
        ArbitraryBuilderContext context = new ArbitraryBuilderContext();
        ArbitraryManipulator arbitraryManipulator = this.monkeyManipulatorFactory.newArbitraryManipulator("$", lazyArbitrary);
        context.addManipulator(arbitraryManipulator);
        return new DefaultArbitraryBuilder<T>(this.fixtureMonkeyOptions, new RootProperty((AnnotatedType)new LazyAnnotatedType(() -> lazyArbitrary.getValue())), this.resolver, this.traverser, this.monkeyManipulatorFactory, context, this.registeredArbitraryBuilders, this.monkeyContext);
    }

    private ExpressionGenerator toExpressionGenerator(PropertySelector propertySelector) {
        if (propertySelector instanceof ExpressionGenerator) {
            return (ExpressionGenerator)propertySelector;
        }
        throw new UnsupportedOperationException("Given propertySelector is not supported. type of propertySelector: " + propertySelector.getClass());
    }
}

