/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.resolver;

import com.navercorp.fixturemonkey.ArbitraryBuilder;
import com.navercorp.fixturemonkey.FixtureMonkey;
import com.navercorp.fixturemonkey.api.type.TypeReference;
import com.navercorp.fixturemonkey.api.type.Types;
import com.navercorp.fixturemonkey.buildergroup.ArbitraryBuilderCandidate;
import java.lang.reflect.AnnotatedType;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.UnaryOperator;

class DefaultArbitraryBuilderCandidate<T>
implements ArbitraryBuilderCandidate<T> {
    private final TypeReference<T> typeReference;
    private final Function<FixtureMonkey, ArbitraryBuilder<T>> arbitraryBuilderRegisterer;

    private DefaultArbitraryBuilderCandidate(TypeReference<T> typeReference, Function<FixtureMonkey, ArbitraryBuilder<T>> arbitraryBuilderRegisterer) {
        this.typeReference = typeReference;
        this.arbitraryBuilderRegisterer = arbitraryBuilderRegisterer;
    }

    public static <T> Builder<T> of(Class<T> classType) {
        return new Builder<T>().classType(classType);
    }

    public static <T> Builder<T> of(TypeReference<T> typeReference) {
        return new Builder<T>().typeReference(typeReference);
    }

    @Override
    public Class<?> getClassType() {
        return Types.getActualType((AnnotatedType)Objects.requireNonNull(this.typeReference).getAnnotatedType());
    }

    @Override
    public Function<FixtureMonkey, ArbitraryBuilder<T>> getArbitraryBuilderRegisterer() {
        return this.arbitraryBuilderRegisterer;
    }

    static class Builder<T> {
        private TypeReference<T> typeReference;
        private UnaryOperator<ArbitraryBuilder<T>> builderSpec;

        Builder() {
        }

        public Builder<T> register(UnaryOperator<ArbitraryBuilder<T>> builderSpec) {
            this.builderSpec = builderSpec;
            return this;
        }

        public DefaultArbitraryBuilderCandidate<T> buildWithFixedValue(T value) {
            if (this.typeReference == null) {
                throw new IllegalArgumentException("typeReference must exist for fixed value");
            }
            return new DefaultArbitraryBuilderCandidate<T>(this.typeReference, fixtureMonkey -> fixtureMonkey.giveMeBuilder(value));
        }

        public DefaultArbitraryBuilderCandidate<T> build() {
            if (this.typeReference == null) {
                throw new IllegalArgumentException("typeReference must exist.");
            }
            if (this.builderSpec == null) {
                throw new IllegalArgumentException("builderSpec must be registered.");
            }
            Function registerer = fixtureMonkey -> (ArbitraryBuilder)this.builderSpec.apply(fixtureMonkey.giveMeBuilder(this.typeReference));
            return new DefaultArbitraryBuilderCandidate<T>(this.typeReference, registerer);
        }

        private Builder<T> classType(Class<T> classType) {
            this.typeReference = new TypeReference<T>(classType){};
            return this;
        }

        private Builder<T> typeReference(TypeReference<T> typeReference) {
            this.typeReference = typeReference;
            return this;
        }
    }
}

