/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.tree;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.context.MonkeyContext;
import com.navercorp.fixturemonkey.api.context.MonkeyGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.option.FixtureMonkeyOptions;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.RootProperty;
import com.navercorp.fixturemonkey.customizer.NodeManipulator;
import com.navercorp.fixturemonkey.tree.MetadataCollector;
import com.navercorp.fixturemonkey.tree.NodeResolver;
import com.navercorp.fixturemonkey.tree.ObjectNode;
import com.navercorp.fixturemonkey.tree.ObjectTreeMetadata;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class ObjectTree {
    private final RootProperty rootProperty;
    private final ObjectNode rootNode;
    private final FixtureMonkeyOptions fixtureMonkeyOptions;
    private final ObjectTreeMetadata metadata;
    private final MonkeyContext monkeyContext;

    public ObjectTree(RootProperty rootProperty, ObjectNode rootNode, FixtureMonkeyOptions fixtureMonkeyOptions, MonkeyContext monkeyContext) {
        this.rootProperty = rootProperty;
        this.rootNode = rootNode;
        this.fixtureMonkeyOptions = fixtureMonkeyOptions;
        this.monkeyContext = monkeyContext;
        MetadataCollector metadataCollector = new MetadataCollector(rootNode);
        this.metadata = metadataCollector.collect();
    }

    public ObjectTreeMetadata getMetadata() {
        return this.metadata;
    }

    public void manipulate(NodeResolver nodeResolver, NodeManipulator nodeManipulator) {
        List<ObjectNode> nodes = nodeResolver.resolve(this.rootNode);
        for (ObjectNode node : nodes) {
            nodeManipulator.manipulate(node);
            node.addManipulator(nodeManipulator);
        }
    }

    public CombinableArbitrary<?> generate() {
        return this.generateIntrospected(this.rootNode, null);
    }

    private ArbitraryGeneratorContext generateContext(ObjectNode objectNode, @Nullable ArbitraryGeneratorContext parentContext) {
        HashMap<ArbitraryProperty, ObjectNode> childNodesByArbitraryProperty = new HashMap<ArbitraryProperty, ObjectNode>();
        ArrayList<ArbitraryProperty> childrenProperties = new ArrayList<ArbitraryProperty>();
        ArbitraryProperty arbitraryProperty = objectNode.getArbitraryProperty();
        Property resolvedParentProperty = objectNode.getResolvedProperty();
        List children = objectNode.getChildren().stream().filter(it -> resolvedParentProperty.equals(it.getResolvedParentProperty())).collect(Collectors.toList());
        for (ObjectNode childNode : children) {
            childNodesByArbitraryProperty.put(childNode.getArbitraryProperty(), childNode);
            childrenProperties.add(childNode.getArbitraryProperty());
        }
        MonkeyGeneratorContext monkeyGeneratorContext = this.monkeyContext.retrieveGeneratorContext(this.rootProperty);
        return new ArbitraryGeneratorContext(resolvedParentProperty, arbitraryProperty, childrenProperties, parentContext, (currentContext, prop) -> {
            ObjectNode node = (ObjectNode)childNodesByArbitraryProperty.get(prop);
            if (node == null) {
                return CombinableArbitrary.NOT_GENERATED;
            }
            return this.generateIntrospected(node, (ArbitraryGeneratorContext)currentContext);
        }, monkeyGeneratorContext, this.fixtureMonkeyOptions.getGenerateUniqueMaxTries());
    }

    private CombinableArbitrary<?> generateIntrospected(ObjectNode node, @Nullable ArbitraryGeneratorContext currentContext) {
        CombinableArbitrary generated;
        if (node.getArbitrary() != null) {
            generated = node.getArbitrary().injectNull(node.getArbitraryProperty().getObjectProperty().getNullInject());
        } else {
            CombinableArbitrary cached = this.monkeyContext.getCachedArbitrary(node.getProperty());
            if (node.cacheable() && cached != null) {
                generated = cached;
            } else {
                ArbitraryGeneratorContext childArbitraryGeneratorContext = this.generateContext(node, currentContext);
                generated = this.fixtureMonkeyOptions.getArbitraryGenerator(node.getResolvedProperty()).generate(childArbitraryGeneratorContext);
                if (node.cacheable()) {
                    this.monkeyContext.putCachedArbitrary(node.getProperty(), generated);
                }
            }
        }
        List<Predicate> arbitraryFilters = node.getArbitraryFilters();
        for (Predicate predicate : arbitraryFilters) {
            generated = generated.filter(this.fixtureMonkeyOptions.getGenerateMaxTries(), predicate);
        }
        return generated;
    }
}

