/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.tree;

import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGenerator;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.generator.ContainerProperty;
import com.navercorp.fixturemonkey.api.generator.ContainerPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.ContainerPropertyGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ObjectProperty;
import com.navercorp.fixturemonkey.api.generator.ObjectPropertyGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.SingleValueObjectPropertyGenerator;
import com.navercorp.fixturemonkey.api.matcher.MatcherOperator;
import com.navercorp.fixturemonkey.api.option.FixtureMonkeyOptions;
import com.navercorp.fixturemonkey.api.property.MapEntryElementProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyGenerator;
import com.navercorp.fixturemonkey.api.random.Randoms;
import com.navercorp.fixturemonkey.api.type.Types;
import com.navercorp.fixturemonkey.customizer.ContainerInfoManipulator;
import com.navercorp.fixturemonkey.tree.ObjectNode;
import com.navercorp.fixturemonkey.tree.TraverseContext;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class ArbitraryTraverser {
    private final FixtureMonkeyOptions fixtureMonkeyOptions;

    public ArbitraryTraverser(FixtureMonkeyOptions fixtureMonkeyOptions) {
        this.fixtureMonkeyOptions = fixtureMonkeyOptions;
    }

    public ObjectNode traverse(Property property, List<ContainerInfoManipulator> containerInfoManipulators, List<MatcherOperator<List<ContainerInfoManipulator>>> registeredContainerInfoManipulators, Map<Class<?>, List<Property>> propertyConfigurers) {
        ContainerPropertyGenerator containerPropertyGenerator = this.fixtureMonkeyOptions.getContainerPropertyGenerator(property);
        boolean container = containerPropertyGenerator != null;
        Object objectPropertyGenerator = container ? SingleValueObjectPropertyGenerator.INSTANCE : this.fixtureMonkeyOptions.getObjectPropertyGenerator(property);
        ObjectProperty objectProperty = objectPropertyGenerator.generate(new ObjectPropertyGeneratorContext(property, null, null, container, this.getPropertyGenerator(propertyConfigurers), this.fixtureMonkeyOptions.getPropertyNameResolver(property), this.fixtureMonkeyOptions.getNullInjectGenerator(property)));
        ContainerProperty containerProperty = null;
        ContainerInfoManipulator containerInfoManipulator = null;
        if (container) {
            containerInfoManipulator = this.resolveAppliedContainerInfoManipulator(containerInfoManipulators, Collections.singletonList(objectProperty));
            ArbitraryContainerInfo containerInfo = containerInfoManipulator != null ? containerInfoManipulator.getContainerInfo() : null;
            containerProperty = containerPropertyGenerator.generate(new ContainerPropertyGeneratorContext(property, null, containerInfo, this.fixtureMonkeyOptions.getArbitraryContainerInfoGenerator(property)));
        }
        ArbitraryProperty arbitraryProperty = new ArbitraryProperty(objectProperty, container);
        ArrayList<ArbitraryProperty> parentArbitraryProperties = new ArrayList<ArbitraryProperty>();
        parentArbitraryProperties.add(arbitraryProperty);
        ObjectNode rootNode = this.traverse(arbitraryProperty, containerProperty, null, new TraverseContext(arbitraryProperty, parentArbitraryProperties, containerInfoManipulators, registeredContainerInfoManipulators, propertyConfigurers));
        if (containerInfoManipulator != null) {
            rootNode.addContainerManipulator(containerInfoManipulator);
        }
        return rootNode;
    }

    private PropertyGenerator getPropertyGenerator(Map<Class<?>, List<Property>> propertyConfigurers) {
        return property -> {
            Class type = Types.getActualType((Type)property.getType());
            List propertyConfigurer = (List)propertyConfigurers.get(type);
            if (propertyConfigurer != null) {
                return propertyConfigurer;
            }
            PropertyGenerator propertyGenerator = this.fixtureMonkeyOptions.getOptionalPropertyGenerator(property);
            if (propertyGenerator != null) {
                return propertyGenerator.generateChildProperties(property);
            }
            ArbitraryGenerator defaultArbitraryGenerator = this.fixtureMonkeyOptions.getDefaultArbitraryGenerator();
            PropertyGenerator defaultArbitraryGeneratorPropertyGenerator = defaultArbitraryGenerator.getRequiredPropertyGenerator(property);
            if (defaultArbitraryGeneratorPropertyGenerator != null) {
                return defaultArbitraryGeneratorPropertyGenerator.generateChildProperties(property);
            }
            return this.fixtureMonkeyOptions.getDefaultPropertyGenerator().generateChildProperties(property);
        };
    }

    private ObjectNode traverse(ArbitraryProperty arbitraryProperty, @Nullable ContainerProperty containerProperty, @Nullable Property resolvedParentProperty, TraverseContext context) {
        boolean container;
        boolean bl = container = containerProperty != null;
        if (container) {
            return this.generateContainerNode(arbitraryProperty, containerProperty, resolvedParentProperty, context);
        }
        return this.generateObjectNode(arbitraryProperty, resolvedParentProperty, context);
    }

    private ObjectNode generateObjectNode(ArbitraryProperty arbitraryProperty, @Nullable Property resolvedParentProperty, TraverseContext context) {
        ObjectProperty objectProperty = arbitraryProperty.getObjectProperty();
        ArrayList<ObjectNode> children = new ArrayList<ObjectNode>();
        Map childPropertyListsByCandidateProperty = objectProperty.getChildPropertyListsByCandidateProperty();
        for (Map.Entry childPropertiesByCandidateProperty : childPropertyListsByCandidateProperty.entrySet()) {
            List childProperties = (List)childPropertiesByCandidateProperty.getValue();
            Property candidateProperty = (Property)childPropertiesByCandidateProperty.getKey();
            children.addAll(this.generateChildrenNodes(childProperties, arbitraryProperty, null, candidateProperty, context));
        }
        Property resolvedProperty = (Property)new ArrayList(childPropertyListsByCandidateProperty.keySet()).get(Randoms.nextInt((int)childPropertyListsByCandidateProperty.size()));
        return new ObjectNode(resolvedParentProperty, resolvedProperty, arbitraryProperty, children);
    }

    private ObjectNode generateContainerNode(ArbitraryProperty arbitraryProperty, ContainerProperty containerProperty, @Nullable Property resolvedParentProperty, TraverseContext context) {
        ObjectProperty objectProperty = arbitraryProperty.getObjectProperty();
        Property resolvedProperty = objectProperty.getProperty();
        List elementProperties = containerProperty.getElementProperties();
        return new ObjectNode(resolvedParentProperty, resolvedProperty, arbitraryProperty, this.generateChildrenNodes(elementProperties, arbitraryProperty, containerProperty, objectProperty.getProperty(), context));
    }

    private List<ObjectNode> generateChildrenNodes(List<Property> childProperties, ArbitraryProperty parentArbitraryProperty, @Nullable ContainerProperty parentContainerProperty, Property resolvedParentProperty, TraverseContext context) {
        ArrayList<ObjectNode> children = new ArrayList<ObjectNode>();
        List<ContainerInfoManipulator> containerInfoManipulators = context.getContainerInfoManipulators();
        boolean container = parentContainerProperty != null;
        for (int sequence = 0; sequence < childProperties.size(); ++sequence) {
            Property childProperty = childProperties.get(sequence);
            if (context.isTraversed(childProperty) && !(resolvedParentProperty instanceof MapEntryElementProperty)) continue;
            ContainerPropertyGenerator containerPropertyGenerator = this.fixtureMonkeyOptions.getContainerPropertyGenerator(childProperty);
            boolean childContainer = containerPropertyGenerator != null;
            Object objectPropertyGenerator = childContainer ? SingleValueObjectPropertyGenerator.INSTANCE : this.fixtureMonkeyOptions.getObjectPropertyGenerator(childProperty);
            int index = sequence;
            if (parentArbitraryProperty.getObjectProperty().getProperty() instanceof MapEntryElementProperty) {
                index /= 2;
            }
            ObjectProperty childObjectProperty = objectPropertyGenerator.generate(new ObjectPropertyGeneratorContext(childProperty, container ? Integer.valueOf(index) : null, parentArbitraryProperty, childContainer, this.getPropertyGenerator(context.getPropertyConfigurers()), this.fixtureMonkeyOptions.getPropertyNameResolver(childProperty), this.fixtureMonkeyOptions.getNullInjectGenerator(childProperty)));
            ContainerProperty childContainerProperty = null;
            ContainerInfoManipulator appliedContainerInfoManipulator = null;
            if (childContainer) {
                List<ObjectProperty> objectProperties = context.getArbitraryProperties().stream().map(ArbitraryProperty::getObjectProperty).collect(Collectors.toList());
                objectProperties.add(childObjectProperty);
                appliedContainerInfoManipulator = this.resolveAppliedContainerInfoManipulator(containerInfoManipulators, objectProperties);
                ArbitraryContainerInfo containerInfo = appliedContainerInfoManipulator != null ? appliedContainerInfoManipulator.getContainerInfo() : null;
                childContainerProperty = containerPropertyGenerator.generate(new ContainerPropertyGeneratorContext(childProperty, container ? Integer.valueOf(index) : null, containerInfo, this.fixtureMonkeyOptions.getArbitraryContainerInfoGenerator(childProperty)));
            }
            ArbitraryProperty childArbitraryProperty = new ArbitraryProperty(childObjectProperty, childContainerProperty != null);
            ObjectNode childNode = this.traverse(childArbitraryProperty, childContainerProperty, resolvedParentProperty, context.appendArbitraryProperty(childArbitraryProperty));
            if (appliedContainerInfoManipulator != null) {
                childNode.addContainerManipulator(appliedContainerInfoManipulator);
            }
            children.add(childNode);
        }
        return children;
    }

    @Nullable
    private ContainerInfoManipulator resolveAppliedContainerInfoManipulator(List<ContainerInfoManipulator> containerInfoManipulators, List<ObjectProperty> objectProperties) {
        ContainerInfoManipulator appliedContainerInfoManipulator = null;
        for (ContainerInfoManipulator containerInfoManipulator : containerInfoManipulators) {
            if (!containerInfoManipulator.isMatch(objectProperties)) continue;
            appliedContainerInfoManipulator = containerInfoManipulator;
        }
        return appliedContainerInfoManipulator;
    }
}

