/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.customizer;

import com.navercorp.fixturemonkey.tree.CompositeNodeResolver;
import com.navercorp.fixturemonkey.tree.NodeResolver;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.5.0", status=API.Status.MAINTAINED)
final class InnerSpecState {
    @Nullable
    private NodeResolverObjectHolder objectHolder;
    @Nullable
    private ContainerInfoHolder containerInfoHolder;
    @Nullable
    private FilterHolder filterHolder;

    InnerSpecState() {
    }

    void setObjectHolder(@Nullable NodeResolverObjectHolder objectHolder) {
        this.objectHolder = objectHolder;
    }

    void setContainerInfoHolder(@Nullable ContainerInfoHolder containerInfoHolder) {
        this.containerInfoHolder = containerInfoHolder;
    }

    void setFilterHolder(@Nullable FilterHolder filterHolder) {
        this.filterHolder = filterHolder;
    }

    @Nullable
    NodeResolverObjectHolder getObjectHolder() {
        return this.objectHolder;
    }

    @Nullable
    ContainerInfoHolder getContainerInfoHolder() {
        return this.containerInfoHolder;
    }

    @Nullable
    FilterHolder getFilterHolder() {
        return this.filterHolder;
    }

    InnerSpecState withPrefix(NodeResolver nodeResolver) {
        InnerSpecState newState = new InnerSpecState();
        if (this.objectHolder != null) {
            newState.objectHolder = new NodeResolverObjectHolder(this.objectHolder.sequence, new CompositeNodeResolver(nodeResolver, this.objectHolder.nodeResolver), this.objectHolder.value);
        }
        if (this.filterHolder != null) {
            newState.filterHolder = new FilterHolder(this.filterHolder.sequence, new CompositeNodeResolver(nodeResolver, this.filterHolder.nodeResolver), this.filterHolder.type, this.filterHolder.predicate);
        }
        if (this.containerInfoHolder != null) {
            newState.containerInfoHolder = new ContainerInfoHolder(this.containerInfoHolder.sequence, new CompositeNodeResolver(nodeResolver, this.containerInfoHolder.nodeResolver), this.containerInfoHolder.elementMinSize, this.containerInfoHolder.elementMaxSize);
        }
        return newState;
    }

    static final class ManipulatorHolderSet {
        private final List<NodeResolverObjectHolder> nodeResolverObjectHolders;
        private final List<ContainerInfoHolder> containerInfoManipulators;
        private final List<FilterHolder> postConditionManipulators;

        public ManipulatorHolderSet(List<NodeResolverObjectHolder> nodeResolverObjectHolders, List<ContainerInfoHolder> containerInfoManipulators, List<FilterHolder> postConditionManipulators) {
            this.nodeResolverObjectHolders = nodeResolverObjectHolders;
            this.containerInfoManipulators = containerInfoManipulators;
            this.postConditionManipulators = postConditionManipulators;
        }

        public List<NodeResolverObjectHolder> getNodeResolverObjectHolders() {
            return this.nodeResolverObjectHolders;
        }

        public List<ContainerInfoHolder> getContainerInfoManipulators() {
            return this.containerInfoManipulators;
        }

        public List<FilterHolder> getPostConditionManipulators() {
            return this.postConditionManipulators;
        }
    }

    public static class NodeResolverObjectHolder {
        private final int sequence;
        private final NodeResolver nodeResolver;
        private final Object value;

        public NodeResolverObjectHolder(int sequence, NodeResolver nodeResolver, Object value) {
            this.sequence = sequence;
            this.nodeResolver = nodeResolver;
            this.value = value;
        }

        NodeResolver getNodeResolver() {
            return this.nodeResolver;
        }

        Object getValue() {
            return this.value;
        }

        int getSequence() {
            return this.sequence;
        }
    }

    public static class FilterHolder {
        private final int sequence;
        private final NodeResolver nodeResolver;
        private final Class<?> type;
        private final Predicate<?> predicate;

        public FilterHolder(int sequence, NodeResolver nodeResolver, Class<?> type, Predicate<?> predicate) {
            this.sequence = sequence;
            this.nodeResolver = nodeResolver;
            this.type = type;
            this.predicate = predicate;
        }

        public int getSequence() {
            return this.sequence;
        }

        NodeResolver getNodeResolver() {
            return this.nodeResolver;
        }

        Class<?> getType() {
            return this.type;
        }

        Predicate<?> getPredicate() {
            return this.predicate;
        }
    }

    public static class ContainerInfoHolder {
        private final int sequence;
        private final NodeResolver nodeResolver;
        private final int elementMinSize;
        private final int elementMaxSize;

        public ContainerInfoHolder(int sequence, NodeResolver nodeResolver, int elementMinSize, int elementMaxSize) {
            this.sequence = sequence;
            this.nodeResolver = nodeResolver;
            this.elementMinSize = elementMinSize;
            this.elementMaxSize = elementMaxSize;
        }

        int getSequence() {
            return this.sequence;
        }

        NodeResolver getNodeResolver() {
            return this.nodeResolver;
        }

        int getElementMinSize() {
            return this.elementMinSize;
        }

        int getElementMaxSize() {
            return this.elementMaxSize;
        }
    }
}

