/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.customizer;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.container.DecomposableJavaContainer;
import com.navercorp.fixturemonkey.api.container.DecomposedContainerValueFactory;
import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.property.ConcreteTypeDefinition;
import com.navercorp.fixturemonkey.api.property.MapEntryElementProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.Types;
import com.navercorp.fixturemonkey.customizer.ContainerInfoManipulator;
import com.navercorp.fixturemonkey.customizer.NodeManipulator;
import com.navercorp.fixturemonkey.tree.ArbitraryTraverser;
import com.navercorp.fixturemonkey.tree.IdentityNodeResolver;
import com.navercorp.fixturemonkey.tree.ObjectNode;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class NodeSetDecomposedValueManipulator<T>
implements NodeManipulator {
    private final int sequence;
    private final ArbitraryTraverser traverser;
    private final DecomposedContainerValueFactory decomposedContainerValueFactory;
    @Nullable
    private final T value;

    public NodeSetDecomposedValueManipulator(int sequence, ArbitraryTraverser traverser, DecomposedContainerValueFactory decomposedContainerValueFactory, @Nullable T value) {
        this.sequence = sequence;
        this.traverser = traverser;
        this.decomposedContainerValueFactory = decomposedContainerValueFactory;
        this.value = value;
    }

    @Override
    public void manipulate(ObjectNode objectNode) {
        Class actualType = Types.getActualType((Type)objectNode.getProperty().getType());
        if (this.value != null && !Types.isAssignable(this.value.getClass(), (Class)actualType)) {
            String parentNodeLogMessage = objectNode.getResolvedParentProperty() != null ? String.format("parent node type : %s", objectNode.getResolvedParentProperty().getType().getTypeName()) : "";
            throw new IllegalArgumentException(String.format("The value is not of the same type as the property.\n%s node name: %s, node type: %s, value type: %s", parentNodeLogMessage, objectNode.getArbitraryProperty().getObjectProperty().getResolvedPropertyName(), objectNode.getProperty().getType().getTypeName(), this.value.getClass().getTypeName()));
        }
        this.setValue(objectNode, this.value);
    }

    private void setValue(ObjectNode objectNode, @Nullable Object value) {
        objectNode.setArbitraryProperty(objectNode.getArbitraryProperty().withNullInject(0.0));
        if (value == null) {
            objectNode.addManipulator(node -> node.setArbitrary(CombinableArbitrary.from(null)));
            objectNode.setArbitraryProperty(objectNode.getArbitraryProperty().withNullInject(1.0));
            return;
        }
        boolean container = objectNode.getArbitraryProperty().isContainer();
        if (container) {
            boolean forced;
            DecomposableJavaContainer decomposableJavaContainer = this.decomposedContainerValueFactory.from(value);
            Object containerValue = decomposableJavaContainer.getJavaContainer();
            int decomposedContainerSize = decomposableJavaContainer.getSize();
            ContainerInfoManipulator appliedContainerInfoManipulator = objectNode.getAppliedContainerInfoManipulator();
            boolean bl = forced = !(objectNode.getProperty() instanceof MapEntryElementProperty) && (appliedContainerInfoManipulator == null || this.sequence > appliedContainerInfoManipulator.getManipulatingSequence());
            if (forced) {
                ContainerInfoManipulator containerInfoManipulator = new ContainerInfoManipulator(IdentityNodeResolver.INSTANCE.toNextNodePredicate(), new ArbitraryContainerInfo(decomposedContainerSize, decomposedContainerSize), this.sequence);
                ObjectNode newNode = this.traverser.traverse(objectNode.getProperty(), Collections.singletonList(containerInfoManipulator), Collections.emptyList(), Collections.emptyMap());
                objectNode.setChildren(newNode.getChildren());
            }
            List<ObjectNode> children = objectNode.getChildren();
            if (objectNode.getArbitraryProperty().getObjectProperty().getProperty() instanceof MapEntryElementProperty) {
                decomposedContainerSize *= 2;
            }
            int decomposedNodeSize = Math.min(decomposedContainerSize, children.size());
            for (int i = 0; i < decomposedNodeSize; ++i) {
                ObjectNode child = children.get(i);
                Property childProperty = child.getProperty();
                this.setValue(child, childProperty.getValue(containerValue));
            }
            return;
        }
        List<ObjectNode> children = objectNode.getChildren();
        if (children.isEmpty() || Types.getActualType((Type)objectNode.getResolvedProperty().getType()).isInterface()) {
            CombinableArbitrary combinableArbitrary = CombinableArbitrary.from((Object)value);
            objectNode.addManipulator(node -> node.setArbitrary(combinableArbitrary));
            objectNode.setArbitrary(combinableArbitrary);
            return;
        }
        List concreteTypeDefinitions = objectNode.getArbitraryProperty().getConcreteTypeDefinitions();
        for (ConcreteTypeDefinition concreteTypeDefinition : concreteTypeDefinitions) {
            Class actualConcreteType = Types.getActualType((Type)concreteTypeDefinition.getConcreteProperty().getType());
            if (!Types.isAssignable(value.getClass(), (Class)actualConcreteType)) continue;
            Property resolvedParentProperty = concreteTypeDefinition.getConcreteProperty();
            if (Types.isAssignable((Class)actualConcreteType, value.getClass())) {
                objectNode.setResolvedProperty(resolvedParentProperty);
            }
            List childProperties = concreteTypeDefinition.getChildPropertyLists();
            for (ObjectNode child : children) {
                if (!childProperties.contains(child.getProperty()) || !resolvedParentProperty.equals(child.getResolvedParentProperty())) continue;
                Property childProperty = child.getProperty();
                this.setValue(child, childProperty.getValue(value));
            }
        }
    }
}

