/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.tree;

import com.navercorp.fixturemonkey.tree.NextNodePredicate;
import com.navercorp.fixturemonkey.tree.NodeResolver;
import com.navercorp.fixturemonkey.tree.ObjectNode;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class DefaultNodeResolver
implements NodeResolver {
    private final NextNodePredicate nextNodePredicate;

    public DefaultNodeResolver(NextNodePredicate nextNodePredicate) {
        this.nextNodePredicate = nextNodePredicate;
    }

    @Override
    public List<ObjectNode> resolve(ObjectNode objectNode) {
        List<ObjectNode> resolved = objectNode.getChildren().stream().filter(it -> this.nextNodePredicate.test(it.getArbitraryProperty().getObjectProperty())).collect(Collectors.toList());
        objectNode.setArbitraryProperty(objectNode.getArbitraryProperty().withNullInject(0.0));
        for (ObjectNode node : resolved) {
            node.setArbitraryProperty(node.getArbitraryProperty().withNullInject(0.0));
        }
        return resolved;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultNodeResolver that = (DefaultNodeResolver)obj;
        return this.nextNodePredicate.equals(that.nextNodePredicate);
    }

    public int hashCode() {
        return Objects.hash(this.nextNodePredicate);
    }

    @Override
    public List<NextNodePredicate> toNextNodePredicate() {
        return Collections.singletonList(this.nextNodePredicate);
    }
}

