/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.tree;

import com.navercorp.fixturemonkey.api.property.SingleElementProperty;
import com.navercorp.fixturemonkey.tree.NextNodePredicate;
import com.navercorp.fixturemonkey.tree.NodeResolver;
import com.navercorp.fixturemonkey.tree.ObjectNode;
import com.navercorp.fixturemonkey.tree.StartNodePredicate;
import java.util.Collections;
import java.util.List;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class IdentityNodeResolver
implements NodeResolver {
    public static final IdentityNodeResolver INSTANCE = new IdentityNodeResolver();

    private IdentityNodeResolver() {
    }

    @Override
    public List<ObjectNode> resolve(ObjectNode objectNode) {
        ObjectNode resultNode = this.getChildNodeIfWrapped(objectNode);
        resultNode.setArbitraryProperty(resultNode.getArbitraryProperty().withNullInject(0.0));
        return Collections.singletonList(resultNode);
    }

    private ObjectNode getChildNodeIfWrapped(ObjectNode objectNode) {
        ObjectNode searchNode = objectNode;
        while (this.isWrappedNode(searchNode)) {
            searchNode = searchNode.getChildren().get(0);
        }
        return searchNode;
    }

    private boolean isWrappedNode(ObjectNode searchNode) {
        List<ObjectNode> children = searchNode.getChildren();
        return children.size() == 1 && children.get(0).getResolvedProperty() instanceof SingleElementProperty;
    }

    @Override
    public List<NextNodePredicate> toNextNodePredicate() {
        return Collections.singletonList(StartNodePredicate.INSTANCE);
    }
}

