/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.tree;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.lazy.LazyArbitrary;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyPath;
import com.navercorp.fixturemonkey.customizer.ContainerInfoManipulator;
import com.navercorp.fixturemonkey.customizer.NodeManipulator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class ObjectNode {
    @Nullable
    private final Property resolvedParentProperty;
    private Property resolvedProperty;
    private ArbitraryProperty arbitraryProperty;
    @Nullable
    private ObjectNode parent = null;
    private List<ObjectNode> children;
    @Nullable
    private CombinableArbitrary<?> arbitrary;
    private final List<NodeManipulator> manipulators = new ArrayList<NodeManipulator>();
    private final List<ContainerInfoManipulator> containerInfoManipulators = new ArrayList<ContainerInfoManipulator>();
    private final List<Predicate> arbitraryFilters = new ArrayList<Predicate>();
    private final List<Function<CombinableArbitrary<?>, CombinableArbitrary<?>>> arbitraryCustomizers = new ArrayList();
    private final LazyArbitrary<Boolean> childNotCacheable = LazyArbitrary.lazy(() -> {
        for (ObjectNode child : this.children) {
            if (!child.manipulated() && !((Boolean)child.childNotCacheable.getValue()).booleanValue() && !child.arbitraryProperty.isContainer()) continue;
            return true;
        }
        return false;
    });
    private final LazyArbitrary<PropertyPath> lazyPropertyPath = LazyArbitrary.lazy(() -> {
        if (this.parent == null) {
            return new PropertyPath(this.resolvedProperty, null, 1);
        }
        PropertyPath parentPropertyPath = (PropertyPath)this.parent.getLazyPropertyPath().getValue();
        return new PropertyPath(this.resolvedProperty, parentPropertyPath, parentPropertyPath.getDepth() + 1);
    });

    ObjectNode(@Nullable Property resolvedParentProperty, Property resolvedProperty, ArbitraryProperty arbitraryProperty, List<ObjectNode> children) {
        this.resolvedParentProperty = resolvedParentProperty;
        this.resolvedProperty = resolvedProperty;
        this.arbitraryProperty = arbitraryProperty;
        this.setChildren(children);
    }

    public void setArbitraryProperty(ArbitraryProperty arbitraryProperty) {
        this.arbitraryProperty = arbitraryProperty;
    }

    public void setChildren(List<ObjectNode> children) {
        this.children = children;
        for (ObjectNode child : this.children) {
            child.parent = this;
        }
    }

    public void setResolvedProperty(Property resolvedProperty) {
        this.resolvedProperty = resolvedProperty;
    }

    @Nullable
    public Property getResolvedParentProperty() {
        return this.resolvedParentProperty;
    }

    public ArbitraryProperty getArbitraryProperty() {
        return this.arbitraryProperty;
    }

    public Property getProperty() {
        return this.getArbitraryProperty().getObjectProperty().getProperty();
    }

    public List<ObjectNode> getChildren() {
        return this.children;
    }

    @Nullable
    public CombinableArbitrary<?> getArbitrary() {
        return this.arbitrary;
    }

    public void setArbitrary(@Nullable CombinableArbitrary<?> arbitrary) {
        this.arbitrary = arbitrary;
    }

    public Property getResolvedProperty() {
        return this.resolvedProperty;
    }

    public void addArbitraryFilter(Predicate filter) {
        this.arbitraryFilters.add(filter);
    }

    public void addManipulator(NodeManipulator nodeManipulator) {
        this.manipulators.add(nodeManipulator);
    }

    public void addContainerManipulator(ContainerInfoManipulator containerInfoManipulator) {
        this.containerInfoManipulators.add(containerInfoManipulator);
    }

    public List<Predicate> getArbitraryFilters() {
        return this.arbitraryFilters;
    }

    public void addArbitraryCustomizer(Function<CombinableArbitrary<?>, CombinableArbitrary<?>> arbitraryCustomizer) {
        this.arbitraryCustomizers.add(arbitraryCustomizer);
    }

    public List<Function<CombinableArbitrary<?>, CombinableArbitrary<?>>> getArbitraryCustomizers() {
        return this.arbitraryCustomizers;
    }

    public boolean manipulated() {
        return !this.manipulators.isEmpty() || !this.containerInfoManipulators.isEmpty();
    }

    public boolean cacheable() {
        return !this.manipulated() && !this.arbitraryProperty.isContainer() && (Boolean)this.childNotCacheable.getValue() == false;
    }

    @Nullable
    public ObjectNode getParent() {
        return this.parent;
    }

    @Nullable
    public ContainerInfoManipulator getAppliedContainerInfoManipulator() {
        if (this.containerInfoManipulators.isEmpty()) {
            return null;
        }
        return this.containerInfoManipulators.get(this.containerInfoManipulators.size() - 1);
    }

    public LazyArbitrary<PropertyPath> getLazyPropertyPath() {
        return this.lazyPropertyPath;
    }
}

