/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.tree;

import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.matcher.MatcherOperator;
import com.navercorp.fixturemonkey.api.property.MapEntryElementProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.customizer.ContainerInfoManipulator;
import com.navercorp.fixturemonkey.tree.PropertyPredicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.INTERNAL)
final class TraverseContext {
    private final List<ArbitraryProperty> arbitraryProperties;
    private final List<ContainerInfoManipulator> containerInfoManipulators;
    private final List<MatcherOperator<List<ContainerInfoManipulator>>> registeredContainerInfoManipulators;
    private final Map<Class<?>, List<Property>> propertyConfigurers;

    TraverseContext(List<ArbitraryProperty> arbitraryProperties, List<ContainerInfoManipulator> containerInfoManipulators, List<MatcherOperator<List<ContainerInfoManipulator>>> registeredContainerInfoManipulators, Map<Class<?>, List<Property>> propertyConfigurers) {
        this.arbitraryProperties = arbitraryProperties;
        this.containerInfoManipulators = containerInfoManipulators;
        this.registeredContainerInfoManipulators = registeredContainerInfoManipulators;
        this.propertyConfigurers = propertyConfigurers;
    }

    @Nullable
    public ArbitraryProperty getRootArbitraryProperty() {
        return this.arbitraryProperties.get(0);
    }

    public List<ArbitraryProperty> getArbitraryProperties() {
        return this.arbitraryProperties;
    }

    public List<ContainerInfoManipulator> getContainerInfoManipulators() {
        return this.containerInfoManipulators;
    }

    public Map<Class<?>, List<Property>> getPropertyConfigurers() {
        return this.propertyConfigurers;
    }

    public TraverseContext appendArbitraryProperty(ArbitraryProperty arbitraryProperty) {
        ArrayList<ArbitraryProperty> arbitraryProperties = new ArrayList<ArbitraryProperty>(this.arbitraryProperties);
        arbitraryProperties.add(arbitraryProperty);
        List registeredContainerManipulators = this.registeredContainerInfoManipulators.stream().filter(it -> it.match(arbitraryProperty.getObjectProperty().getProperty())).map(MatcherOperator::getOperator).findFirst().orElse(Collections.emptyList());
        List concatRegisteredContainerManipulator = registeredContainerManipulators.stream().map(it -> it.withPrependNextNodePredicate(new PropertyPredicate(arbitraryProperty.getObjectProperty().getProperty()))).collect(Collectors.toList());
        ArrayList<ContainerInfoManipulator> concat = new ArrayList<ContainerInfoManipulator>();
        concat.addAll(concatRegisteredContainerManipulator);
        concat.addAll(this.containerInfoManipulators);
        return new TraverseContext(arbitraryProperties, concat, this.registeredContainerInfoManipulators, this.propertyConfigurers);
    }

    public boolean isTraversed(Property property) {
        return this.arbitraryProperties.stream().skip(1L).anyMatch(it -> TraverseContext.isSameType(property, it.getObjectProperty().getProperty()));
    }

    @Nullable
    public ArbitraryProperty getLastArbitraryProperty() {
        if (this.arbitraryProperties.isEmpty()) {
            return null;
        }
        return this.arbitraryProperties.get(this.arbitraryProperties.size() - 1);
    }

    private static boolean isSameType(Property p1, Property p2) {
        boolean notMapEntry = !(p1 instanceof MapEntryElementProperty) || !(p2 instanceof MapEntryElementProperty);
        return notMapEntry && p1.getAnnotatedType().getType().equals(p2.getAnnotatedType().getType());
    }
}

