/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey;

import com.navercorp.fixturemonkey.ArbitraryBuilder;
import com.navercorp.fixturemonkey.FixtureMonkey;
import com.navercorp.fixturemonkey.api.constraint.JavaConstraintGenerator;
import com.navercorp.fixturemonkey.api.container.DecomposedContainerValueFactory;
import com.navercorp.fixturemonkey.api.context.MonkeyContext;
import com.navercorp.fixturemonkey.api.context.MonkeyContextBuilder;
import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfoGenerator;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGenerator;
import com.navercorp.fixturemonkey.api.generator.ContainerPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.InterfaceObjectPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.NullInjectGenerator;
import com.navercorp.fixturemonkey.api.generator.ObjectPropertyGenerator;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.MatchArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.NullArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.matcher.AssignableTypeMatcher;
import com.navercorp.fixturemonkey.api.matcher.ExactTypeMatcher;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.matcher.MatcherOperator;
import com.navercorp.fixturemonkey.api.option.FixtureMonkeyOptions;
import com.navercorp.fixturemonkey.api.option.FixtureMonkeyOptionsBuilder;
import com.navercorp.fixturemonkey.api.plugin.InterfacePlugin;
import com.navercorp.fixturemonkey.api.plugin.Plugin;
import com.navercorp.fixturemonkey.api.property.CandidateConcretePropertyResolver;
import com.navercorp.fixturemonkey.api.property.PropertyGenerator;
import com.navercorp.fixturemonkey.api.property.PropertyNameResolver;
import com.navercorp.fixturemonkey.api.random.Randoms;
import com.navercorp.fixturemonkey.api.type.Types;
import com.navercorp.fixturemonkey.api.validator.ArbitraryValidator;
import com.navercorp.fixturemonkey.buildergroup.ArbitraryBuilderCandidate;
import com.navercorp.fixturemonkey.buildergroup.ArbitraryBuilderGroup;
import com.navercorp.fixturemonkey.customizer.MonkeyManipulatorFactory;
import com.navercorp.fixturemonkey.expression.ArbitraryExpressionFactory;
import com.navercorp.fixturemonkey.expression.MonkeyExpressionFactory;
import com.navercorp.fixturemonkey.resolver.ManipulatorOptimizer;
import com.navercorp.fixturemonkey.resolver.NoneManipulatorOptimizer;
import com.navercorp.fixturemonkey.tree.ApplyStrictModeResolver;
import com.navercorp.fixturemonkey.tree.ArbitraryTraverser;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class FixtureMonkeyBuilder {
    private final FixtureMonkeyOptionsBuilder fixtureMonkeyOptionsBuilder = FixtureMonkeyOptions.builder();
    private final List<MatcherOperator<Function<FixtureMonkey, ? extends ArbitraryBuilder<?>>>> registeredArbitraryBuilders = new ArrayList();
    private ManipulatorOptimizer manipulatorOptimizer = new NoneManipulatorOptimizer();
    private MonkeyExpressionFactory monkeyExpressionFactory = new ArbitraryExpressionFactory();
    private final MonkeyContextBuilder monkeyContextBuilder = MonkeyContext.builder();
    private long seed = System.nanoTime();
    private InterfacePlugin defaultInterfacePlugin = new InterfacePlugin();

    public FixtureMonkeyBuilder pushPropertyGenerator(MatcherOperator<PropertyGenerator> propertyGenerator) {
        this.fixtureMonkeyOptionsBuilder.insertFirstPropertyGenerator(propertyGenerator);
        return this;
    }

    public FixtureMonkeyBuilder pushAssignableTypePropertyGenerator(Class<?> type, PropertyGenerator propertyGenerator) {
        this.fixtureMonkeyOptionsBuilder.insertFirstPropertyGenerator(type, propertyGenerator);
        return this;
    }

    public FixtureMonkeyBuilder pushExactTypePropertyGenerator(Class<?> type, PropertyGenerator propertyGenerator) {
        this.fixtureMonkeyOptionsBuilder.insertFirstPropertyGenerator(MatcherOperator.assignableTypeMatchOperator(type, (Object)propertyGenerator));
        return this;
    }

    public FixtureMonkeyBuilder manipulatorOptimizer(ManipulatorOptimizer manipulatorOptimizer) {
        this.manipulatorOptimizer = manipulatorOptimizer;
        return this;
    }

    public FixtureMonkeyBuilder defaultObjectPropertyGenerator(ObjectPropertyGenerator objectPropertyGenerator) {
        this.fixtureMonkeyOptionsBuilder.defaultObjectPropertyGenerator(objectPropertyGenerator);
        return this;
    }

    public FixtureMonkeyBuilder pushAssignableTypeObjectPropertyGenerator(Class<?> type, ObjectPropertyGenerator objectPropertyGenerator) {
        this.fixtureMonkeyOptionsBuilder.insertFirstArbitraryObjectPropertyGenerator(type, objectPropertyGenerator);
        return this;
    }

    public FixtureMonkeyBuilder pushExactTypeObjectPropertyGenerator(Class<?> type, ObjectPropertyGenerator objectPropertyGenerator) {
        this.fixtureMonkeyOptionsBuilder.insertFirstArbitraryObjectPropertyGenerator(MatcherOperator.exactTypeMatchOperator(type, (Object)objectPropertyGenerator));
        return this;
    }

    public FixtureMonkeyBuilder pushObjectPropertyGenerator(MatcherOperator<ObjectPropertyGenerator> objectPropertyGenerator) {
        this.fixtureMonkeyOptionsBuilder.insertFirstArbitraryObjectPropertyGenerator(objectPropertyGenerator);
        return this;
    }

    public FixtureMonkeyBuilder pushAssignableTypeContainerPropertyGenerator(Class<?> type, ContainerPropertyGenerator containerPropertyGenerator) {
        this.fixtureMonkeyOptionsBuilder.insertFirstArbitraryContainerPropertyGenerator(type, containerPropertyGenerator);
        return this;
    }

    public FixtureMonkeyBuilder pushExactTypeContainerPropertyGenerator(Class<?> type, ContainerPropertyGenerator containerPropertyGenerator) {
        this.fixtureMonkeyOptionsBuilder.insertFirstArbitraryContainerPropertyGenerator(MatcherOperator.exactTypeMatchOperator(type, (Object)containerPropertyGenerator));
        return this;
    }

    public FixtureMonkeyBuilder pushContainerPropertyGenerator(MatcherOperator<ContainerPropertyGenerator> containerPropertyGenerator) {
        this.fixtureMonkeyOptionsBuilder.insertFirstArbitraryContainerPropertyGenerator(containerPropertyGenerator);
        return this;
    }

    public FixtureMonkeyBuilder pushAssignableTypePropertyNameResolver(Class<?> type, PropertyNameResolver propertyNameResolver) {
        this.fixtureMonkeyOptionsBuilder.insertFirstPropertyNameResolver(type, propertyNameResolver);
        return this;
    }

    public FixtureMonkeyBuilder pushExactTypePropertyNameResolver(Class<?> type, PropertyNameResolver propertyNameResolver) {
        this.fixtureMonkeyOptionsBuilder.insertFirstPropertyNameResolver(MatcherOperator.exactTypeMatchOperator(type, (Object)propertyNameResolver));
        return this;
    }

    public FixtureMonkeyBuilder pushPropertyNameResolver(MatcherOperator<PropertyNameResolver> propertyNameResolver) {
        this.fixtureMonkeyOptionsBuilder.insertFirstPropertyNameResolver(propertyNameResolver);
        return this;
    }

    public FixtureMonkeyBuilder defaultPropertyNameResolver(PropertyNameResolver propertyNameResolver) {
        this.fixtureMonkeyOptionsBuilder.defaultPropertyNameResolver(propertyNameResolver);
        return this;
    }

    public FixtureMonkeyBuilder pushExactTypeNullInjectGenerator(Class<?> type, NullInjectGenerator nullInjectGenerator) {
        this.fixtureMonkeyOptionsBuilder.insertFirstNullInjectGenerators(MatcherOperator.exactTypeMatchOperator(type, (Object)nullInjectGenerator));
        return this;
    }

    public FixtureMonkeyBuilder pushAssignableTypeNullInjectGenerator(Class<?> type, NullInjectGenerator nullInjectGenerator) {
        this.fixtureMonkeyOptionsBuilder.insertFirstNullInjectGenerators(type, nullInjectGenerator);
        return this;
    }

    public FixtureMonkeyBuilder pushNullInjectGenerator(MatcherOperator<NullInjectGenerator> nullInjectGenerator) {
        this.fixtureMonkeyOptionsBuilder.insertFirstNullInjectGenerators(nullInjectGenerator);
        return this;
    }

    public FixtureMonkeyBuilder defaultNullInjectGenerator(NullInjectGenerator nullInjectGenerator) {
        this.fixtureMonkeyOptionsBuilder.defaultNullInjectGenerator(nullInjectGenerator);
        return this;
    }

    public FixtureMonkeyBuilder pushArbitraryContainerInfoGenerator(MatcherOperator<ArbitraryContainerInfoGenerator> arbitraryContainerInfoGenerator) {
        this.fixtureMonkeyOptionsBuilder.insertFirstArbitraryContainerInfoGenerator(arbitraryContainerInfoGenerator);
        return this;
    }

    public FixtureMonkeyBuilder defaultArbitraryContainerInfoGenerator(ArbitraryContainerInfoGenerator defaultArbitraryContainerInfoGenerator) {
        this.fixtureMonkeyOptionsBuilder.defaultArbitraryContainerInfoGenerator(defaultArbitraryContainerInfoGenerator);
        return this;
    }

    public FixtureMonkeyBuilder pushAssignableTypeArbitraryIntrospector(Class<?> type, ArbitraryIntrospector arbitraryIntrospector) {
        this.fixtureMonkeyOptionsBuilder.insertFirstArbitraryIntrospector(type, arbitraryIntrospector);
        return this;
    }

    public FixtureMonkeyBuilder pushExactTypeArbitraryIntrospector(Class<?> type, ArbitraryIntrospector arbitraryIntrospector) {
        this.fixtureMonkeyOptionsBuilder.insertFirstArbitraryIntrospector(MatcherOperator.exactTypeMatchOperator(type, (Object)arbitraryIntrospector));
        return this;
    }

    public FixtureMonkeyBuilder pushArbitraryIntrospector(MatcherOperator<ArbitraryIntrospector> arbitraryIntrospector) {
        this.fixtureMonkeyOptionsBuilder.insertFirstArbitraryIntrospector(arbitraryIntrospector);
        return this;
    }

    public FixtureMonkeyBuilder objectIntrospector(ArbitraryIntrospector objectIntrospector) {
        this.fixtureMonkeyOptionsBuilder.objectIntrospector(it -> objectIntrospector);
        return this;
    }

    public FixtureMonkeyBuilder arbitraryValidator(ArbitraryValidator arbitraryValidator) {
        this.fixtureMonkeyOptionsBuilder.defaultArbitraryValidator(arbitraryValidator);
        return this;
    }

    public FixtureMonkeyBuilder pushExceptGenerateType(Matcher matcher) {
        this.fixtureMonkeyOptionsBuilder.insertFirstArbitraryIntrospector(new MatcherOperator(matcher, (Object)NullArbitraryIntrospector.INSTANCE));
        return this;
    }

    public FixtureMonkeyBuilder addExceptGenerateClass(Class<?> type) {
        return this.pushExceptGenerateType((Matcher)new AssignableTypeMatcher(type));
    }

    public FixtureMonkeyBuilder addExceptGenerateClasses(Class<?> ... types) {
        for (Class<?> type : types) {
            this.addExceptGenerateClass(type);
        }
        return this;
    }

    public FixtureMonkeyBuilder addExceptGeneratePackage(String exceptGeneratePackage) {
        return this.pushExceptGenerateType(property -> Types.primitiveToWrapper((Class)Types.getActualType((Type)property.getType())).getPackage().getName().startsWith(exceptGeneratePackage));
    }

    public FixtureMonkeyBuilder addExceptGeneratePackages(String ... exceptGeneratePackages) {
        for (String exceptGeneratePackage : exceptGeneratePackages) {
            this.addExceptGeneratePackage(exceptGeneratePackage);
        }
        return this;
    }

    public FixtureMonkeyBuilder register(Class<?> type, Function<FixtureMonkey, ? extends ArbitraryBuilder<?>> registeredArbitraryBuilder) {
        return this.register(MatcherOperator.assignableTypeMatchOperator(type, registeredArbitraryBuilder));
    }

    public FixtureMonkeyBuilder registerExactType(Class<?> type, Function<FixtureMonkey, ? extends ArbitraryBuilder<?>> registeredArbitraryBuilder) {
        return this.register(MatcherOperator.exactTypeMatchOperator(type, registeredArbitraryBuilder));
    }

    public FixtureMonkeyBuilder registerAssignableType(Class<?> type, Function<FixtureMonkey, ? extends ArbitraryBuilder<?>> registeredArbitraryBuilder) {
        return this.register(MatcherOperator.assignableTypeMatchOperator(type, registeredArbitraryBuilder));
    }

    public FixtureMonkeyBuilder register(MatcherOperator<Function<FixtureMonkey, ? extends ArbitraryBuilder<?>>> registeredArbitraryBuilder) {
        this.registeredArbitraryBuilders.add(registeredArbitraryBuilder);
        return this;
    }

    public FixtureMonkeyBuilder registerGroup(Class<?> ... arbitraryBuilderGroups) {
        for (Class<?> arbitraryBuilderGroup : arbitraryBuilderGroups) {
            Method[] methods;
            for (Method method : methods = arbitraryBuilderGroup.getMethods()) {
                int paramCount = method.getParameterCount();
                Class<?> returnType = method.getReturnType();
                if (paramCount != 1 || !ArbitraryBuilder.class.isAssignableFrom(returnType)) continue;
                try {
                    Class actualType = Types.getActualType((AnnotatedType)((AnnotatedType)Types.getGenericsTypes((AnnotatedType)method.getAnnotatedReturnType()).get(0)));
                    Object noArgsInstance = arbitraryBuilderGroup.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    Function<FixtureMonkey, ArbitraryBuilder> registerArbitraryBuilder = fixtureMonkey -> {
                        try {
                            return (ArbitraryBuilder)method.invoke(noArgsInstance, fixtureMonkey);
                        }
                        catch (IllegalAccessException | InvocationTargetException ex) {
                            ex.printStackTrace();
                            throw new RuntimeException(ex);
                        }
                    };
                    this.register(actualType, registerArbitraryBuilder);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this;
    }

    public FixtureMonkeyBuilder registerGroup(ArbitraryBuilderGroup ... arbitraryBuilderGroups) {
        for (ArbitraryBuilderGroup arbitraryBuilderGroup : arbitraryBuilderGroups) {
            List<ArbitraryBuilderCandidate<?>> candidates = arbitraryBuilderGroup.generateCandidateList().getCandidates();
            for (ArbitraryBuilderCandidate<?> candidate : candidates) {
                this.register(candidate.getClassType(), candidate.getArbitraryBuilderRegisterer());
            }
        }
        return this;
    }

    public FixtureMonkeyBuilder plugin(Plugin plugin) {
        if (plugin instanceof InterfacePlugin) {
            this.defaultInterfacePlugin = (InterfacePlugin)plugin;
            return this;
        }
        this.fixtureMonkeyOptionsBuilder.plugin(plugin);
        return this;
    }

    public FixtureMonkeyBuilder defaultDecomposedContainerValueFactory(DecomposedContainerValueFactory defaultDecomposedContainerValueFactory) {
        this.fixtureMonkeyOptionsBuilder.decomposedContainerValueFactory(defaultDecomposedContainerValueFactory);
        return this;
    }

    public FixtureMonkeyBuilder addDecomposedContainerValueFactory(Class<?> type, DecomposedContainerValueFactory additionalDecomposedContainerValueFactory) {
        this.fixtureMonkeyOptionsBuilder.addDecomposedContainerValueFactory(type, additionalDecomposedContainerValueFactory);
        return this;
    }

    public FixtureMonkeyBuilder pushContainerIntrospector(ArbitraryIntrospector containerIntrospector) {
        this.fixtureMonkeyOptionsBuilder.containerIntrospector(it -> new MatchArbitraryIntrospector(Arrays.asList(containerIntrospector, it)));
        return this;
    }

    public FixtureMonkeyBuilder addContainerType(Class<?> type, ContainerPropertyGenerator containerObjectPropertyGenerator, ArbitraryIntrospector containerArbitraryIntrospector, DecomposedContainerValueFactory decomposedContainerValueFactory) {
        this.pushAssignableTypeContainerPropertyGenerator(type, containerObjectPropertyGenerator);
        this.pushContainerIntrospector(containerArbitraryIntrospector);
        this.fixtureMonkeyOptionsBuilder.addDecomposedContainerValueFactory(type, decomposedContainerValueFactory);
        return this;
    }

    public FixtureMonkeyBuilder defaultPropertyGenerator(PropertyGenerator propertyGenerator) {
        this.fixtureMonkeyOptionsBuilder.defaultPropertyGenerator(propertyGenerator);
        return this;
    }

    public FixtureMonkeyBuilder defaultNotNull(boolean defaultNotNull) {
        this.fixtureMonkeyOptionsBuilder.defaultNotNull(defaultNotNull);
        return this;
    }

    public FixtureMonkeyBuilder nullableContainer(boolean nullableContainer) {
        this.fixtureMonkeyOptionsBuilder.nullableContainer(nullableContainer);
        return this;
    }

    public FixtureMonkeyBuilder nullableElement(boolean nullableElement) {
        this.fixtureMonkeyOptionsBuilder.nullableElement(nullableElement);
        return this;
    }

    @Deprecated
    public <T> FixtureMonkeyBuilder interfaceImplements(Matcher matcher, List<Class<? extends T>> implementations) {
        this.pushObjectPropertyGenerator((MatcherOperator<ObjectPropertyGenerator>)new MatcherOperator(matcher, (Object)new InterfaceObjectPropertyGenerator(implementations)));
        return this;
    }

    @Deprecated
    public <T> FixtureMonkeyBuilder interfaceImplements(Class<T> interfaceClass, List<Class<? extends T>> implementations) {
        return this.interfaceImplements((Matcher)new ExactTypeMatcher(interfaceClass), implementations);
    }

    public FixtureMonkeyBuilder useExpressionStrictMode() {
        this.monkeyExpressionFactory = expression -> () -> new ApplyStrictModeResolver(new ArbitraryExpressionFactory().from(expression).toNodeResolver());
        return this;
    }

    public FixtureMonkeyBuilder defaultArbitraryGenerator(UnaryOperator<ArbitraryGenerator> arbitraryGeneratorUnaryOperator) {
        this.fixtureMonkeyOptionsBuilder.defaultArbitraryGenerator(arbitraryGeneratorUnaryOperator);
        return this;
    }

    public FixtureMonkeyBuilder generateMaxTries(int generateMaxTries) {
        this.fixtureMonkeyOptionsBuilder.generateMaxTries(generateMaxTries);
        return this;
    }

    public FixtureMonkeyBuilder generateUniqueMaxTries(int generateUniqueMaxTries) {
        this.fixtureMonkeyOptionsBuilder.generateUniqueMaxTries(generateUniqueMaxTries);
        return this;
    }

    public FixtureMonkeyBuilder javaConstraintGenerator(JavaConstraintGenerator javaConstraintGenerator) {
        this.fixtureMonkeyOptionsBuilder.javaConstraintGenerator(javaConstraintGenerator);
        return this;
    }

    public FixtureMonkeyBuilder pushJavaConstraintGeneratorCustomizer(UnaryOperator<JavaConstraintGenerator> javaConstraintGeneratorCustomizer) {
        this.fixtureMonkeyOptionsBuilder.insertFirstJavaConstraintGeneratorCustomizer(javaConstraintGeneratorCustomizer);
        return this;
    }

    public FixtureMonkeyBuilder seed(long seed) {
        this.seed = seed;
        return this;
    }

    @Deprecated
    public FixtureMonkeyBuilder pushExactTypePropertyCandidateResolver(Class<?> type, CandidateConcretePropertyResolver candidateConcretePropertyResolver) {
        this.fixtureMonkeyOptionsBuilder.insertFirstCandidateConcretePropertyResolvers(new MatcherOperator((Matcher)new ExactTypeMatcher(type), (Object)candidateConcretePropertyResolver));
        return this;
    }

    public FixtureMonkey build() {
        this.defaultInterfacePlugin.accept(this.fixtureMonkeyOptionsBuilder);
        FixtureMonkeyOptions fixtureMonkeyOptions = this.fixtureMonkeyOptionsBuilder.build();
        ArbitraryTraverser traverser = new ArbitraryTraverser(fixtureMonkeyOptions);
        MonkeyManipulatorFactory monkeyManipulatorFactory = new MonkeyManipulatorFactory(new AtomicInteger(), this.monkeyExpressionFactory, traverser, fixtureMonkeyOptions.getDecomposedContainerValueFactory());
        MonkeyContext monkeyContext = this.monkeyContextBuilder.build();
        Randoms.create((String)String.valueOf(this.seed));
        return new FixtureMonkey(fixtureMonkeyOptions, traverser, this.manipulatorOptimizer, monkeyContext, this.registeredArbitraryBuilders, monkeyManipulatorFactory);
    }
}

