/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.tree;

import com.navercorp.fixturemonkey.api.container.ConcurrentLruCache;
import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGenerator;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.generator.ContainerProperty;
import com.navercorp.fixturemonkey.api.generator.ContainerPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.ContainerPropertyGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ObjectProperty;
import com.navercorp.fixturemonkey.api.generator.ObjectPropertyGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.SingleValueObjectPropertyGenerator;
import com.navercorp.fixturemonkey.api.matcher.MatcherOperator;
import com.navercorp.fixturemonkey.api.option.FixtureMonkeyOptions;
import com.navercorp.fixturemonkey.api.property.CandidateConcretePropertyResolver;
import com.navercorp.fixturemonkey.api.property.ConcreteTypeDefinition;
import com.navercorp.fixturemonkey.api.property.DefaultCandidateConcretePropertyResolver;
import com.navercorp.fixturemonkey.api.property.MapEntryElementProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyGenerator;
import com.navercorp.fixturemonkey.api.random.Randoms;
import com.navercorp.fixturemonkey.api.type.Types;
import com.navercorp.fixturemonkey.customizer.ContainerInfoManipulator;
import com.navercorp.fixturemonkey.tree.ObjectNode;
import com.navercorp.fixturemonkey.tree.TraverseContext;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class ArbitraryTraverser {
    private final FixtureMonkeyOptions fixtureMonkeyOptions;
    private final ConcurrentLruCache<Property, List<Property>> candidateConcretePropertiesByProperty;

    public ArbitraryTraverser(FixtureMonkeyOptions fixtureMonkeyOptions) {
        this.fixtureMonkeyOptions = fixtureMonkeyOptions;
        this.candidateConcretePropertiesByProperty = new ConcurrentLruCache(1024);
    }

    public ObjectNode traverse(Property property, List<ContainerInfoManipulator> containerInfoManipulators, List<MatcherOperator<List<ContainerInfoManipulator>>> registeredContainerInfoManipulators, Map<Class<?>, List<Property>> propertyConfigurers) {
        TraverseContext traverseContext = new TraverseContext(new ArrayList<ArbitraryProperty>(), containerInfoManipulators, registeredContainerInfoManipulators, propertyConfigurers);
        return this.generateObjectNode(null, property, null, traverseContext);
    }

    private ObjectNode generateObjectNode(@Nullable Property resolvedParentProperty, Property property, @Nullable Integer propertySequence, TraverseContext context) {
        List concreteTypeDefinitions;
        List<Property> candidateProperties;
        ContainerPropertyGenerator containerPropertyGenerator = this.fixtureMonkeyOptions.getContainerPropertyGenerator(property);
        boolean container = containerPropertyGenerator != null;
        Object objectPropertyGenerator = container ? SingleValueObjectPropertyGenerator.INSTANCE : this.fixtureMonkeyOptions.getObjectPropertyGenerator(property);
        ArbitraryProperty parentArbitraryProperty = context.getLastArbitraryProperty();
        Integer index = null;
        if (resolvedParentProperty != null && parentArbitraryProperty != null) {
            index = this.getIndex(resolvedParentProperty, parentArbitraryProperty, propertySequence);
        }
        ObjectPropertyGeneratorContext objectPropertyGeneratorContext = new ObjectPropertyGeneratorContext(property, index, parentArbitraryProperty, container, this.getPropertyGenerator(context.getPropertyConfigurers()), this.fixtureMonkeyOptions.getPropertyNameResolver(property), this.fixtureMonkeyOptions.getNullInjectGenerator(property));
        ObjectProperty objectProperty = objectPropertyGenerator.generate(objectPropertyGeneratorContext);
        ContainerInfoManipulator appliedContainerInfoManipulator = null;
        if (container) {
            List<ObjectProperty> objectProperties = context.getArbitraryProperties().stream().map(ArbitraryProperty::getObjectProperty).collect(Collectors.toList());
            objectProperties.add(objectProperty);
            appliedContainerInfoManipulator = this.resolveAppliedContainerInfoManipulator(context.getContainerInfoManipulators(), objectProperties);
            ArbitraryContainerInfo containerInfo = appliedContainerInfoManipulator != null ? appliedContainerInfoManipulator.getContainerInfo() : null;
            ContainerProperty childContainerProperty = containerPropertyGenerator.generate(new ContainerPropertyGeneratorContext(property, index, containerInfo, this.fixtureMonkeyOptions.getArbitraryContainerInfoGenerator(property)));
            candidateProperties = this.resolveCandidateProperties(property);
            concreteTypeDefinitions = candidateProperties.stream().map(it -> new ConcreteTypeDefinition(it, childContainerProperty.getElementProperties())).collect(Collectors.toList());
        } else {
            List objectPropertyCandidateTypeDefinitions = objectProperty.getChildPropertyListsByCandidateProperty().entrySet().stream().map(it -> new ConcreteTypeDefinition((Property)it.getKey(), (List)it.getValue())).collect(Collectors.toList());
            CandidateConcretePropertyResolver candidateConcretePropertyResolver = this.fixtureMonkeyOptions.getCandidateConcretePropertyResolver(property);
            if (candidateConcretePropertyResolver == null && objectPropertyCandidateTypeDefinitions.isEmpty()) {
                candidateConcretePropertyResolver = DefaultCandidateConcretePropertyResolver.INSTANCE;
            }
            List optionCandidateTypeDefinitions = Collections.emptyList();
            if (candidateConcretePropertyResolver != null) {
                candidateProperties = candidateConcretePropertyResolver.resolve(property);
                optionCandidateTypeDefinitions = candidateProperties.stream().map(it -> new ConcreteTypeDefinition(it, this.getPropertyGenerator(context.getPropertyConfigurers()).generateChildProperties(it))).collect(Collectors.toList());
            }
            concreteTypeDefinitions = Stream.concat(objectPropertyCandidateTypeDefinitions.stream(), optionCandidateTypeDefinitions.stream()).collect(Collectors.toList());
        }
        double nullInject = objectProperty.getNullInject() != null ? objectProperty.getNullInject().doubleValue() : this.fixtureMonkeyOptions.getNullInjectGenerator(property).generate(objectPropertyGeneratorContext);
        ArbitraryProperty arbitraryProperty = new ArbitraryProperty(objectProperty, container, nullInject, concreteTypeDefinitions);
        TraverseContext nextTraverseContext = context.appendArbitraryProperty(arbitraryProperty);
        ArrayList<ObjectNode> children = new ArrayList<ObjectNode>();
        for (ConcreteTypeDefinition concreteTypeDefinition : concreteTypeDefinitions) {
            List childProperties = concreteTypeDefinition.getChildPropertyLists();
            Property candidateProperty = concreteTypeDefinition.getConcreteProperty();
            children.addAll(this.generateChildrenNodes(candidateProperty, childProperties, nextTraverseContext));
        }
        Property resolvedProperty = ((ConcreteTypeDefinition)concreteTypeDefinitions.get(Randoms.nextInt((int)concreteTypeDefinitions.size()))).getConcreteProperty();
        ObjectNode objectNode = new ObjectNode(resolvedParentProperty, resolvedProperty, arbitraryProperty, children);
        if (appliedContainerInfoManipulator != null) {
            objectNode.addContainerManipulator(appliedContainerInfoManipulator);
        }
        return objectNode;
    }

    @Nullable
    private Integer getIndex(Property resolvedParentProperty, ArbitraryProperty parentArbitraryProperty, Integer propertySequence) {
        boolean parentContainer;
        boolean bl = parentContainer = this.fixtureMonkeyOptions.getContainerPropertyGenerator(resolvedParentProperty) != null;
        if (!parentContainer) {
            return null;
        }
        int index = propertySequence;
        if (parentArbitraryProperty.getObjectProperty().getProperty() instanceof MapEntryElementProperty) {
            index /= 2;
        }
        return index;
    }

    private List<ObjectNode> generateChildrenNodes(Property resolvedParentProperty, List<Property> childProperties, TraverseContext context) {
        ArrayList<ObjectNode> children = new ArrayList<ObjectNode>();
        for (int sequence = 0; sequence < childProperties.size(); ++sequence) {
            Property childProperty = childProperties.get(sequence);
            if (context.isTraversed(childProperty) && !(resolvedParentProperty instanceof MapEntryElementProperty)) continue;
            ObjectNode childNode = this.generateObjectNode(resolvedParentProperty, childProperty, sequence, context);
            children.add(childNode);
        }
        return children;
    }

    @Nullable
    private ContainerInfoManipulator resolveAppliedContainerInfoManipulator(List<ContainerInfoManipulator> containerInfoManipulators, List<ObjectProperty> objectProperties) {
        ContainerInfoManipulator appliedContainerInfoManipulator = null;
        for (ContainerInfoManipulator containerInfoManipulator : containerInfoManipulators) {
            if (!containerInfoManipulator.isMatch(objectProperties)) continue;
            appliedContainerInfoManipulator = containerInfoManipulator;
        }
        return appliedContainerInfoManipulator;
    }

    private PropertyGenerator getPropertyGenerator(Map<Class<?>, List<Property>> propertyConfigurers) {
        return property -> {
            Class type = Types.getActualType((Type)property.getType());
            List propertyConfigurer = (List)propertyConfigurers.get(type);
            if (propertyConfigurer != null) {
                return propertyConfigurer;
            }
            PropertyGenerator propertyGenerator = this.fixtureMonkeyOptions.getOptionalPropertyGenerator(property);
            if (propertyGenerator != null) {
                return propertyGenerator.generateChildProperties(property);
            }
            ArbitraryGenerator defaultArbitraryGenerator = this.fixtureMonkeyOptions.getDefaultArbitraryGenerator();
            PropertyGenerator defaultArbitraryGeneratorPropertyGenerator = defaultArbitraryGenerator.getRequiredPropertyGenerator(property);
            if (defaultArbitraryGeneratorPropertyGenerator != null) {
                return defaultArbitraryGeneratorPropertyGenerator.generateChildProperties(property);
            }
            return this.fixtureMonkeyOptions.getDefaultPropertyGenerator().generateChildProperties(property);
        };
    }

    private List<Property> resolveCandidateProperties(Property property) {
        CandidateConcretePropertyResolver candidateConcretePropertyResolver = this.fixtureMonkeyOptions.getCandidateConcretePropertyResolver(property);
        if (candidateConcretePropertyResolver == null) {
            return DefaultCandidateConcretePropertyResolver.INSTANCE.resolve(property);
        }
        return (List)this.candidateConcretePropertiesByProperty.computeIfAbsent((Object)property, p -> {
            ArrayList<Property> resolvedCandidateProperties = new ArrayList<Property>();
            List candidateProperties = candidateConcretePropertyResolver.resolve(p);
            for (Property candidateProperty : candidateProperties) {
                Type candidateType = candidateProperty.getType();
                boolean assignableType = Types.isAssignable((Class)Types.getActualType((Type)candidateType), (Class)Types.getActualType((Type)p.getType()));
                if (p.getType().equals(candidateType)) {
                    resolvedCandidateProperties.addAll(DefaultCandidateConcretePropertyResolver.INSTANCE.resolve(p));
                    continue;
                }
                resolvedCandidateProperties.addAll(this.resolveCandidateProperties(candidateProperty));
            }
            return resolvedCandidateProperties;
        });
    }
}

