/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.tree;

import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.tree.ObjectNode;
import com.navercorp.fixturemonkey.tree.ObjectTreeMetadata;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
final class MetadataCollector {
    private final ObjectNode rootNode;
    private final Map<Property, List<ObjectNode>> nodesByProperty;

    public MetadataCollector(ObjectNode rootNode) {
        this.rootNode = rootNode;
        this.nodesByProperty = new LinkedHashMap<Property, List<ObjectNode>>();
    }

    public ObjectTreeMetadata collect() {
        for (ObjectNode child : this.rootNode.getChildren()) {
            this.collect(child);
        }
        return new ObjectTreeMetadata(Collections.unmodifiableMap(this.nodesByProperty));
    }

    private void collect(ObjectNode node) {
        Property property = node.getArbitraryProperty().getObjectProperty().getProperty();
        List<ObjectNode> children = node.getChildren();
        for (ObjectNode child : children) {
            this.collect(child);
        }
        List<ObjectNode> list = Collections.singletonList(node);
        this.nodesByProperty.merge(property, list, (prev, now) -> Stream.concat(prev.stream(), now.stream()).collect(Collectors.toList()));
    }
}

