/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey;

import com.navercorp.fixturemonkey.ArbitraryBuilder;
import com.navercorp.fixturemonkey.FixtureMonkeyBuilder;
import com.navercorp.fixturemonkey.JavaTypeArbitraryBuilder;
import com.navercorp.fixturemonkey.api.ObjectBuilder;
import com.navercorp.fixturemonkey.api.context.MonkeyContext;
import com.navercorp.fixturemonkey.api.matcher.MatcherOperator;
import com.navercorp.fixturemonkey.api.option.FixtureMonkeyOptions;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.RootProperty;
import com.navercorp.fixturemonkey.api.property.TreeRootProperty;
import com.navercorp.fixturemonkey.api.property.TypeParameterProperty;
import com.navercorp.fixturemonkey.api.type.LazyAnnotatedType;
import com.navercorp.fixturemonkey.api.type.TypeReference;
import com.navercorp.fixturemonkey.builder.ArbitraryBuilderContext;
import com.navercorp.fixturemonkey.builder.ArbitraryBuilderContextProvider;
import com.navercorp.fixturemonkey.builder.DefaultArbitraryBuilder;
import com.navercorp.fixturemonkey.builder.JavaTypeDefaultTypeArbitraryBuilder;
import com.navercorp.fixturemonkey.customizer.ArbitraryManipulator;
import com.navercorp.fixturemonkey.customizer.MonkeyManipulatorFactory;
import com.navercorp.fixturemonkey.experimental.ExperimentalArbitraryBuilder;
import com.navercorp.fixturemonkey.expression.MonkeyExpressionFactory;
import com.navercorp.fixturemonkey.resolver.ArbitraryResolver;
import com.navercorp.fixturemonkey.resolver.ManipulatorOptimizer;
import java.lang.reflect.AnnotatedType;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jqwik.api.Arbitrary;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class FixtureMonkey {
    private final FixtureMonkeyOptions fixtureMonkeyOptions;
    private final ManipulatorOptimizer manipulatorOptimizer;
    private final MonkeyContext monkeyContext;
    private final MonkeyManipulatorFactory monkeyManipulatorFactory;
    private final MonkeyExpressionFactory monkeyExpressionFactory;

    public FixtureMonkey(FixtureMonkeyOptions fixtureMonkeyOptions, ManipulatorOptimizer manipulatorOptimizer, List<MatcherOperator<Function<FixtureMonkey, ? extends ArbitraryBuilder<?>>>> registeredArbitraryBuilders, MonkeyManipulatorFactory monkeyManipulatorFactory, MonkeyExpressionFactory monkeyExpressionFactory) {
        this.fixtureMonkeyOptions = fixtureMonkeyOptions;
        this.manipulatorOptimizer = manipulatorOptimizer;
        this.monkeyContext = MonkeyContext.builder((FixtureMonkeyOptions)fixtureMonkeyOptions).build();
        this.monkeyManipulatorFactory = monkeyManipulatorFactory;
        this.monkeyExpressionFactory = monkeyExpressionFactory;
        this.initializeRegisteredArbitraryBuilders(registeredArbitraryBuilders);
    }

    public static FixtureMonkeyBuilder builder() {
        return new FixtureMonkeyBuilder();
    }

    public static FixtureMonkey create() {
        return FixtureMonkey.builder().build();
    }

    public <T> ArbitraryBuilder<T> giveMeBuilder(Class<T> type) {
        TypeReference typeReference = new TypeReference<T>(type){};
        return this.giveMeBuilder((T)typeReference);
    }

    public <T> ArbitraryBuilder<T> giveMeBuilder(TypeReference<T> type) {
        RootProperty rootProperty = new RootProperty((Property)new TypeParameterProperty(type.getAnnotatedType()));
        ArbitraryBuilderContext builderContext = this.monkeyContext.getRegisteredArbitraryBuilders().stream().filter(arg_0 -> FixtureMonkey.lambda$giveMeBuilder$0((TreeRootProperty)rootProperty, arg_0)).map(MatcherOperator::getOperator).findAny().map(ArbitraryBuilderContextProvider.class::cast).map(ArbitraryBuilderContextProvider::getContext).orElse(ArbitraryBuilderContext.newBuilderContext(this.monkeyContext));
        return new DefaultArbitraryBuilder((TreeRootProperty)rootProperty, new ArbitraryResolver(this.manipulatorOptimizer, this.monkeyManipulatorFactory, this.monkeyContext), this.monkeyManipulatorFactory, this.monkeyExpressionFactory, builderContext.copy(), this.monkeyContext, this.fixtureMonkeyOptions.getInstantiatorProcessor());
    }

    public <T> ArbitraryBuilder<T> giveMeBuilder(T value) {
        ArbitraryBuilderContext context = ArbitraryBuilderContext.newBuilderContext(this.monkeyContext);
        ArbitraryManipulator arbitraryManipulator = this.monkeyManipulatorFactory.newArbitraryManipulator(this.monkeyExpressionFactory.from("$").toNodeResolver(), value);
        context.addManipulator(arbitraryManipulator);
        return new DefaultArbitraryBuilder((TreeRootProperty)new RootProperty((Property)new TypeParameterProperty((AnnotatedType)new LazyAnnotatedType(() -> value))), new ArbitraryResolver(this.manipulatorOptimizer, this.monkeyManipulatorFactory, this.monkeyContext), this.monkeyManipulatorFactory, this.monkeyExpressionFactory, context, this.monkeyContext, this.fixtureMonkeyOptions.getInstantiatorProcessor());
    }

    public <T> ExperimentalArbitraryBuilder<T> giveMeExperimentalBuilder(Class<T> type) {
        return (ExperimentalArbitraryBuilder)this.giveMeBuilder((T)type);
    }

    public <T> ExperimentalArbitraryBuilder<T> giveMeExperimentalBuilder(TypeReference<T> type) {
        return (ExperimentalArbitraryBuilder)this.giveMeBuilder((T)type);
    }

    public <T> JavaTypeArbitraryBuilder<T> giveMeJavaBuilder(T value) {
        return new JavaTypeDefaultTypeArbitraryBuilder<T>(this.giveMeBuilder(value));
    }

    public <T> JavaTypeArbitraryBuilder<T> giveMeJavaBuilder(Class<T> type) {
        return new JavaTypeDefaultTypeArbitraryBuilder<Class<T>>(this.giveMeBuilder((T)type));
    }

    public <T> JavaTypeArbitraryBuilder<T> giveMeJavaBuilder(TypeReference<T> type) {
        return new JavaTypeDefaultTypeArbitraryBuilder<TypeReference<T>>(this.giveMeBuilder((T)type));
    }

    public <T> Stream<T> giveMe(Class<T> type) {
        return Stream.generate(() -> this.giveMeBuilder((Object)type).sample());
    }

    public <T> Stream<T> giveMe(TypeReference<T> typeReference) {
        return Stream.generate(() -> this.giveMeBuilder((Object)typeReference).sample());
    }

    public <T> List<T> giveMe(Class<T> type, int size) {
        return this.giveMe(type).limit(size).collect(Collectors.toList());
    }

    public <T> List<T> giveMe(TypeReference<T> typeReference, int size) {
        return this.giveMe(typeReference).limit(size).collect(Collectors.toList());
    }

    public <T> T giveMeOne(Class<T> type) {
        return this.giveMe(type, 1).get(0);
    }

    public <T> T giveMeOne(TypeReference<T> typeReference) {
        return this.giveMe(typeReference, 1).get(0);
    }

    public <T> Arbitrary<T> giveMeArbitrary(Class<T> type) {
        return this.giveMeBuilder((T)type).build();
    }

    public <T> Arbitrary<T> giveMeArbitrary(TypeReference<T> typeReference) {
        return this.giveMeBuilder((T)typeReference).build();
    }

    private void initializeRegisteredArbitraryBuilders(List<MatcherOperator<Function<FixtureMonkey, ? extends ArbitraryBuilder<?>>>> registeredArbitraryBuilders) {
        List generatedRegisteredArbitraryBuilder = registeredArbitraryBuilders.stream().map(it -> new MatcherOperator(it.getMatcher(), (Object)((ObjectBuilder)((Function)it.getOperator()).apply(this)))).collect(Collectors.toList());
        for (int i = generatedRegisteredArbitraryBuilder.size() - 1; i >= 0; --i) {
            this.monkeyContext.getRegisteredArbitraryBuilders().add(generatedRegisteredArbitraryBuilder.get(i));
        }
    }

    private static /* synthetic */ boolean lambda$giveMeBuilder$0(TreeRootProperty rootProperty, MatcherOperator it) {
        return it.match((Property)rootProperty);
    }
}

