/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.customizer;

import com.navercorp.fixturemonkey.api.lazy.LazyArbitrary;
import com.navercorp.fixturemonkey.customizer.InnerSpecState;
import com.navercorp.fixturemonkey.customizer.ManipulatorSet;
import com.navercorp.fixturemonkey.customizer.MonkeyManipulatorFactory;
import com.navercorp.fixturemonkey.expression.DefaultDeclarativeExpression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class InnerSpec {
    private static final int FIRST_MANIPULATOR_SEQUENCE = 0;
    private final int sequence;
    private final DefaultDeclarativeExpression declarativeExpression;
    private final InnerSpecState state;
    private final List<InnerSpec> innerSpecs;
    private int entrySize = 0;
    private int manipulateSize = 0;

    public InnerSpec() {
        this(0, new DefaultDeclarativeExpression(), new InnerSpecState(), new ArrayList<InnerSpec>());
    }

    private InnerSpec(int sequence, DefaultDeclarativeExpression declarativeExpression, InnerSpecState state, List<InnerSpec> innerSpecs) {
        this.sequence = sequence;
        this.declarativeExpression = declarativeExpression;
        this.state = state;
        this.innerSpecs = innerSpecs;
    }

    public InnerSpec inner(InnerSpec innerSpec) {
        InnerSpec nextInnerSpec = this.newNextInnerSpec(innerSpec, this.declarativeExpression);
        this.innerSpecs.add(nextInnerSpec);
        return this;
    }

    public InnerSpec size(int minSize, int maxSize) {
        if (minSize > maxSize) {
            throw new IllegalArgumentException("should be min > max, min : " + minSize + " max : " + maxSize);
        }
        this.state.setContainerInfoSnapshot(new InnerSpecState.ContainerInfoSnapshot(this.sequence + this.manipulateSize, this.declarativeExpression, minSize, maxSize));
        ++this.manipulateSize;
        return this;
    }

    public InnerSpec size(int size) {
        return this.size(size, size);
    }

    public InnerSpec minSize(int minSize) {
        return this.size(minSize, minSize + 3);
    }

    public InnerSpec maxSize(int maxSize) {
        return this.size(Math.max(0, maxSize - 3), maxSize);
    }

    public InnerSpec key(Object key) {
        ++this.entrySize;
        this.setMapKey(key);
        return this;
    }

    public InnerSpec keys(Collection<?> keys) {
        keys.forEach(this::key);
        return this;
    }

    public InnerSpec keys(Object ... keys) {
        Arrays.stream(keys).forEach(this::key);
        return this;
    }

    public InnerSpec key(Consumer<InnerSpec> consumer) {
        ++this.entrySize;
        this.setMapKey(consumer);
        return this;
    }

    public InnerSpec values(Collection<?> values) {
        values.forEach(this::value);
        return this;
    }

    public InnerSpec value(Object value) {
        ++this.entrySize;
        this.setMapValue(value);
        return this;
    }

    public InnerSpec values(Object ... values) {
        Arrays.stream(values).forEach(this::value);
        return this;
    }

    public InnerSpec value(Consumer<InnerSpec> consumer) {
        ++this.entrySize;
        this.setMapValue(consumer);
        return this;
    }

    public InnerSpec entry(Object key, @Nullable Object value) {
        ++this.entrySize;
        this.setMapEntry(key, value);
        return this;
    }

    public InnerSpec entries(Collection<?> entries) {
        if (entries.size() % 2 != 0) {
            throw new IllegalArgumentException("key-value pairs for the Map should be entered");
        }
        IntStream.range(0, entries.size()).filter(i -> i % 2 == 0).forEach(i -> this.entry(entries.toArray()[i], entries.toArray()[i + 1]));
        return this;
    }

    public InnerSpec entries(Object ... entries) {
        if (entries.length % 2 != 0) {
            throw new IllegalArgumentException("key-value pairs for the Map should be entered");
        }
        IntStream.range(0, entries.length).filter(i -> i % 2 == 0).forEach(i -> this.entry(entries[i], entries[i + 1]));
        return this;
    }

    public InnerSpec entry(Object key, Consumer<InnerSpec> consumer) {
        ++this.entrySize;
        this.setMapEntry(key, consumer);
        return this;
    }

    public InnerSpec entry(Consumer<InnerSpec> consumer, @Nullable Object value) {
        ++this.entrySize;
        this.setMapEntry(consumer, value);
        return this;
    }

    public InnerSpec keyLazy(Supplier<?> supplier) {
        ++this.entrySize;
        this.setMapKey(supplier);
        return this;
    }

    public InnerSpec valueLazy(Supplier<?> supplier) {
        ++this.entrySize;
        this.setMapValue(supplier);
        return this;
    }

    public InnerSpec entryLazy(Supplier<?> keySupplier, Supplier<?> valueSupplier) {
        ++this.entrySize;
        LazyArbitrary keyLazyArbitrary = LazyArbitrary.lazy(keySupplier);
        LazyArbitrary valueLazyArbitrary = LazyArbitrary.lazy(valueSupplier);
        this.setMapEntry(keyLazyArbitrary, valueLazyArbitrary);
        return this;
    }

    public InnerSpec allKey(Consumer<InnerSpec> consumer) {
        this.setMapAllKey(consumer);
        return this;
    }

    public InnerSpec allKeyLazy(Supplier<?> supplier) {
        LazyArbitrary lazyArbitrary = LazyArbitrary.lazy(supplier);
        this.setMapAllKey(lazyArbitrary);
        return this;
    }

    public InnerSpec allValue(@Nullable Object value) {
        this.setMapAllValue(value);
        return this;
    }

    public InnerSpec allValue(Consumer<InnerSpec> consumer) {
        this.setMapAllValue(consumer);
        return this;
    }

    public InnerSpec allValueLazy(Supplier<?> supplier) {
        LazyArbitrary lazyArbitrary = LazyArbitrary.lazy(supplier);
        this.setMapAllValue(lazyArbitrary);
        return this;
    }

    public InnerSpec allEntry(Supplier<?> keySupplier, Object value) {
        LazyArbitrary keyLazyArbitrary = LazyArbitrary.lazy(keySupplier);
        this.setMapAllKey(keyLazyArbitrary);
        this.setMapAllValue(value);
        return this;
    }

    public InnerSpec allEntryLazy(Supplier<?> keySupplier, Supplier<?> valueSupplier) {
        return this.allEntry(keySupplier, valueSupplier);
    }

    public InnerSpec listElement(int index, @Nullable Object value) {
        this.setListElement(index, value);
        return this;
    }

    public InnerSpec listElement(int index, Consumer<InnerSpec> consumer) {
        this.setListElement(index, consumer);
        return this;
    }

    public InnerSpec allListElement(@Nullable Object value) {
        this.setListAllElements(value);
        return this;
    }

    public InnerSpec allListElement(Consumer<InnerSpec> consumer) {
        this.setListAllElements(consumer);
        return this;
    }

    public InnerSpec property(String propertyName, @Nullable Object value) {
        this.setPropertyValue(propertyName, value);
        return this;
    }

    public InnerSpec property(String propertyName, Consumer<InnerSpec> consumer) {
        this.setPropertyValue(propertyName, consumer);
        return this;
    }

    public <T> InnerSpec postCondition(Class<T> type, Predicate<T> filter) {
        this.state.setFilterSnapshot(new InnerSpecState.FilterSnapshot(this.manipulateSize++, this.declarativeExpression, type, filter));
        return this;
    }

    public ManipulatorSet getManipulatorSet(MonkeyManipulatorFactory monkeyManipulatorFactory) {
        InnerSpecState.ManipulatorHolderSet manipulatorHolderSet = this.traverse(this);
        return monkeyManipulatorFactory.newManipulatorSet(manipulatorHolderSet);
    }

    private InnerSpec newNextInnerSpec(InnerSpec innerSpec, DefaultDeclarativeExpression parentDeclarativeExpression) {
        InnerSpec newSpec = new InnerSpec(innerSpec.sequence, innerSpec.declarativeExpression, innerSpec.state.withPrefix(parentDeclarativeExpression), new ArrayList<InnerSpec>());
        for (InnerSpec childSpec : innerSpec.innerSpecs) {
            newSpec.innerSpecs.add(this.newNextInnerSpec(childSpec, parentDeclarativeExpression));
        }
        return newSpec;
    }

    private void setMapKey(Object mapKey) {
        if (mapKey == null) {
            throw new IllegalArgumentException("Map key cannot be null.");
        }
        this.setValue(this.declarativeExpression.element(this.entrySize - 1).key(), mapKey);
    }

    private void setMapAllKey(Object mapKey) {
        if (mapKey == null) {
            throw new IllegalArgumentException("Map mapKey cannot be null.");
        }
        this.setValue(this.declarativeExpression.allElement().key(), mapKey);
    }

    private void setMapValue(@Nullable Object mapValue) {
        this.setValue(this.declarativeExpression.element(this.entrySize - 1).value(), mapValue);
    }

    private void setMapAllValue(@Nullable Object mapValue) {
        this.setValue(this.declarativeExpression.allElement().value(), mapValue);
    }

    private void setMapEntry(Object key, @Nullable Object value) {
        this.setMapKey(key);
        this.setMapValue(value);
    }

    private void setPropertyValue(String propertyName, @Nullable Object value) {
        this.setValue(this.declarativeExpression.property(propertyName), value);
    }

    private void setListAllElements(@Nullable Object value) {
        this.setValue(this.declarativeExpression.allElement(), value);
    }

    private void setListElement(int index, @Nullable Object value) {
        this.setValue(this.declarativeExpression.element(index), value);
    }

    private void setValue(DefaultDeclarativeExpression defaultDeclarativeExpression, @Nullable Object nextValue) {
        int nextSequence = this.sequence + this.manipulateSize;
        if (nextValue instanceof InnerSpec) {
            InnerSpec prefix = new InnerSpec(nextSequence, defaultDeclarativeExpression, new InnerSpecState(), new ArrayList<InnerSpec>());
            this.innerSpecs.add(prefix.inner((InnerSpec)nextValue));
            ++this.manipulateSize;
            return;
        }
        if (nextValue instanceof Consumer) {
            Consumer consumer = (Consumer)nextValue;
            InnerSpec nextInnerSpec = new InnerSpec(nextSequence, defaultDeclarativeExpression, new InnerSpecState(), new ArrayList<InnerSpec>());
            consumer.accept(nextInnerSpec);
            this.innerSpecs.add(nextInnerSpec);
            ++this.manipulateSize;
            return;
        }
        InnerSpecState nextInnerSpecState = new InnerSpecState();
        nextInnerSpecState.setNodeManipulatorSnapshot(new InnerSpecState.NodeSetManipulatorSnapshot(nextSequence, defaultDeclarativeExpression, nextValue));
        InnerSpec nextInnerSpec = new InnerSpec(nextSequence, defaultDeclarativeExpression, nextInnerSpecState, new ArrayList<InnerSpec>());
        this.innerSpecs.add(nextInnerSpec);
        ++this.manipulateSize;
    }

    private InnerSpecState.ManipulatorHolderSet traverse(InnerSpec innerSpec) {
        ArrayList<InnerSpecState.NodeSetManipulatorSnapshot> nodeSetManipulatorSnapshots = new ArrayList<InnerSpecState.NodeSetManipulatorSnapshot>();
        ArrayList<InnerSpecState.ContainerInfoSnapshot> containerInfoManipulators = new ArrayList<InnerSpecState.ContainerInfoSnapshot>();
        ArrayList<InnerSpecState.FilterSnapshot> postConditionManipulators = new ArrayList<InnerSpecState.FilterSnapshot>();
        if (innerSpec.state.getNodeManipulatorSnapshot() != null) {
            nodeSetManipulatorSnapshots.add(innerSpec.state.getNodeManipulatorSnapshot());
        }
        if (innerSpec.state.getContainerInfoHolder() != null) {
            containerInfoManipulators.add(innerSpec.state.getContainerInfoHolder());
        }
        if (innerSpec.state.getFilterHolder() != null) {
            postConditionManipulators.add(innerSpec.state.getFilterHolder());
        }
        for (InnerSpec spec : innerSpec.innerSpecs) {
            InnerSpecState.ManipulatorHolderSet traversed = this.traverse(spec);
            nodeSetManipulatorSnapshots.addAll(traversed.getNodeResolverObjectHolders());
            containerInfoManipulators.addAll(traversed.getContainerInfoManipulators());
            postConditionManipulators.addAll(traversed.getPostConditionManipulators());
        }
        return new InnerSpecState.ManipulatorHolderSet(nodeSetManipulatorSnapshots, containerInfoManipulators, postConditionManipulators);
    }
}

