/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.customizer;

import com.navercorp.fixturemonkey.expression.DefaultDeclarativeExpression;
import com.navercorp.fixturemonkey.tree.NextNodePredicate;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.5.0", status=API.Status.MAINTAINED)
final class InnerSpecState {
    @Nullable
    private NodeSetManipulatorSnapshot nodeSetManipulatorSnapshot;
    @Nullable
    private ContainerInfoSnapshot containerInfoSnapshot;
    @Nullable
    private FilterSnapshot filterSnapshot;

    InnerSpecState() {
    }

    void setNodeManipulatorSnapshot(@Nullable NodeSetManipulatorSnapshot nodeSetManipulatorSnapshot) {
        this.nodeSetManipulatorSnapshot = nodeSetManipulatorSnapshot;
    }

    void setContainerInfoSnapshot(@Nullable ContainerInfoSnapshot containerInfoSnapshot) {
        this.containerInfoSnapshot = containerInfoSnapshot;
    }

    void setFilterSnapshot(@Nullable FilterSnapshot filterSnapshot) {
        this.filterSnapshot = filterSnapshot;
    }

    @Nullable
    NodeSetManipulatorSnapshot getNodeManipulatorSnapshot() {
        return this.nodeSetManipulatorSnapshot;
    }

    @Nullable
    ContainerInfoSnapshot getContainerInfoHolder() {
        return this.containerInfoSnapshot;
    }

    @Nullable
    FilterSnapshot getFilterHolder() {
        return this.filterSnapshot;
    }

    InnerSpecState withPrefix(DefaultDeclarativeExpression parentDeclarativeExpression) {
        InnerSpecState newState = new InnerSpecState();
        if (this.nodeSetManipulatorSnapshot != null) {
            newState.nodeSetManipulatorSnapshot = new NodeSetManipulatorSnapshot(this.nodeSetManipulatorSnapshot.sequence, this.nodeSetManipulatorSnapshot.declarativeExpression.prepend(parentDeclarativeExpression), this.nodeSetManipulatorSnapshot.value);
        }
        if (this.filterSnapshot != null) {
            newState.filterSnapshot = new FilterSnapshot(this.filterSnapshot.sequence, this.filterSnapshot.declarativeExpression.prepend(parentDeclarativeExpression), this.filterSnapshot.type, this.filterSnapshot.predicate);
        }
        if (this.containerInfoSnapshot != null) {
            newState.containerInfoSnapshot = new ContainerInfoSnapshot(this.containerInfoSnapshot.sequence, this.containerInfoSnapshot.declarativeExpression.prepend(parentDeclarativeExpression), this.containerInfoSnapshot.elementMinSize, this.containerInfoSnapshot.elementMaxSize);
        }
        return newState;
    }

    static final class ManipulatorHolderSet {
        private final List<NodeSetManipulatorSnapshot> nodeSetManipulatorSnapshots;
        private final List<ContainerInfoSnapshot> containerInfoManipulators;
        private final List<FilterSnapshot> postConditionManipulators;

        public ManipulatorHolderSet(List<NodeSetManipulatorSnapshot> nodeSetManipulatorSnapshots, List<ContainerInfoSnapshot> containerInfoManipulators, List<FilterSnapshot> postConditionManipulators) {
            this.nodeSetManipulatorSnapshots = nodeSetManipulatorSnapshots;
            this.containerInfoManipulators = containerInfoManipulators;
            this.postConditionManipulators = postConditionManipulators;
        }

        public List<NodeSetManipulatorSnapshot> getNodeResolverObjectHolders() {
            return this.nodeSetManipulatorSnapshots;
        }

        public List<ContainerInfoSnapshot> getContainerInfoManipulators() {
            return this.containerInfoManipulators;
        }

        public List<FilterSnapshot> getPostConditionManipulators() {
            return this.postConditionManipulators;
        }
    }

    public static class NodeSetManipulatorSnapshot {
        private final int sequence;
        private final DefaultDeclarativeExpression declarativeExpression;
        private final Object value;

        public NodeSetManipulatorSnapshot(int sequence, DefaultDeclarativeExpression declarativeExpression, Object value) {
            this.sequence = sequence;
            this.declarativeExpression = declarativeExpression;
            this.value = value;
        }

        List<NextNodePredicate> getNextNodePredicates() {
            return this.declarativeExpression.getNestedNextNodePredicates();
        }

        Object getValue() {
            return this.value;
        }

        int getSequence() {
            return this.sequence;
        }
    }

    public static class FilterSnapshot {
        private final int sequence;
        private final DefaultDeclarativeExpression declarativeExpression;
        private final Class<?> type;
        private final Predicate<?> predicate;

        public FilterSnapshot(int sequence, DefaultDeclarativeExpression declarativeExpression, Class<?> type, Predicate<?> predicate) {
            this.sequence = sequence;
            this.declarativeExpression = declarativeExpression;
            this.type = type;
            this.predicate = predicate;
        }

        public int getSequence() {
            return this.sequence;
        }

        List<NextNodePredicate> getNextNodePredicates() {
            return this.declarativeExpression.getNestedNextNodePredicates();
        }

        Class<?> getType() {
            return this.type;
        }

        Predicate<?> getPredicate() {
            return this.predicate;
        }
    }

    public static class ContainerInfoSnapshot {
        private final int sequence;
        private final DefaultDeclarativeExpression declarativeExpression;
        private final int elementMinSize;
        private final int elementMaxSize;

        public ContainerInfoSnapshot(int sequence, DefaultDeclarativeExpression declarativeExpression, int elementMinSize, int elementMaxSize) {
            this.sequence = sequence;
            this.declarativeExpression = declarativeExpression;
            this.elementMinSize = elementMinSize;
            this.elementMaxSize = elementMaxSize;
        }

        int getSequence() {
            return this.sequence;
        }

        List<NextNodePredicate> getNextNodePredicates() {
            return this.declarativeExpression.getNestedNextNodePredicates();
        }

        int getElementMinSize() {
            return this.elementMinSize;
        }

        int getElementMaxSize() {
            return this.elementMaxSize;
        }
    }
}

