/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.customizer;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.container.DecomposedContainerValueFactory;
import com.navercorp.fixturemonkey.api.generator.ContainerPropertyGenerator;
import com.navercorp.fixturemonkey.api.lazy.LazyArbitrary;
import com.navercorp.fixturemonkey.api.matcher.MatcherOperator;
import com.navercorp.fixturemonkey.customizer.NodeManipulator;
import com.navercorp.fixturemonkey.customizer.NodeNullityManipulator;
import com.navercorp.fixturemonkey.customizer.NodeSetDecomposedValueManipulator;
import com.navercorp.fixturemonkey.customizer.Values;
import com.navercorp.fixturemonkey.tree.GenerateFixtureContext;
import com.navercorp.fixturemonkey.tree.ObjectNode;
import java.util.List;
import net.jqwik.api.Arbitrary;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class NodeSetLazyManipulator<T>
implements NodeManipulator {
    private final int sequence;
    private final DecomposedContainerValueFactory decomposedContainerValueFactory;
    private final List<MatcherOperator<ContainerPropertyGenerator>> containerPropertyGenerators;
    private final LazyArbitrary<T> lazyArbitrary;

    public NodeSetLazyManipulator(int sequence, DecomposedContainerValueFactory decomposedContainerValueFactory, List<MatcherOperator<ContainerPropertyGenerator>> containerPropertyGenerators, LazyArbitrary<T> lazyArbitrary) {
        this.sequence = sequence;
        this.decomposedContainerValueFactory = decomposedContainerValueFactory;
        this.containerPropertyGenerators = containerPropertyGenerators;
        this.lazyArbitrary = lazyArbitrary;
    }

    @Override
    public void manipulate(ObjectNode objectNode) {
        Object value = this.lazyArbitrary.getValue();
        if (value == null) {
            NodeNullityManipulator nullityManipulator = new NodeNullityManipulator(true);
            nullityManipulator.manipulate(objectNode);
            return;
        }
        if (value instanceof Arbitrary) {
            value = ((Arbitrary)value).sample();
        }
        if (value instanceof Values.Just) {
            Values.Just just = (Values.Just)value;
            GenerateFixtureContext generateFixtureContext = objectNode.getObjectNodeContext();
            generateFixtureContext.setArbitrary(CombinableArbitrary.from(just::getValue));
            this.lazyArbitrary.clear();
            return;
        }
        NodeSetDecomposedValueManipulator<Object> nodeSetDecomposedValueManipulator = new NodeSetDecomposedValueManipulator<Object>(this.sequence, this.decomposedContainerValueFactory, this.containerPropertyGenerators, value);
        nodeSetDecomposedValueManipulator.manipulate(objectNode);
        this.lazyArbitrary.clear();
    }
}

