/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.tree;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.context.MonkeyContext;
import com.navercorp.fixturemonkey.api.context.MonkeyGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGenerator;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorLoggingContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.generator.CompositeArbitraryGenerator;
import com.navercorp.fixturemonkey.api.generator.IntrospectedArbitraryGenerator;
import com.navercorp.fixturemonkey.api.generator.ValidateArbitraryGenerator;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.lazy.LazyArbitrary;
import com.navercorp.fixturemonkey.api.option.FixtureMonkeyOptions;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.tree.TraverseNode;
import com.navercorp.fixturemonkey.api.tree.TraverseNodeContext;
import com.navercorp.fixturemonkey.api.tree.TraverseNodeMetadata;
import com.navercorp.fixturemonkey.api.type.Types;
import com.navercorp.fixturemonkey.customizer.NodeManipulator;
import com.navercorp.fixturemonkey.tree.ObjectNode;
import com.navercorp.fixturemonkey.tree.ObjectNodeList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="1.1.4", status=API.Status.EXPERIMENTAL)
public final class GenerateFixtureContext
implements TraverseNodeContext {
    private final Map<Class<?>, ArbitraryIntrospector> arbitraryIntrospectorConfigurer;
    private final MonkeyContext monkeyContext;
    private final Supplier<Boolean> validOnly;
    private ObjectNode objectNode = null;
    private LazyArbitrary<Boolean> childNotCacheable = null;
    private final List<NodeManipulator> manipulators = new ArrayList<NodeManipulator>();
    private final List<Predicate> arbitraryFilters = new ArrayList<Predicate>();
    private final List<Function<CombinableArbitrary<?>, CombinableArbitrary<?>>> arbitraryCustomizers = new ArrayList();
    @Nullable
    private CombinableArbitrary<?> arbitrary;

    public GenerateFixtureContext(Map<Class<?>, ArbitraryIntrospector> arbitraryIntrospectorConfigurer, Supplier<Boolean> validOnly, MonkeyContext monkeyContext) {
        this.arbitraryIntrospectorConfigurer = arbitraryIntrospectorConfigurer;
        this.validOnly = validOnly;
        this.monkeyContext = monkeyContext;
    }

    private static boolean initializeChildNotCacheable(ObjectNode objectNode) {
        objectNode.expand();
        for (ObjectNode child : objectNode.getChildren().asList()) {
            GenerateFixtureContext childGenerateFixtureContext = child.getObjectNodeContext();
            if (!childGenerateFixtureContext.manipulated() && !((Boolean)childGenerateFixtureContext.childNotCacheable.getValue()).booleanValue() && !child.getMetadata().getTreeProperty().isContainer()) continue;
            return true;
        }
        return false;
    }

    public void addManipulator(NodeManipulator nodeManipulator) {
        this.manipulators.add(nodeManipulator);
    }

    public List<Predicate> getArbitraryFilters() {
        return this.arbitraryFilters;
    }

    public void addArbitraryFilter(Predicate filter) {
        this.arbitraryFilters.add(filter);
    }

    public void addGeneratedArbitraryCustomizer(Function<CombinableArbitrary<?>, CombinableArbitrary<?>> arbitraryCustomizer) {
        this.arbitraryCustomizers.add(arbitraryCustomizer);
    }

    public List<Function<CombinableArbitrary<?>, CombinableArbitrary<?>>> getGeneratedArbitraryCustomizers() {
        return this.arbitraryCustomizers;
    }

    public void addArbitraryCustomizer(Function<CombinableArbitrary<?>, CombinableArbitrary<?>> arbitraryCustomizer) {
        this.arbitraryCustomizers.add(arbitraryCustomizer);
    }

    public boolean manipulated() {
        return !this.manipulators.isEmpty() || this.objectNode.getMetadata().manipulated();
    }

    public boolean cacheable() {
        return !this.manipulated() && !this.objectNode.getMetadata().getTreeProperty().isContainer() && (Boolean)this.childNotCacheable.getValue() == false;
    }

    @Nullable
    public CombinableArbitrary<?> getArbitrary() {
        return this.arbitrary;
    }

    public void setArbitrary(@Nullable CombinableArbitrary<?> arbitrary) {
        this.arbitrary = arbitrary;
    }

    public CombinableArbitrary<?> generate(@Nullable ArbitraryGeneratorContext parentContext) {
        CombinableArbitrary<?> generated;
        FixtureMonkeyOptions fixtureMonkeyOptions = this.monkeyContext.getFixtureMonkeyOptions();
        if (this.getArbitrary() != null) {
            generated = this.getArbitrary().injectNull(this.objectNode.getMetadata().getNullInject());
        } else {
            CombinableArbitrary cached = this.monkeyContext.getCachedArbitrary(this.objectNode.getMetadata().getOriginalProperty());
            if (this.cacheable() && cached != null) {
                generated = cached;
            } else {
                ArbitraryGeneratorContext childArbitraryGeneratorContext = this.generateContext(parentContext);
                ArbitraryIntrospector arbitraryIntrospector = this.arbitraryIntrospectorConfigurer.get(Types.getActualType((Type)this.objectNode.getMetadata().getOriginalProperty().getType()));
                generated = this.getArbitraryGenerator(arbitraryIntrospector).generate(childArbitraryGeneratorContext);
                List<Function<CombinableArbitrary<?>, CombinableArbitrary<?>>> customizers = this.getGeneratedArbitraryCustomizers();
                for (Function<CombinableArbitrary<?>, CombinableArbitrary<?>> customizer : customizers) {
                    generated = customizer.apply(generated);
                }
                if (this.cacheable()) {
                    this.monkeyContext.putCachedArbitrary(this.objectNode.getMetadata().getOriginalProperty(), generated);
                }
            }
        }
        List<Predicate> arbitraryFilters = this.getArbitraryFilters();
        for (Predicate predicate : arbitraryFilters) {
            generated = generated.filter(fixtureMonkeyOptions.getGenerateMaxTries(), predicate);
        }
        return generated;
    }

    private ArbitraryGenerator getArbitraryGenerator(@Nullable ArbitraryIntrospector arbitraryIntrospector) {
        FixtureMonkeyOptions fixtureMonkeyOptions = this.monkeyContext.getFixtureMonkeyOptions();
        ArbitraryGenerator arbitraryGenerator = fixtureMonkeyOptions.getDefaultArbitraryGenerator();
        if (arbitraryIntrospector != null) {
            arbitraryGenerator = new CompositeArbitraryGenerator(Arrays.asList(new IntrospectedArbitraryGenerator(arbitraryIntrospector), arbitraryGenerator));
        }
        if (this.validOnly.get().booleanValue()) {
            arbitraryGenerator = new CompositeArbitraryGenerator(Arrays.asList(arbitraryGenerator, new ValidateArbitraryGenerator(fixtureMonkeyOptions.getJavaConstraintGenerator(), fixtureMonkeyOptions.getDecomposedContainerValueFactory())));
        }
        return arbitraryGenerator;
    }

    public ArbitraryGeneratorContext generateContext(@Nullable ArbitraryGeneratorContext parentContext) {
        HashMap<ArbitraryProperty, ObjectNode> childNodesByArbitraryProperty = new HashMap<ArbitraryProperty, ObjectNode>();
        ArrayList<ArbitraryProperty> childrenProperties = new ArrayList<ArbitraryProperty>();
        ArbitraryProperty arbitraryProperty = this.objectNode.getMetadata().getTreeProperty().toArbitraryProperty(this.objectNode.getMetadata().getNullInject());
        Property resolvedParentProperty = this.objectNode.getMetadata().getResolvedTypeDefinition().getResolvedProperty();
        this.objectNode.expand();
        List children = ((ObjectNodeList)Types.nullSafe((Object)this.objectNode.getChildren())).asList().stream().filter(it -> Types.isAssignable((Class)Types.getActualType((Type)resolvedParentProperty.getType()), (Class)Types.getActualType((Type)it.getMetadata().getResolvedParentProperty().getType()))).collect(Collectors.toList());
        for (ObjectNode childNode : children) {
            TraverseNodeMetadata childNodeMetadata = childNode.getMetadata();
            ArbitraryProperty childArbitraryProperty = childNodeMetadata.getTreeProperty().toArbitraryProperty(childNodeMetadata.getNullInject());
            childNodesByArbitraryProperty.put(childArbitraryProperty, childNode);
            childrenProperties.add(childArbitraryProperty);
        }
        MonkeyGeneratorContext monkeyGeneratorContext = this.monkeyContext.newGeneratorContext(this.objectNode.getMetadata().getRootProperty());
        FixtureMonkeyOptions fixtureMonkeyOptions = this.monkeyContext.getFixtureMonkeyOptions();
        ArbitraryGeneratorLoggingContext loggingContext = new ArbitraryGeneratorLoggingContext(fixtureMonkeyOptions.isEnableLoggingFail());
        return new ArbitraryGeneratorContext(resolvedParentProperty, arbitraryProperty, childrenProperties, parentContext, (currentContext, prop) -> {
            ObjectNode node = (ObjectNode)childNodesByArbitraryProperty.get(prop);
            if (node == null) {
                return CombinableArbitrary.NOT_GENERATED;
            }
            return node.getObjectNodeContext().generate((ArbitraryGeneratorContext)currentContext);
        }, this.objectNode.getMetadata().getLazyPropertyPath(), monkeyGeneratorContext, fixtureMonkeyOptions.getGenerateUniqueMaxTries(), arbitraryProperty.getNullInject(), loggingContext);
    }

    public void setTraverseNode(TraverseNode objectNode) {
        this.objectNode = (ObjectNode)objectNode;
        this.childNotCacheable = LazyArbitrary.lazy(() -> GenerateFixtureContext.initializeChildNotCacheable(this.objectNode));
    }

    public GenerateFixtureContext newChildNodeContext() {
        return new GenerateFixtureContext(this.arbitraryIntrospectorConfigurer, this.validOnly, this.monkeyContext);
    }
}

