/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.tree;

import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.Types;
import com.navercorp.fixturemonkey.tree.ObjectNode;
import com.navercorp.fixturemonkey.tree.ObjectNodeList;
import com.navercorp.fixturemonkey.tree.ObjectTreeMetadata;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
final class MetadataCollector {
    private final ObjectNode rootNode;
    private final Map<Property, List<ObjectNode>> nodesByProperty;
    private final Set<Annotation> annotations;

    public MetadataCollector(ObjectNode rootNode) {
        this.rootNode = rootNode;
        this.nodesByProperty = new LinkedHashMap<Property, List<ObjectNode>>();
        this.annotations = new HashSet<Annotation>();
    }

    public ObjectTreeMetadata collect() {
        this.rootNode.expand();
        List<ObjectNode> objectNodes = ((ObjectNodeList)Types.nullSafe((Object)this.rootNode.getChildren())).asList();
        for (ObjectNode child : objectNodes) {
            this.collect(child);
        }
        return new ObjectTreeMetadata(Collections.unmodifiableMap(this.nodesByProperty), Collections.unmodifiableSet(this.annotations));
    }

    private void collect(ObjectNode node) {
        Property property = node.getTreeProperty().getObjectProperty().getProperty();
        this.annotations.addAll(property.getAnnotations());
        node.expand();
        List<ObjectNode> children = ((ObjectNodeList)Types.nullSafe((Object)node.getChildren())).asList();
        for (ObjectNode child : children) {
            this.collect(child);
        }
        List<ObjectNode> list = Collections.singletonList(node);
        this.nodesByProperty.merge(property, list, (prev, now) -> Stream.concat(prev.stream(), now.stream()).collect(Collectors.toList()));
    }
}

