/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.tree;

import com.navercorp.fixturemonkey.api.property.SingleElementProperty;
import com.navercorp.fixturemonkey.api.type.Types;
import com.navercorp.fixturemonkey.tree.NextNodePredicate;
import com.navercorp.fixturemonkey.tree.NodeResolver;
import com.navercorp.fixturemonkey.tree.ObjectNode;
import com.navercorp.fixturemonkey.tree.ObjectNodeList;
import com.navercorp.fixturemonkey.tree.StartNodePredicate;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apiguardian.api.API;

@API(since="1.1.4", status=API.Status.EXPERIMENTAL)
public final class NodePredicateResolver
implements NodeResolver {
    private final NextNodePredicate nextNodePredicate;

    public NodePredicateResolver(NextNodePredicate nextNodePredicate) {
        this.nextNodePredicate = nextNodePredicate;
    }

    @Override
    public List<ObjectNode> resolve(ObjectNode nextNode) {
        if (this.nextNodePredicate == StartNodePredicate.INSTANCE) {
            return Collections.singletonList(this.resolveStartNode(nextNode));
        }
        nextNode.expand();
        List<ObjectNode> resolved = nextNode.getChildren().asList().stream().filter(it -> this.nextNodePredicate.test(it.getArbitraryProperty().getObjectProperty())).collect(Collectors.toList());
        nextNode.setNullInject(0.0);
        for (ObjectNode node : resolved) {
            node.setNullInject(0.0);
        }
        return resolved;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NodePredicateResolver that = (NodePredicateResolver)obj;
        return this.nextNodePredicate.equals(that.nextNodePredicate);
    }

    public int hashCode() {
        return Objects.hash(this.nextNodePredicate);
    }

    public ObjectNode resolveStartNode(ObjectNode startNode) {
        ObjectNode resultNode = this.getChildNodeIfWrapped(startNode);
        resultNode.setNullInject(0.0);
        return resultNode;
    }

    private ObjectNode getChildNodeIfWrapped(ObjectNode objectNode) {
        ObjectNode searchNode = objectNode;
        searchNode.expand();
        while (this.isWrappedNode(searchNode)) {
            searchNode = ((ObjectNodeList)Types.nullSafe((Object)searchNode.getChildren())).asList().get(0);
        }
        return searchNode;
    }

    private boolean isWrappedNode(ObjectNode searchNode) {
        List<ObjectNode> children = ((ObjectNodeList)Types.nullSafe((Object)searchNode.getChildren())).asList();
        return children.size() == 1 && children.get(0).getResolvedProperty() instanceof SingleElementProperty;
    }
}

