/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.builder;

import com.navercorp.fixturemonkey.ArbitraryBuilder;
import com.navercorp.fixturemonkey.api.ObjectBuilder;
import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.context.MonkeyContext;
import com.navercorp.fixturemonkey.api.expression.ExpressionGenerator;
import com.navercorp.fixturemonkey.api.expression.TypedPropertySelector;
import com.navercorp.fixturemonkey.api.instantiator.Instantiator;
import com.navercorp.fixturemonkey.api.instantiator.InstantiatorProcessResult;
import com.navercorp.fixturemonkey.api.instantiator.InstantiatorProcessor;
import com.navercorp.fixturemonkey.api.lazy.LazyArbitrary;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyNameResolver;
import com.navercorp.fixturemonkey.api.property.PropertySelector;
import com.navercorp.fixturemonkey.api.property.RootProperty;
import com.navercorp.fixturemonkey.api.property.TreeRootProperty;
import com.navercorp.fixturemonkey.api.property.TypeParameterProperty;
import com.navercorp.fixturemonkey.api.tree.TreeNodeManipulator;
import com.navercorp.fixturemonkey.api.type.LazyAnnotatedType;
import com.navercorp.fixturemonkey.api.type.TypeReference;
import com.navercorp.fixturemonkey.api.type.Types;
import com.navercorp.fixturemonkey.builder.ArbitraryBuilderContext;
import com.navercorp.fixturemonkey.builder.ArbitraryBuilderContextProvider;
import com.navercorp.fixturemonkey.customizer.ArbitraryManipulator;
import com.navercorp.fixturemonkey.customizer.ContainerInfoManipulator;
import com.navercorp.fixturemonkey.customizer.InnerSpec;
import com.navercorp.fixturemonkey.customizer.ManipulatorSet;
import com.navercorp.fixturemonkey.customizer.MonkeyManipulatorFactory;
import com.navercorp.fixturemonkey.customizer.Values;
import com.navercorp.fixturemonkey.experimental.ExperimentalArbitraryBuilder;
import com.navercorp.fixturemonkey.expression.MonkeyExpression;
import com.navercorp.fixturemonkey.expression.MonkeyExpressionFactory;
import com.navercorp.fixturemonkey.resolver.ArbitraryResolver;
import com.navercorp.fixturemonkey.tree.NextNodePredicate;
import com.navercorp.fixturemonkey.tree.NodeResolver;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Combinators;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"})
public final class DefaultArbitraryBuilder<T>
implements ArbitraryBuilder<T>,
ExperimentalArbitraryBuilder<T>,
ObjectBuilder<T>,
ArbitraryBuilderContextProvider {
    private final TreeRootProperty rootProperty;
    private final ArbitraryResolver resolver;
    private final MonkeyManipulatorFactory monkeyManipulatorFactory;
    private final MonkeyExpressionFactory monkeyExpressionFactory;
    private final ArbitraryBuilderContext context;
    private final MonkeyContext monkeyContext;
    private final InstantiatorProcessor instantiatorProcessor;

    public DefaultArbitraryBuilder(TreeRootProperty rootProperty, ArbitraryResolver resolver, MonkeyManipulatorFactory monkeyManipulatorFactory, MonkeyExpressionFactory monkeyExpressionFactory, ArbitraryBuilderContext context, MonkeyContext monkeyContext, InstantiatorProcessor instantiatorProcessor) {
        this.rootProperty = rootProperty;
        this.resolver = resolver;
        this.context = context;
        this.monkeyManipulatorFactory = monkeyManipulatorFactory;
        this.monkeyExpressionFactory = monkeyExpressionFactory;
        this.monkeyContext = monkeyContext;
        this.instantiatorProcessor = instantiatorProcessor;
    }

    @Override
    public ArbitraryBuilder<T> validOnly(boolean validOnly) {
        this.context.setCustomizedValidOnly(validOnly);
        return this;
    }

    @Override
    public ArbitraryBuilder<T> set(String expression, @Nullable Object value, int limit) {
        return this.set((PropertySelector)DefaultArbitraryBuilder.toExpressionGenerator(expression), value, limit);
    }

    @Override
    public ArbitraryBuilder<T> set(String expression, @Nullable Object value) {
        return this.set(expression, value, Integer.MAX_VALUE);
    }

    @Override
    public ArbitraryBuilder<T> set(@Nullable Object value) {
        return this.set("$", value);
    }

    @Override
    public ArbitraryBuilder<T> set(PropertySelector propertySelector, @Nullable Object value, int limit) {
        NodeResolver nodeResolver = this.toMonkeyExpression(propertySelector).toNodeResolver();
        if (value instanceof InnerSpec) {
            this.setInner((InnerSpec)value);
        } else {
            ArbitraryManipulator arbitraryManipulator = this.monkeyManipulatorFactory.newArbitraryManipulator(nodeResolver, value, limit);
            this.context.addManipulator(arbitraryManipulator);
        }
        return this;
    }

    @Override
    public ArbitraryBuilder<T> set(PropertySelector propertySelector, @Nullable Object value) {
        return this.set(propertySelector, value, Integer.MAX_VALUE);
    }

    @Override
    public ArbitraryBuilder<T> setLazy(String expression, Supplier<?> supplier, int limit) {
        return this.setLazy((PropertySelector)DefaultArbitraryBuilder.toExpressionGenerator(expression), supplier, limit);
    }

    @Override
    public ArbitraryBuilder<T> setLazy(String expression, Supplier<?> supplier) {
        return this.setLazy(expression, supplier, Integer.MAX_VALUE);
    }

    @Override
    public ArbitraryBuilder<T> setLazy(PropertySelector propertySelector, Supplier<?> supplier, int limit) {
        NodeResolver nodeResolver = this.toMonkeyExpression(propertySelector).toNodeResolver();
        ArbitraryManipulator arbitraryManipulator = this.monkeyManipulatorFactory.newArbitraryManipulator(nodeResolver, supplier, limit);
        this.context.addManipulator(arbitraryManipulator);
        return this;
    }

    @Override
    public ArbitraryBuilder<T> setLazy(PropertySelector propertySelector, Supplier<?> supplier) {
        return this.setLazy(propertySelector, supplier, Integer.MAX_VALUE);
    }

    @Override
    public ArbitraryBuilder<T> setInner(InnerSpec innerSpec) {
        ManipulatorSet manipulatorSet = innerSpec.getManipulatorSet(this.monkeyManipulatorFactory);
        List<ArbitraryManipulator> arbitraryManipulators = manipulatorSet.getArbitraryManipulators();
        List<ContainerInfoManipulator> containerInfoManipulators = manipulatorSet.getContainerInfoManipulators();
        this.context.addManipulators(arbitraryManipulators);
        this.context.addContainerInfoManipulators(containerInfoManipulators);
        return this;
    }

    @Override
    public ArbitraryBuilder<T> minSize(String expression, int minSize) {
        return this.size(expression, minSize, minSize + 3);
    }

    @Override
    public ArbitraryBuilder<T> minSize(PropertySelector propertySelector, int minSize) {
        return this.size(propertySelector, minSize, minSize + 3);
    }

    @Override
    public ArbitraryBuilder<T> maxSize(String expression, int maxSize) {
        return this.size(expression, Math.max(0, maxSize - 3), maxSize);
    }

    @Override
    public ArbitraryBuilder<T> maxSize(PropertySelector propertySelector, int maxSize) {
        return this.size(propertySelector, Math.max(0, maxSize - 3), maxSize);
    }

    @Override
    public ArbitraryBuilder<T> size(String expression, int size) {
        return this.size(expression, size, size);
    }

    @Override
    public ArbitraryBuilder<T> size(PropertySelector propertySelector, int size) {
        return this.size(propertySelector, size, size);
    }

    @Override
    public ArbitraryBuilder<T> size(String expression, int minSize, int maxSize) {
        return this.size((PropertySelector)DefaultArbitraryBuilder.toExpressionGenerator(expression), minSize, maxSize);
    }

    @Override
    public ArbitraryBuilder<T> size(PropertySelector propertySelector, int minSize, int maxSize) {
        if (minSize > maxSize) {
            throw new IllegalArgumentException("should be min > max, min : " + minSize + " max : " + maxSize);
        }
        List<NextNodePredicate> nextNodePredicates = this.toMonkeyExpression(propertySelector).toNextNodePredicate();
        ContainerInfoManipulator containerInfoManipulator = this.monkeyManipulatorFactory.newContainerInfoManipulator(nextNodePredicates, minSize, maxSize);
        this.context.addContainerInfoManipulator(containerInfoManipulator);
        return this;
    }

    @Override
    public ArbitraryBuilder<T> fixed() {
        this.context.getContainerInfoManipulators().forEach(TreeNodeManipulator::fixed);
        this.context.markFixed();
        return this;
    }

    @Override
    public ArbitraryBuilder<T> thenApply(BiConsumer<T, ArbitraryBuilder<T>> biConsumer) {
        this.context.getContainerInfoManipulators().forEach(TreeNodeManipulator::fixed);
        ArbitraryBuilder appliedBuilder = this.copy();
        LazyArbitrary lazyArbitrary = LazyArbitrary.lazy(() -> {
            ArbitraryBuilder lazyBuilder = appliedBuilder.copy();
            Object sampled = lazyBuilder.fixed().sample();
            biConsumer.accept(sampled, lazyBuilder);
            return lazyBuilder.sample();
        });
        NodeResolver nodeResolver = this.monkeyExpressionFactory.from("$").toNodeResolver();
        ArbitraryManipulator arbitraryManipulator = this.monkeyManipulatorFactory.newArbitraryManipulator(nodeResolver, lazyArbitrary);
        this.context.addManipulator(arbitraryManipulator);
        return this;
    }

    @Override
    public ArbitraryBuilder<T> acceptIf(Predicate<T> predicate, Consumer<ArbitraryBuilder<T>> consumer) {
        return this.thenApply((it, builder) -> {
            if (predicate.test(it)) {
                consumer.accept((ArbitraryBuilder)builder);
            }
        });
    }

    @Override
    public ArbitraryBuilder<T> setNull(String expression) {
        return this.setNull((PropertySelector)DefaultArbitraryBuilder.toExpressionGenerator(expression));
    }

    @Override
    public ArbitraryBuilder<T> setNull(PropertySelector propertySelector) {
        NodeResolver nodeResolver = this.toMonkeyExpression(propertySelector).toNodeResolver();
        ArbitraryManipulator arbitraryManipulator = this.monkeyManipulatorFactory.newArbitraryManipulator(nodeResolver, null);
        this.context.addManipulator(arbitraryManipulator);
        return this;
    }

    @Override
    public ArbitraryBuilder<T> setNotNull(String expression) {
        return this.setNotNull((PropertySelector)DefaultArbitraryBuilder.toExpressionGenerator(expression));
    }

    @Override
    public ArbitraryBuilder<T> setNotNull(PropertySelector propertySelector) {
        NodeResolver nodeResolver = this.toMonkeyExpression(propertySelector).toNodeResolver();
        ArbitraryManipulator arbitraryManipulator = this.monkeyManipulatorFactory.newArbitraryManipulator(nodeResolver, Values.NOT_NULL);
        this.context.addManipulator(arbitraryManipulator);
        return this;
    }

    @Override
    public ArbitraryBuilder<T> setPostCondition(Predicate<T> predicate) {
        return this.setPostCondition("$", Types.getActualType((Type)this.rootProperty.getType()), predicate);
    }

    @Override
    public <U> ArbitraryBuilder<T> setPostCondition(String expression, Class<U> type, Predicate<U> predicate) {
        return this.setPostCondition(expression, type, predicate, Integer.MAX_VALUE);
    }

    @Override
    public <U> ArbitraryBuilder<T> setPostCondition(String expression, Class<U> type, Predicate<U> predicate, int limit) {
        return this.setPostCondition((PropertySelector)DefaultArbitraryBuilder.toExpressionGenerator(expression), type, predicate, limit);
    }

    @Override
    public <U> ArbitraryBuilder<T> setPostCondition(PropertySelector propertySelector, Class<U> type, Predicate<U> predicate, int limit) {
        NodeResolver nodeResolver = this.toMonkeyExpression(propertySelector).toNodeResolver();
        ArbitraryManipulator arbitraryManipulator = this.monkeyManipulatorFactory.newArbitraryManipulator(nodeResolver, type, predicate, limit);
        this.context.addManipulator(arbitraryManipulator);
        return this;
    }

    @Override
    public <U> ArbitraryBuilder<T> setPostCondition(PropertySelector propertySelector, Class<U> type, Predicate<U> predicate) {
        return this.setPostCondition(propertySelector, type, predicate, Integer.MAX_VALUE);
    }

    @Override
    public <U> ArbitraryBuilder<U> map(Function<T, U> mapper) {
        LazyArbitrary lazyArbitrary = LazyArbitrary.lazy(() -> mapper.apply(this.sample()));
        return this.generateArbitraryBuilderLazily(lazyArbitrary);
    }

    @Override
    public <U, R> ArbitraryBuilder<R> zipWith(ArbitraryBuilder<U> other, BiFunction<T, U, R> combinator) {
        LazyArbitrary lazyArbitrary = LazyArbitrary.lazy(() -> combinator.apply(this.sample(), other.sample()));
        return this.generateArbitraryBuilderLazily(lazyArbitrary);
    }

    @Override
    public <U, V, R> ArbitraryBuilder<R> zipWith(ArbitraryBuilder<U> other, ArbitraryBuilder<V> another, Combinators.F3<T, U, V, R> combinator) {
        LazyArbitrary lazyArbitrary = LazyArbitrary.lazy(() -> combinator.apply(this.sample(), other.sample(), another.sample()));
        return this.generateArbitraryBuilderLazily(lazyArbitrary);
    }

    @Override
    public <U, V, W, R> ArbitraryBuilder<R> zipWith(ArbitraryBuilder<U> other, ArbitraryBuilder<V> another, ArbitraryBuilder<W> theOther, Combinators.F4<T, U, V, W, R> combinator) {
        LazyArbitrary lazyArbitrary = LazyArbitrary.lazy(() -> combinator.apply(this.sample(), other.sample(), another.sample(), theOther.sample()));
        return this.generateArbitraryBuilderLazily(lazyArbitrary);
    }

    @Override
    public <R> ArbitraryBuilder<R> zipWith(List<ArbitraryBuilder<?>> others, Function<List<?>, R> combinator) {
        LazyArbitrary lazyArbitrary = LazyArbitrary.lazy(() -> {
            ArrayList combinedList = new ArrayList();
            combinedList.add(this.sample());
            for (ArbitraryBuilder other : others) {
                combinedList.add(other.sample());
            }
            return combinator.apply(combinedList);
        });
        return this.generateArbitraryBuilderLazily(lazyArbitrary);
    }

    @Override
    public ExperimentalArbitraryBuilder<T> instantiate(Instantiator instantiator) {
        return this.instantiate(new TypeReference<T>(){

            public Type getType() {
                return DefaultArbitraryBuilder.this.rootProperty.getType();
            }

            public AnnotatedType getAnnotatedType() {
                return DefaultArbitraryBuilder.this.rootProperty.getAnnotatedType();
            }
        }, instantiator);
    }

    @Override
    public ExperimentalArbitraryBuilder<T> instantiate(Class<?> type, Instantiator instantiator) {
        return this.instantiate(new TypeReference(type){}, instantiator);
    }

    @Override
    public ExperimentalArbitraryBuilder<T> instantiate(TypeReference<?> typeReference, Instantiator instantiator) {
        InstantiatorProcessResult result = this.instantiatorProcessor.process(typeReference, instantiator);
        Class type = Types.getActualType((Type)typeReference.getType());
        this.context.putArbitraryIntrospector(type, result.getIntrospector());
        this.context.putPropertyConfigurer(type, result.getProperties());
        return this;
    }

    @Override
    public <U> ArbitraryBuilder<T> customizeProperty(TypedPropertySelector<U> propertySelector, Function<CombinableArbitrary<? extends U>, CombinableArbitrary<? extends U>> combinableArbitraryCustomizer) {
        NodeResolver nodeResolver = this.toMonkeyExpression((PropertySelector)propertySelector).toNodeResolver();
        this.context.addManipulator(this.monkeyManipulatorFactory.newArbitraryManipulator(nodeResolver, combinableArbitraryCustomizer));
        return this;
    }

    @Override
    public Arbitrary<T> build() {
        ArbitraryBuilderContext buildContext = this.context.copy();
        return Arbitraries.ofSuppliers((Supplier[])new Supplier[]{() -> this.resolveArbitrary(buildContext).combined()});
    }

    @Override
    public T sample() {
        return (T)this.resolveArbitrary(this.context).combined();
    }

    @Override
    public Stream<T> sampleStream() {
        return this.build().sampleStream();
    }

    @Override
    public List<T> sampleList(int size) {
        return this.sampleStream().limit(size).collect(Collectors.toList());
    }

    @Override
    public ArbitraryBuilder<T> copy() {
        return new DefaultArbitraryBuilder<T>(this.rootProperty, this.resolver, this.monkeyManipulatorFactory, this.monkeyExpressionFactory, this.context.copy(), this.monkeyContext, this.instantiatorProcessor);
    }

    @Override
    public ArbitraryBuilderContext getContext() {
        return this.context;
    }

    private CombinableArbitrary<?> resolveArbitrary(ArbitraryBuilderContext context) {
        if (context.isFixed()) {
            if (context.getFixedCombinableArbitrary() == null || context.fixedExpired()) {
                Object fixed = this.resolver.resolve(this.rootProperty, context).combined();
                NodeResolver nodeResolver = this.monkeyExpressionFactory.from("$").toNodeResolver();
                context.addManipulator(this.monkeyManipulatorFactory.newArbitraryManipulator(nodeResolver, fixed));
                context.renewFixed(CombinableArbitrary.from((Object)fixed));
            }
            return context.getFixedCombinableArbitrary();
        }
        return this.resolver.resolve(this.rootProperty, context);
    }

    private <R> DefaultArbitraryBuilder<R> generateArbitraryBuilderLazily(LazyArbitrary<R> lazyArbitrary) {
        ArbitraryBuilderContext context = ArbitraryBuilderContext.newBuilderContext(this.monkeyContext);
        NodeResolver nodeResolver = this.monkeyExpressionFactory.from("$").toNodeResolver();
        ArbitraryManipulator arbitraryManipulator = this.monkeyManipulatorFactory.newArbitraryManipulator(nodeResolver, lazyArbitrary);
        context.addManipulator(arbitraryManipulator);
        return new DefaultArbitraryBuilder<T>((TreeRootProperty)new RootProperty((Property)new TypeParameterProperty((AnnotatedType)new LazyAnnotatedType(() -> lazyArbitrary.getValue()))), this.resolver, this.monkeyManipulatorFactory, this.monkeyExpressionFactory, context, this.monkeyContext, this.instantiatorProcessor);
    }

    private static ExpressionGenerator toExpressionGenerator(String expression) {
        return propertyNameResolver -> expression;
    }

    private MonkeyExpression toMonkeyExpression(PropertySelector propertySelector) {
        if (propertySelector instanceof ExpressionGenerator) {
            String stringExpression = ((ExpressionGenerator)propertySelector).generate(property -> {
                PropertyNameResolver propertyNameResolver = this.monkeyContext.getFixtureMonkeyOptions().getPropertyNameResolver(property);
                return propertyNameResolver.resolve(property);
            });
            return this.monkeyExpressionFactory.from(stringExpression);
        }
        throw new UnsupportedOperationException("Given propertySelector is not supported. type of propertySelector: " + propertySelector.getClass());
    }
}

