/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.tree;

import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.lazy.LazyArbitrary;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyPath;
import com.navercorp.fixturemonkey.api.property.TreeRootProperty;
import com.navercorp.fixturemonkey.api.property.TypeDefinition;
import com.navercorp.fixturemonkey.api.tree.NodeList;
import com.navercorp.fixturemonkey.api.tree.TraverseNode;
import com.navercorp.fixturemonkey.api.tree.TraverseNodeMetadata;
import com.navercorp.fixturemonkey.api.tree.TreeNodeManipulator;
import com.navercorp.fixturemonkey.api.tree.TreeProperty;
import com.navercorp.fixturemonkey.api.type.Types;
import com.navercorp.fixturemonkey.tree.GenerateFixtureContext;
import com.navercorp.fixturemonkey.tree.ObjectNodeList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class ObjectNode
implements TraverseNode,
TraverseNodeMetadata {
    private final TraverseNode traverseNode;
    private final GenerateFixtureContext generateFixtureContext;
    @Nullable
    private ObjectNode parent;
    private List<ObjectNode> children;

    public ObjectNode(TraverseNode traverseNode, GenerateFixtureContext generateFixtureContext) {
        this.traverseNode = traverseNode;
        this.generateFixtureContext = generateFixtureContext;
        this.generateFixtureContext.setTraverseNode(this);
    }

    public void setChildren(List<ObjectNode> newChildren) {
        this.children = newChildren;
        for (ObjectNode child : this.children) {
            child.setParent(this);
        }
    }

    public void setParent(@Nullable ObjectNode parent) {
        this.parent = parent;
    }

    public boolean expand() {
        if (!this.traverseNode.expand() && this.children != null) {
            return false;
        }
        this.setChildren(((NodeList)Types.nullSafe((Object)this.traverseNode.getChildren())).asList().stream().map(it -> new ObjectNode((TraverseNode)it, this.generateFixtureContext.newChildNodeContext())).collect(Collectors.toList()));
        return true;
    }

    public void forceExpand() {
        this.traverseNode.forceExpand();
        this.setChildren(this.mergeWithNewChildren(((NodeList)Types.nullSafe((Object)this.traverseNode.getChildren())).asList().stream().map(it -> new ObjectNode((TraverseNode)it, this.generateFixtureContext.newChildNodeContext())).collect(Collectors.toList())));
    }

    public void forceExpand(TypeDefinition typeDefinition) {
        this.traverseNode.forceExpand(typeDefinition);
        this.setChildren(this.mergeWithNewChildren(((NodeList)Types.nullSafe((Object)this.traverseNode.getChildren())).asList().stream().map(it -> new ObjectNode((TraverseNode)it, this.generateFixtureContext.newChildNodeContext())).collect(Collectors.toList())));
    }

    public TraverseNodeMetadata getMetadata() {
        return this.traverseNode.getMetadata();
    }

    @Nullable
    public ObjectNode getParent() {
        return this.parent;
    }

    @Nullable
    public ObjectNodeList getChildren() {
        if (this.children == null) {
            return null;
        }
        return new ObjectNodeList(this.children);
    }

    public ArbitraryProperty getArbitraryProperty() {
        return this.getMetadata().getTreeProperty().toArbitraryProperty(this.getMetadata().getNullInject());
    }

    public TreeRootProperty getRootProperty() {
        return this.getMetadata().getRootProperty();
    }

    @Nullable
    public Property getResolvedParentProperty() {
        return this.getMetadata().getResolvedParentProperty();
    }

    public TypeDefinition getResolvedTypeDefinition() {
        return this.getMetadata().getResolvedTypeDefinition();
    }

    public Property getResolvedProperty() {
        return this.getMetadata().getResolvedTypeDefinition().getResolvedProperty();
    }

    public Property getOriginalProperty() {
        return this.getMetadata().getOriginalProperty();
    }

    public void setNullInject(double nullInject) {
        this.getMetadata().setNullInject(nullInject);
    }

    public TreeProperty getTreeProperty() {
        return this.getMetadata().getTreeProperty();
    }

    public double getNullInject() {
        return this.getMetadata().getNullInject();
    }

    public LazyArbitrary<PropertyPath> getLazyPropertyPath() {
        return this.getMetadata().getLazyPropertyPath();
    }

    public boolean manipulated() {
        return this.getMetadata().manipulated() && this.getObjectNodeContext().manipulated();
    }

    public List<TreeNodeManipulator> getTreeNodeManipulators() {
        return this.traverseNode.getMetadata().getTreeNodeManipulators();
    }

    public void addTreeNodeManipulator(TreeNodeManipulator treeNodeManipulator) {
        this.traverseNode.getMetadata().addTreeNodeManipulator(treeNodeManipulator);
    }

    public void setResolvedTypeDefinition(TypeDefinition typeDefinition) {
        this.traverseNode.getMetadata().setResolvedTypeDefinition(typeDefinition);
    }

    @Nullable
    public TreeNodeManipulator getAppliedTreeNodeManipulator() {
        return this.traverseNode.getMetadata().getAppliedTreeNodeManipulator();
    }

    public GenerateFixtureContext getObjectNodeContext() {
        return this.generateFixtureContext;
    }

    private List<ObjectNode> mergeWithNewChildren(List<ObjectNode> newChildren) {
        boolean expandChildNodes;
        boolean shrinkChildNodes;
        if (this.children == null) {
            return newChildren;
        }
        boolean bl = shrinkChildNodes = this.children.size() > newChildren.size();
        if (shrinkChildNodes) {
            return this.children.subList(0, newChildren.size());
        }
        boolean bl2 = expandChildNodes = this.children.size() < newChildren.size();
        if (expandChildNodes) {
            Map existingNodesByObjectProperty = this.children.stream().collect(Collectors.toMap(it -> it.getMetadata().getTreeProperty().getObjectProperty(), Function.identity()));
            ArrayList<ObjectNode> concatNewChildren = new ArrayList<ObjectNode>();
            for (ObjectNode newChild : newChildren) {
                ObjectNode existingNode = (ObjectNode)existingNodesByObjectProperty.get(newChild.getMetadata().getTreeProperty().getObjectProperty());
                if (existingNode != null) {
                    concatNewChildren.add(existingNode);
                    continue;
                }
                concatNewChildren.add(newChild);
            }
            return concatNewChildren;
        }
        return this.children;
    }
}

