/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.tree;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.property.TreeRootProperty;
import com.navercorp.fixturemonkey.api.tree.DefaultTraverseNode;
import com.navercorp.fixturemonkey.api.tree.TraverseContext;
import com.navercorp.fixturemonkey.api.tree.TraverseNode;
import com.navercorp.fixturemonkey.customizer.NodeManipulator;
import com.navercorp.fixturemonkey.tree.GenerateFixtureContext;
import com.navercorp.fixturemonkey.tree.MetadataCollector;
import com.navercorp.fixturemonkey.tree.NodeResolver;
import com.navercorp.fixturemonkey.tree.ObjectNode;
import com.navercorp.fixturemonkey.tree.ObjectTreeMetadata;
import java.util.List;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class ObjectTree {
    private final ObjectNode rootNode;
    private final ObjectTreeMetadata metadata;
    private final GenerateFixtureContext generateFixtureContext;

    public ObjectTree(TreeRootProperty rootProperty, GenerateFixtureContext generateFixtureContext, TraverseContext traverseContext) {
        this.rootNode = new ObjectNode((TraverseNode)DefaultTraverseNode.generateRootNode((TreeRootProperty)rootProperty, (TraverseContext)traverseContext), generateFixtureContext);
        MetadataCollector metadataCollector = new MetadataCollector(this.rootNode);
        this.metadata = metadataCollector.collect();
        this.generateFixtureContext = this.rootNode.getObjectNodeContext();
    }

    public ObjectTreeMetadata getMetadata() {
        return this.metadata;
    }

    public void manipulate(NodeResolver nodeResolver, NodeManipulator nodeManipulator) {
        List<ObjectNode> nodes = nodeResolver.resolve(this.rootNode);
        for (ObjectNode node : nodes) {
            nodeManipulator.manipulate(node);
            node.getObjectNodeContext().addManipulator(nodeManipulator);
        }
    }

    public CombinableArbitrary<?> generate() {
        return this.generateFixtureContext.generate(null);
    }
}

