/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.builder;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.context.MonkeyContext;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.matcher.MatcherOperator;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.tree.TreeProperty;
import com.navercorp.fixturemonkey.builder.ArbitraryBuilderContextProvider;
import com.navercorp.fixturemonkey.customizer.ArbitraryManipulator;
import com.navercorp.fixturemonkey.customizer.ContainerInfoManipulator;
import com.navercorp.fixturemonkey.tree.TraverseContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.INTERNAL)
public final class ArbitraryBuilderContext {
    private final List<ArbitraryManipulator> manipulators;
    private final List<ContainerInfoManipulator> containerInfoManipulators;
    private final Map<Class<?>, List<Property>> propertyConfigurers;
    private final Map<Class<?>, ArbitraryIntrospector> arbitraryIntrospectorsByType;
    private final MonkeyContext monkeyContext;
    private boolean validOnly;
    @Nullable
    private FixedState fixedState = null;
    @Nullable
    private CombinableArbitrary<?> fixedCombinableArbitrary;

    private ArbitraryBuilderContext(List<ArbitraryManipulator> manipulators, List<ContainerInfoManipulator> containerInfoManipulators, Map<Class<?>, List<Property>> propertyConfigurers, Map<Class<?>, ArbitraryIntrospector> arbitraryIntrospectorsByType, boolean validOnly, @Nullable FixedState fixedState, @Nullable CombinableArbitrary<?> fixedCombinableArbitrary, MonkeyContext monkeyContext) {
        this.manipulators = manipulators;
        this.containerInfoManipulators = containerInfoManipulators;
        this.propertyConfigurers = propertyConfigurers;
        this.arbitraryIntrospectorsByType = arbitraryIntrospectorsByType;
        this.validOnly = validOnly;
        this.fixedState = fixedState;
        this.fixedCombinableArbitrary = fixedCombinableArbitrary;
        this.monkeyContext = monkeyContext;
    }

    @Deprecated
    public static ArbitraryBuilderContext newBuilderContext(MonkeyContext monkeyContext) {
        return new ArbitraryBuilderContext(new ArrayList<ArbitraryManipulator>(), new ArrayList<ContainerInfoManipulator>(), new HashMap(), new HashMap(), true, null, null, monkeyContext);
    }

    public ArbitraryBuilderContext copy() {
        List<ContainerInfoManipulator> copiedContainerInfoManipulators = this.containerInfoManipulators.stream().map(ContainerInfoManipulator::copy).collect(Collectors.toList());
        return new ArbitraryBuilderContext(new ArrayList<ArbitraryManipulator>(this.manipulators), copiedContainerInfoManipulators, new HashMap(this.propertyConfigurers), new HashMap(this.arbitraryIntrospectorsByType), this.validOnly, this.fixedState, this.fixedCombinableArbitrary, this.monkeyContext);
    }

    public void addManipulator(ArbitraryManipulator arbitraryManipulator) {
        this.manipulators.add(arbitraryManipulator);
    }

    public void addManipulators(Collection<ArbitraryManipulator> arbitraryManipulators) {
        this.manipulators.addAll(arbitraryManipulators);
    }

    public List<ArbitraryManipulator> getManipulators() {
        return Collections.unmodifiableList(this.manipulators);
    }

    public void addContainerInfoManipulator(ContainerInfoManipulator containerInfo) {
        this.containerInfoManipulators.add(containerInfo);
    }

    public void addContainerInfoManipulators(List<ContainerInfoManipulator> containerInfoManipulators) {
        this.containerInfoManipulators.addAll(containerInfoManipulators);
    }

    public List<ContainerInfoManipulator> getContainerInfoManipulators() {
        return Collections.unmodifiableList(this.containerInfoManipulators);
    }

    public void putPropertyConfigurer(Class<?> type, List<Property> propertyConfigurer) {
        this.propertyConfigurers.put(type, propertyConfigurer);
    }

    public void putArbitraryIntrospector(Class<?> type, ArbitraryIntrospector arbitraryIntrospector) {
        this.arbitraryIntrospectorsByType.put(type, arbitraryIntrospector);
    }

    public Map<Class<?>, ArbitraryIntrospector> getArbitraryIntrospectorsByType() {
        return this.arbitraryIntrospectorsByType;
    }

    public Map<Class<?>, List<Property>> getPropertyConfigurers() {
        return this.propertyConfigurers;
    }

    public void setValidOnly(boolean validOnly) {
        this.validOnly = validOnly;
    }

    public boolean isValidOnly() {
        return this.validOnly;
    }

    public void markFixed() {
        if (this.fixedState != null && this.fixedState.getFixedManipulateSize() == this.manipulators.size() && this.fixedState.getFixedContainerManipulatorSize() == this.containerInfoManipulators.size()) {
            return;
        }
        this.fixedState = new FixedState(this.manipulators.size(), this.containerInfoManipulators.size());
        this.fixedCombinableArbitrary = null;
    }

    public boolean isFixed() {
        return this.fixedState != null;
    }

    public boolean fixedExpired() {
        return this.manipulators.size() > Objects.requireNonNull(this.fixedState).getFixedManipulateSize() || this.containerInfoManipulators.size() > this.fixedState.getFixedContainerManipulatorSize();
    }

    public void renewFixed(CombinableArbitrary<?> fixedCombinableArbitrary) {
        this.markFixed();
        this.fixedCombinableArbitrary = fixedCombinableArbitrary;
    }

    @Nullable
    public CombinableArbitrary<?> getFixedCombinableArbitrary() {
        return this.fixedCombinableArbitrary;
    }

    public TraverseContext newTraverseContext() {
        List<MatcherOperator<List<ContainerInfoManipulator>>> registeredContainerInfoManipulators = this.monkeyContext.getRegisteredArbitraryBuilders().stream().map(it -> new MatcherOperator(it.getMatcher(), ((ArbitraryBuilderContextProvider)it.getOperator()).getContext().getContainerInfoManipulators())).collect(Collectors.toList());
        return new TraverseContext(new ArrayList<TreeProperty>(), this.getContainerInfoManipulators(), registeredContainerInfoManipulators, this.getPropertyConfigurers(), this.getArbitraryIntrospectorsByType(), this.isValidOnly(), this.monkeyContext);
    }

    private static class FixedState {
        private final int fixedManipulateSize;
        private final int fixedContainerManipulatorSize;

        public FixedState(int fixedManipulateSize, int fixedContainerManipulatorSize) {
            this.fixedManipulateSize = fixedManipulateSize;
            this.fixedContainerManipulatorSize = fixedContainerManipulatorSize;
        }

        public int getFixedManipulateSize() {
            return this.fixedManipulateSize;
        }

        public int getFixedContainerManipulatorSize() {
            return this.fixedContainerManipulatorSize;
        }
    }
}

