/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.customizer;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.container.DecomposableJavaContainer;
import com.navercorp.fixturemonkey.api.container.DecomposedContainerValueFactory;
import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.property.MapEntryElementProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.TypeDefinition;
import com.navercorp.fixturemonkey.api.type.Types;
import com.navercorp.fixturemonkey.customizer.ContainerInfoManipulator;
import com.navercorp.fixturemonkey.customizer.NodeManipulator;
import com.navercorp.fixturemonkey.tree.IdentityNodeResolver;
import com.navercorp.fixturemonkey.tree.ObjectNode;
import java.lang.reflect.Type;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class NodeSetDecomposedValueManipulator<T>
implements NodeManipulator {
    private final int sequence;
    private final DecomposedContainerValueFactory decomposedContainerValueFactory;
    @Nullable
    private final T value;

    public NodeSetDecomposedValueManipulator(int sequence, DecomposedContainerValueFactory decomposedContainerValueFactory, @Nullable T value) {
        this.sequence = sequence;
        this.decomposedContainerValueFactory = decomposedContainerValueFactory;
        this.value = value;
    }

    @Override
    public void manipulate(ObjectNode objectNode) {
        Class actualType = Types.getActualType((Type)objectNode.getOriginalProperty().getType());
        if (this.value != null && !Types.isAssignable(this.value.getClass(), (Class)actualType)) {
            String parentNodeLogMessage = objectNode.getResolvedParentProperty() != null ? String.format("parent node type : %s", objectNode.getResolvedParentProperty().getType().getTypeName()) : "";
            throw new IllegalArgumentException(String.format("The value is not of the same type as the property.\n%s node name: %s, node type: %s, value type: %s", parentNodeLogMessage, objectNode.getArbitraryProperty().getObjectProperty().getResolvedPropertyName(), objectNode.getOriginalProperty().getType().getTypeName(), this.value.getClass().getTypeName()));
        }
        this.setValue(objectNode, this.value);
    }

    private void setValue(ObjectNode objectNode, @Nullable Object value) {
        objectNode.setNullInject(0.0);
        if (value == null) {
            objectNode.addManipulator(node -> node.setArbitrary(CombinableArbitrary.from(null)));
            objectNode.setNullInject(1.0);
            return;
        }
        boolean container = objectNode.getArbitraryProperty().isContainer();
        if (container) {
            boolean forced;
            if (Types.getActualType((Type)objectNode.getResolvedProperty().getType()) == Function.class) {
                objectNode.setArbitrary(CombinableArbitrary.from((Object)value));
                return;
            }
            DecomposableJavaContainer decomposableJavaContainer = this.decomposedContainerValueFactory.from(value);
            Object containerValue = decomposableJavaContainer.getJavaContainer();
            int decomposedContainerSize = decomposableJavaContainer.getSize();
            ContainerInfoManipulator appliedContainerInfoManipulator = objectNode.getAppliedContainerInfoManipulator();
            boolean bl = forced = !(objectNode.getOriginalProperty() instanceof MapEntryElementProperty) && (appliedContainerInfoManipulator == null || this.sequence > appliedContainerInfoManipulator.getManipulatingSequence());
            if (forced) {
                ArbitraryContainerInfo containerInfo = new ArbitraryContainerInfo(decomposedContainerSize, decomposedContainerSize);
                objectNode.addContainerManipulator(new ContainerInfoManipulator(IdentityNodeResolver.INSTANCE.toNextNodePredicate(), containerInfo, this.sequence));
                objectNode.forceExpand();
            }
            List<ObjectNode> children = objectNode.resolveChildren();
            if (objectNode.getArbitraryProperty().getObjectProperty().getProperty() instanceof MapEntryElementProperty) {
                decomposedContainerSize *= 2;
            }
            int decomposedNodeSize = Math.min(decomposedContainerSize, children.size());
            for (int i = 0; i < decomposedNodeSize; ++i) {
                ObjectNode child = children.get(i);
                Property childProperty = child.getOriginalProperty();
                this.setValue(child, childProperty.getValue(containerValue));
            }
            return;
        }
        List<ObjectNode> children = objectNode.resolveChildren();
        if (children.isEmpty() || Types.getActualType((Type)objectNode.getResolvedProperty().getType()).isInterface()) {
            CombinableArbitrary combinableArbitrary = CombinableArbitrary.from((Object)value);
            objectNode.addManipulator(node -> node.setArbitrary(combinableArbitrary));
            objectNode.setArbitrary(combinableArbitrary);
            return;
        }
        List typeDefinitions = objectNode.getTreeProperty().getTypeDefinitions();
        for (TypeDefinition typeDefinition : typeDefinitions) {
            Class actualConcreteType = Types.getActualType((Type)typeDefinition.getResolvedProperty().getType());
            if (!Types.isAssignable(value.getClass(), (Class)actualConcreteType)) continue;
            if (Types.isAssignable((Class)actualConcreteType, value.getClass())) {
                objectNode.setResolvedTypeDefinition(typeDefinition);
            }
            objectNode.forceExpand(typeDefinition);
            for (ObjectNode child : objectNode.getChildren()) {
                if (!typeDefinition.equals(child.getParent().getResolvedTypeDefinition())) continue;
                Property childProperty = child.getOriginalProperty();
                this.setValue(child, childProperty.getValue(value));
            }
        }
    }
}

