/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.resolver;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.exception.ContainerSizeFilterMissException;
import com.navercorp.fixturemonkey.api.exception.FixedValueFilterMissException;
import com.navercorp.fixturemonkey.api.exception.RetryableFilterMissException;
import com.navercorp.fixturemonkey.api.lazy.LazyArbitrary;
import com.navercorp.fixturemonkey.api.property.RootProperty;
import com.navercorp.fixturemonkey.api.validator.ArbitraryValidator;
import com.navercorp.fixturemonkey.tree.ObjectTree;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apiguardian.api.API;

@API(since="0.6.9", status=API.Status.MAINTAINED)
final class ResolvedCombinableArbitrary<T>
implements CombinableArbitrary<T> {
    private static final int VALIDATION_ANNOTATION_FILTERING_COUNT = 1;
    private final RootProperty rootProperty;
    private final LazyArbitrary<ObjectTree> objectTree;
    private final int generateMaxTries;
    private final LazyArbitrary<CombinableArbitrary<T>> arbitrary;
    private final ArbitraryValidator validator;
    private final boolean validOnly;
    private Exception lastException = null;

    public ResolvedCombinableArbitrary(RootProperty rootProperty, Supplier<ObjectTree> regenerateTree, Function<ObjectTree, CombinableArbitrary<T>> generateArbitrary, int generateMaxTries, ArbitraryValidator validator, boolean validOnly) {
        this.rootProperty = rootProperty;
        this.objectTree = LazyArbitrary.lazy(regenerateTree);
        this.generateMaxTries = generateMaxTries;
        this.arbitrary = LazyArbitrary.lazy(() -> {
            ObjectTree objectTree = (ObjectTree)this.objectTree.getValue();
            return (CombinableArbitrary)generateArbitrary.apply(objectTree);
        });
        this.validator = validator;
        this.validOnly = validOnly;
    }

    public T combined() {
        for (int i = 0; i < this.generateMaxTries; ++i) {
            try {
                Object object = ((CombinableArbitrary)this.arbitrary.getValue()).filter(1, this.validateFilter(this.validOnly)).combined();
                return (T)object;
            }
            catch (ContainerSizeFilterMissException | RetryableFilterMissException ex) {
                this.lastException = ex;
                this.objectTree.clear();
                continue;
            }
            catch (FixedValueFilterMissException ex) {
                this.lastException = ex;
                continue;
            }
            finally {
                this.arbitrary.clear();
            }
        }
        throw new IllegalArgumentException(String.format("Given type %s could not be generated. Check the ArbitraryIntrospector used or the APIs used in the ArbitraryBuilder.", this.rootProperty.getType()), this.lastException);
    }

    public Object rawValue() {
        for (int i = 0; i < this.generateMaxTries; ++i) {
            try {
                Object object = ((CombinableArbitrary)this.arbitrary.getValue()).filter(1, this.validateFilter(this.validOnly)).rawValue();
                return object;
            }
            catch (ContainerSizeFilterMissException | RetryableFilterMissException ex) {
                this.lastException = ex;
                this.objectTree.clear();
                continue;
            }
            catch (FixedValueFilterMissException ex) {
                this.lastException = ex;
                continue;
            }
            finally {
                this.arbitrary.clear();
            }
        }
        throw new IllegalArgumentException(String.format("Given type %s could not be generated. Check the ArbitraryIntrospector used or the APIs used in the ArbitraryBuilder.", this.rootProperty.getType()), this.lastException);
    }

    public void clear() {
    }

    public CombinableArbitrary<T> unique() {
        return ((CombinableArbitrary)this.arbitrary.getValue()).unique();
    }

    public boolean fixed() {
        return false;
    }

    private Predicate<T> validateFilter(boolean validOnly) {
        return fixture -> {
            if (!validOnly) {
                return true;
            }
            if (fixture == null) {
                return true;
            }
            this.validator.validate(fixture);
            return true;
        };
    }
}

