/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.tree;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.container.ConcurrentLruCache;
import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGenerator;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.generator.ContainerPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.ObjectProperty;
import com.navercorp.fixturemonkey.api.generator.ObjectPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.ObjectPropertyGeneratorContext;
import com.navercorp.fixturemonkey.api.lazy.LazyArbitrary;
import com.navercorp.fixturemonkey.api.option.FixtureMonkeyOptions;
import com.navercorp.fixturemonkey.api.property.CandidateConcretePropertyResolver;
import com.navercorp.fixturemonkey.api.property.CompositeTypeDefinition;
import com.navercorp.fixturemonkey.api.property.DefaultCandidateConcretePropertyResolver;
import com.navercorp.fixturemonkey.api.property.DefaultTypeDefinition;
import com.navercorp.fixturemonkey.api.property.ElementPropertyGenerator;
import com.navercorp.fixturemonkey.api.property.LazyPropertyGenerator;
import com.navercorp.fixturemonkey.api.property.MapEntryElementProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyGenerator;
import com.navercorp.fixturemonkey.api.property.PropertyPath;
import com.navercorp.fixturemonkey.api.property.RootProperty;
import com.navercorp.fixturemonkey.api.property.TypeDefinition;
import com.navercorp.fixturemonkey.api.tree.ObjectTreeNode;
import com.navercorp.fixturemonkey.api.tree.TreeProperty;
import com.navercorp.fixturemonkey.api.type.Types;
import com.navercorp.fixturemonkey.customizer.ContainerInfoManipulator;
import com.navercorp.fixturemonkey.customizer.NodeManipulator;
import com.navercorp.fixturemonkey.tree.TraverseContext;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class ObjectNode
implements ObjectTreeNode {
    private static final ConcurrentLruCache<Property, List<Property>> CANDIDATE_CONCRETE_PROPERTIES_BY_PROPERTY = new ConcurrentLruCache(1024);
    private final RootProperty rootProperty;
    @Nullable
    private final Property resolvedParentProperty;
    private TypeDefinition resolvedTypeDefinition;
    private final TreeProperty treeProperty;
    private final TraverseContext traverseContext;
    @Nullable
    private ObjectNode parent = null;
    private List<ObjectNode> children;
    @Nullable
    private CombinableArbitrary<?> arbitrary;
    private double nullInject;
    @Nullable
    private TypeDefinition expandedTypeDefinition = null;
    private final List<NodeManipulator> manipulators = new ArrayList<NodeManipulator>();
    private final List<ContainerInfoManipulator> containerInfoManipulators = new ArrayList<ContainerInfoManipulator>();
    private final List<Predicate> arbitraryFilters = new ArrayList<Predicate>();
    private final List<Function<CombinableArbitrary<?>, CombinableArbitrary<?>>> arbitraryCustomizers = new ArrayList();
    private final LazyArbitrary<Boolean> childNotCacheable = LazyArbitrary.lazy(() -> {
        for (ObjectNode child : this.resolveChildren()) {
            if (!child.manipulated() && !((Boolean)child.childNotCacheable.getValue()).booleanValue() && !child.treeProperty.isContainer()) continue;
            return true;
        }
        return false;
    });
    private final LazyArbitrary<PropertyPath> lazyPropertyPath = LazyArbitrary.lazy(() -> {
        Property resolvedProperty = this.resolvedTypeDefinition.getResolvedProperty();
        if (this.parent == null) {
            return new PropertyPath(resolvedProperty, null, 1);
        }
        PropertyPath parentPropertyPath = (PropertyPath)this.parent.getLazyPropertyPath().getValue();
        return new PropertyPath(resolvedProperty, parentPropertyPath, parentPropertyPath.getDepth() + 1);
    });

    ObjectNode(RootProperty rootProperty, @Nullable Property resolvedParentProperty, TypeDefinition resolvedTypeDefinition, TreeProperty treeProperty, double nullInject, TraverseContext traverseContext) {
        this.rootProperty = rootProperty;
        this.resolvedParentProperty = resolvedParentProperty;
        this.resolvedTypeDefinition = resolvedTypeDefinition;
        this.treeProperty = treeProperty;
        this.nullInject = nullInject;
        this.traverseContext = traverseContext;
    }

    @Nullable
    public Property getResolvedParentProperty() {
        return this.resolvedParentProperty;
    }

    public Property getResolvedProperty() {
        return this.resolvedTypeDefinition.getResolvedProperty();
    }

    public TypeDefinition getResolvedTypeDefinition() {
        return this.resolvedTypeDefinition;
    }

    public void setResolvedTypeDefinition(TypeDefinition typeDefinition) {
        this.resolvedTypeDefinition = typeDefinition;
    }

    public TreeProperty getTreeProperty() {
        return this.treeProperty;
    }

    public Property getOriginalProperty() {
        return this.getTreeProperty().getObjectProperty().getProperty();
    }

    public List<ObjectNode> resolveChildren() {
        this.expand(this.resolvedTypeDefinition);
        return this.children;
    }

    public List<ObjectNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<ObjectNode> children) {
        this.children = children;
        for (ObjectNode child : this.children) {
            child.parent = this;
        }
    }

    public ArbitraryProperty getArbitraryProperty() {
        return this.treeProperty.toArbitraryProperty(this.nullInject);
    }

    @Nullable
    public CombinableArbitrary<?> getArbitrary() {
        return this.arbitrary;
    }

    public void setArbitrary(@Nullable CombinableArbitrary<?> arbitrary) {
        this.arbitrary = arbitrary;
    }

    public void addContainerManipulator(ContainerInfoManipulator containerInfoManipulator) {
        this.traverseContext.addContainerInfoManipulator(containerInfoManipulator);
        this.containerInfoManipulators.add(containerInfoManipulator);
    }

    public void addManipulator(NodeManipulator nodeManipulator) {
        this.manipulators.add(nodeManipulator);
    }

    public List<Predicate> getArbitraryFilters() {
        return this.arbitraryFilters;
    }

    public void addArbitraryFilter(Predicate filter) {
        this.arbitraryFilters.add(filter);
    }

    public void addGeneratedArbitraryCustomizer(Function<CombinableArbitrary<?>, CombinableArbitrary<?>> arbitraryCustomizer) {
        this.arbitraryCustomizers.add(arbitraryCustomizer);
    }

    public List<Function<CombinableArbitrary<?>, CombinableArbitrary<?>>> getGeneratedArbitraryCustomizers() {
        return this.arbitraryCustomizers;
    }

    public void addArbitraryCustomizer(Function<CombinableArbitrary<?>, CombinableArbitrary<?>> arbitraryCustomizer) {
        this.arbitraryCustomizers.add(arbitraryCustomizer);
    }

    public double getNullInject() {
        return this.nullInject;
    }

    public void setNullInject(double nullInject) {
        this.nullInject = nullInject;
    }

    public boolean manipulated() {
        return !this.manipulators.isEmpty() || !this.containerInfoManipulators.isEmpty();
    }

    public boolean cacheable() {
        return !this.manipulated() && !this.treeProperty.isContainer() && (Boolean)this.childNotCacheable.getValue() == false;
    }

    @Nullable
    public ObjectNode getParent() {
        return this.parent;
    }

    @Nullable
    public ContainerInfoManipulator getAppliedContainerInfoManipulator() {
        if (this.containerInfoManipulators.isEmpty()) {
            return null;
        }
        return this.containerInfoManipulators.get(this.containerInfoManipulators.size() - 1);
    }

    public LazyArbitrary<PropertyPath> getLazyPropertyPath() {
        return this.lazyPropertyPath;
    }

    public void expand(TypeDefinition typeDefinition) {
        if (this.expandedTypeDefinition == this.resolvedTypeDefinition) {
            return;
        }
        List<ObjectNode> newChildren = this.getTreeProperty().isContainer() ? this.expandContainerNode(typeDefinition, this.traverseContext).collect(Collectors.toList()) : this.generateChildrenNodes(typeDefinition.getResolvedProperty(), typeDefinition.getPropertyGenerator().generateChildProperties(typeDefinition.getResolvedProperty()), this.nullInject, this.traverseContext);
        this.setChildren(newChildren);
        this.expandedTypeDefinition = this.resolvedTypeDefinition;
    }

    public void expand() {
        if (this.expandedTypeDefinition == this.resolvedTypeDefinition) {
            return;
        }
        this.setChildren(this.getTreeProperty().getTypeDefinitions().stream().flatMap(typeDefinition -> {
            if (this.getTreeProperty().isContainer()) {
                return this.expandContainerNode((TypeDefinition)typeDefinition, this.traverseContext);
            }
            return this.generateChildrenNodes(typeDefinition.getResolvedProperty(), typeDefinition.getPropertyGenerator().generateChildProperties(typeDefinition.getResolvedProperty()), this.nullInject, this.traverseContext).stream();
        }).collect(Collectors.toList()));
        this.expandedTypeDefinition = this.resolvedTypeDefinition;
    }

    public void forceExpand() {
        List<ObjectNode> newChildren = this.getTreeProperty().getTypeDefinitions().stream().flatMap(typeDefinition -> {
            if (this.getTreeProperty().isContainer()) {
                return this.expandContainerNode((TypeDefinition)typeDefinition, this.traverseContext.withParentProperties());
            }
            return this.generateChildrenNodes(typeDefinition.getResolvedProperty(), typeDefinition.getPropertyGenerator().generateChildProperties(typeDefinition.getResolvedProperty()), this.nullInject, this.traverseContext.withParentProperties()).stream();
        }).collect(Collectors.toList());
        this.setChildren(newChildren);
        this.expandedTypeDefinition = this.resolvedTypeDefinition;
    }

    public void forceExpand(TypeDefinition typeDefinition) {
        List<ObjectNode> newChildren = this.getTreeProperty().isContainer() ? this.expandContainerNode(typeDefinition, this.traverseContext.withParentProperties()).collect(Collectors.toList()) : this.generateChildrenNodes(typeDefinition.getResolvedProperty(), typeDefinition.getPropertyGenerator().generateChildProperties(typeDefinition.getResolvedProperty()), this.nullInject, this.traverseContext.withParentProperties());
        this.setChildren(newChildren);
        this.expandedTypeDefinition = this.resolvedTypeDefinition;
    }

    private Stream<ObjectNode> expandContainerNode(TypeDefinition typeDefinition, TraverseContext traverseContext) {
        ContainerInfoManipulator appliedContainerInfoManipulator = this.getAppliedContainerInfoManipulator();
        ArbitraryContainerInfo containerInfo = appliedContainerInfoManipulator != null ? appliedContainerInfoManipulator.getContainerInfo() : null;
        PropertyGenerator propertyGenerator = typeDefinition.getPropertyGenerator();
        if (propertyGenerator instanceof LazyPropertyGenerator) {
            propertyGenerator = ((LazyPropertyGenerator)propertyGenerator).getDelegate();
        }
        if (propertyGenerator instanceof ElementPropertyGenerator) {
            ((ElementPropertyGenerator)propertyGenerator).updateContainerInfo(containerInfo);
        }
        List elementProperties = propertyGenerator.generateChildProperties(typeDefinition.getResolvedProperty());
        return this.generateChildrenNodes(typeDefinition.getResolvedProperty(), elementProperties, this.nullInject, traverseContext).stream();
    }

    static ObjectNode generateRootNode(RootProperty rootProperty, TraverseContext traverseContext) {
        return ObjectNode.generateObjectNode(rootProperty, null, (Property)rootProperty, null, 0.0, traverseContext);
    }

    static ObjectNode generateObjectNode(RootProperty rootProperty, @Nullable Property resolvedParentProperty, Property property, @Nullable Integer propertySequence, double parentNullInject, TraverseContext context) {
        FixtureMonkeyOptions fixtureMonkeyOptions = context.getMonkeyContext().getFixtureMonkeyOptions();
        ContainerPropertyGenerator containerPropertyGenerator = fixtureMonkeyOptions.getContainerPropertyGenerator(property);
        boolean container = containerPropertyGenerator != null;
        ObjectPropertyGenerator objectPropertyGenerator = fixtureMonkeyOptions.getObjectPropertyGenerator(property);
        TreeProperty parentTreeProperty = context.getLastTreeProperty();
        ArbitraryProperty parentArbitraryProperty = parentTreeProperty != null ? parentTreeProperty.toArbitraryProperty(parentNullInject) : null;
        ObjectPropertyGeneratorContext objectPropertyGeneratorContext = new ObjectPropertyGeneratorContext(property, ObjectNode.resolveIndex(resolvedParentProperty, parentTreeProperty, propertySequence, fixtureMonkeyOptions), parentArbitraryProperty, container, fixtureMonkeyOptions.getPropertyNameResolver(property));
        ObjectProperty objectProperty = objectPropertyGenerator.generate(objectPropertyGeneratorContext);
        List<Property> candidateProperties = ObjectNode.resolveCandidateProperties(property, fixtureMonkeyOptions);
        List<ObjectProperty> objectProperties = context.getTreeProperties().stream().map(TreeProperty::getObjectProperty).collect(Collectors.toList());
        objectProperties.add(objectProperty);
        ContainerInfoManipulator appliedContainerInfoManipulator = ObjectNode.resolveAppliedContainerInfoManipulator(container, context.getContainerInfoManipulators(), objectProperties);
        List typeDefinitions = candidateProperties.stream().map(concreteProperty -> {
            if (!container) {
                LazyPropertyGenerator lazyPropertyGenerator = new LazyPropertyGenerator(ObjectNode.getPropertyGenerator(context.getPropertyConfigurers(), fixtureMonkeyOptions));
                return new DefaultTypeDefinition(concreteProperty, lazyPropertyGenerator);
            }
            ElementPropertyGenerator containerElementPropertyGenerator = new ElementPropertyGenerator(property, containerPropertyGenerator, fixtureMonkeyOptions.getArbitraryContainerInfoGenerator(property), null);
            LazyPropertyGenerator lazyPropertyGenerator = new LazyPropertyGenerator((PropertyGenerator)containerElementPropertyGenerator);
            return new DefaultTypeDefinition(concreteProperty, lazyPropertyGenerator);
        }).collect(Collectors.toList());
        double nullInject = fixtureMonkeyOptions.getNullInjectGenerator(property).generate(objectPropertyGeneratorContext);
        TreeProperty treeProperty = new TreeProperty(objectProperty, container, typeDefinitions);
        TraverseContext nextTraverseContext = context.appendArbitraryProperty(treeProperty);
        ObjectNode newObjectNode = new ObjectNode(rootProperty, resolvedParentProperty, new CompositeTypeDefinition(typeDefinitions).getResolvedTypeDefinition(), treeProperty, nullInject, nextTraverseContext);
        if (appliedContainerInfoManipulator != null) {
            newObjectNode.addContainerManipulator(appliedContainerInfoManipulator);
        }
        return newObjectNode;
    }

    @Nullable
    private static Integer resolveIndex(@Nullable Property resolvedParentProperty, @Nullable TreeProperty parentTreeProperty, @Nullable Integer propertySequence, FixtureMonkeyOptions fixtureMonkeyOptions) {
        boolean parentContainer;
        if (resolvedParentProperty == null || parentTreeProperty == null) {
            return null;
        }
        boolean bl = parentContainer = fixtureMonkeyOptions.getContainerPropertyGenerator(resolvedParentProperty) != null;
        if (!parentContainer) {
            return null;
        }
        if (propertySequence == null) {
            return null;
        }
        int index = propertySequence;
        if (parentTreeProperty.getObjectProperty().getProperty() instanceof MapEntryElementProperty) {
            index /= 2;
        }
        return index;
    }

    private List<ObjectNode> generateChildrenNodes(Property resolvedParentProperty, List<Property> childProperties, double parentNullInject, TraverseContext context) {
        ArrayList<ObjectNode> children = new ArrayList<ObjectNode>();
        for (int sequence = 0; sequence < childProperties.size(); ++sequence) {
            Property childProperty = childProperties.get(sequence);
            if (context.isTraversed(childProperty) && !(resolvedParentProperty instanceof MapEntryElementProperty)) continue;
            ObjectNode childNode = ObjectNode.generateObjectNode(this.rootProperty, resolvedParentProperty, childProperty, sequence, parentNullInject, context);
            children.add(childNode);
        }
        return children;
    }

    @Nullable
    private static ContainerInfoManipulator resolveAppliedContainerInfoManipulator(boolean container, List<ContainerInfoManipulator> containerInfoManipulators, List<ObjectProperty> objectProperties) {
        if (!container) {
            return null;
        }
        ContainerInfoManipulator appliedContainerInfoManipulator = null;
        for (ContainerInfoManipulator containerInfoManipulator : containerInfoManipulators) {
            if (!containerInfoManipulator.isMatch(objectProperties)) continue;
            appliedContainerInfoManipulator = containerInfoManipulator;
        }
        return appliedContainerInfoManipulator;
    }

    private static PropertyGenerator getPropertyGenerator(Map<Class<?>, List<Property>> propertyConfigurers, FixtureMonkeyOptions fixtureMonkeyOptions) {
        PropertyGenerator resolvedPropertyGenerator = property -> {
            Class type = Types.getActualType((Type)property.getType());
            List propertyConfigurer = (List)propertyConfigurers.get(type);
            if (propertyConfigurer != null) {
                return propertyConfigurer;
            }
            PropertyGenerator propertyGenerator = fixtureMonkeyOptions.getOptionalPropertyGenerator(property);
            if (propertyGenerator != null) {
                return propertyGenerator.generateChildProperties(property);
            }
            ArbitraryGenerator defaultArbitraryGenerator = fixtureMonkeyOptions.getDefaultArbitraryGenerator();
            PropertyGenerator defaultArbitraryGeneratorPropertyGenerator = defaultArbitraryGenerator.getRequiredPropertyGenerator(property);
            if (defaultArbitraryGeneratorPropertyGenerator != null) {
                return defaultArbitraryGeneratorPropertyGenerator.generateChildProperties(property);
            }
            return fixtureMonkeyOptions.getDefaultPropertyGenerator().generateChildProperties(property);
        };
        return new LazyPropertyGenerator(resolvedPropertyGenerator);
    }

    private static List<Property> resolveCandidateProperties(Property property, FixtureMonkeyOptions fixtureMonkeyOptions) {
        CandidateConcretePropertyResolver candidateConcretePropertyResolver = fixtureMonkeyOptions.getCandidateConcretePropertyResolver(property);
        if (candidateConcretePropertyResolver == null) {
            return DefaultCandidateConcretePropertyResolver.INSTANCE.resolve(property);
        }
        return (List)CANDIDATE_CONCRETE_PROPERTIES_BY_PROPERTY.computeIfAbsent((Object)property, p -> {
            ArrayList<Property> resolvedCandidateProperties = new ArrayList<Property>();
            List candidateProperties = candidateConcretePropertyResolver.resolve(p);
            for (Property candidateProperty : candidateProperties) {
                Type candidateType = candidateProperty.getType();
                if (p.getType().equals(candidateType)) {
                    resolvedCandidateProperties.addAll(DefaultCandidateConcretePropertyResolver.INSTANCE.resolve(p));
                    continue;
                }
                resolvedCandidateProperties.addAll(ObjectNode.resolveCandidateProperties(candidateProperty, fixtureMonkeyOptions));
            }
            return resolvedCandidateProperties;
        });
    }
}

