/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.tree;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.context.MonkeyContext;
import com.navercorp.fixturemonkey.api.context.MonkeyGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGenerator;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorLoggingContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.generator.CompositeArbitraryGenerator;
import com.navercorp.fixturemonkey.api.generator.IntrospectedArbitraryGenerator;
import com.navercorp.fixturemonkey.api.generator.ValidateArbitraryGenerator;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.option.FixtureMonkeyOptions;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.RootProperty;
import com.navercorp.fixturemonkey.api.type.Types;
import com.navercorp.fixturemonkey.customizer.NodeManipulator;
import com.navercorp.fixturemonkey.tree.MetadataCollector;
import com.navercorp.fixturemonkey.tree.NodeResolver;
import com.navercorp.fixturemonkey.tree.ObjectNode;
import com.navercorp.fixturemonkey.tree.ObjectTreeMetadata;
import com.navercorp.fixturemonkey.tree.TraverseContext;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class ObjectTree {
    private final RootProperty rootProperty;
    private final ObjectNode rootNode;
    private final ObjectTreeMetadata metadata;
    private final TraverseContext traverseContext;

    public ObjectTree(RootProperty rootProperty, TraverseContext traverseContext) {
        this.rootProperty = rootProperty;
        this.traverseContext = traverseContext;
        this.rootNode = ObjectNode.generateRootNode(rootProperty, traverseContext);
        MetadataCollector metadataCollector = new MetadataCollector(this.rootNode);
        this.metadata = metadataCollector.collect();
    }

    public ObjectTreeMetadata getMetadata() {
        return this.metadata;
    }

    public void manipulate(NodeResolver nodeResolver, NodeManipulator nodeManipulator) {
        List<ObjectNode> nodes = nodeResolver.resolve(this.rootNode);
        for (ObjectNode node : nodes) {
            nodeManipulator.manipulate(node);
            node.addManipulator(nodeManipulator);
        }
    }

    public CombinableArbitrary<?> generate() {
        return this.generateIntrospected(this.rootNode, null);
    }

    private ArbitraryGeneratorContext generateContext(ObjectNode objectNode, @Nullable ArbitraryGeneratorContext parentContext) {
        HashMap<ArbitraryProperty, ObjectNode> childNodesByArbitraryProperty = new HashMap<ArbitraryProperty, ObjectNode>();
        ArrayList<ArbitraryProperty> childrenProperties = new ArrayList<ArbitraryProperty>();
        ArbitraryProperty arbitraryProperty = objectNode.getArbitraryProperty();
        Property resolvedParentProperty = objectNode.getResolvedProperty();
        List children = objectNode.resolveChildren().stream().filter(it -> resolvedParentProperty.equals(it.getResolvedParentProperty())).collect(Collectors.toList());
        for (ObjectNode childNode : children) {
            childNodesByArbitraryProperty.put(childNode.getArbitraryProperty(), childNode);
            childrenProperties.add(childNode.getArbitraryProperty());
        }
        MonkeyContext monkeyContext = this.traverseContext.getMonkeyContext();
        MonkeyGeneratorContext monkeyGeneratorContext = monkeyContext.newGeneratorContext(this.rootProperty);
        FixtureMonkeyOptions fixtureMonkeyOptions = monkeyContext.getFixtureMonkeyOptions();
        ArbitraryGeneratorLoggingContext loggingContext = new ArbitraryGeneratorLoggingContext(fixtureMonkeyOptions.isEnableLoggingFail());
        return new ArbitraryGeneratorContext(resolvedParentProperty, arbitraryProperty, childrenProperties, parentContext, (currentContext, prop) -> {
            ObjectNode node = (ObjectNode)childNodesByArbitraryProperty.get(prop);
            if (node == null) {
                return CombinableArbitrary.NOT_GENERATED;
            }
            return this.generateIntrospected(node, (ArbitraryGeneratorContext)currentContext);
        }, objectNode.getLazyPropertyPath(), monkeyGeneratorContext, fixtureMonkeyOptions.getGenerateUniqueMaxTries(), objectNode.getNullInject(), loggingContext);
    }

    private CombinableArbitrary<?> generateIntrospected(ObjectNode node, @Nullable ArbitraryGeneratorContext currentContext) {
        CombinableArbitrary<?> generated;
        MonkeyContext monkeyContext = this.traverseContext.getMonkeyContext();
        Map<Class<?>, ArbitraryIntrospector> arbitraryIntrospectorConfigurer = this.traverseContext.getArbitraryIntrospectorConfigurer();
        FixtureMonkeyOptions fixtureMonkeyOptions = monkeyContext.getFixtureMonkeyOptions();
        if (node.getArbitrary() != null) {
            generated = node.getArbitrary().injectNull(node.getNullInject());
        } else {
            CombinableArbitrary cached = monkeyContext.getCachedArbitrary(node.getOriginalProperty());
            if (node.cacheable() && cached != null) {
                generated = cached;
            } else {
                ArbitraryGeneratorContext childArbitraryGeneratorContext = this.generateContext(node, currentContext);
                ArbitraryIntrospector arbitraryIntrospector = arbitraryIntrospectorConfigurer.get(Types.getActualType((Type)node.getOriginalProperty().getType()));
                generated = this.getArbitraryGenerator(arbitraryIntrospector).generate(childArbitraryGeneratorContext);
                List<Function<CombinableArbitrary<?>, CombinableArbitrary<?>>> customizers = node.getGeneratedArbitraryCustomizers();
                for (Function<CombinableArbitrary<?>, CombinableArbitrary<?>> customizer : customizers) {
                    generated = customizer.apply(generated);
                }
                if (node.cacheable()) {
                    monkeyContext.putCachedArbitrary(node.getOriginalProperty(), (CombinableArbitrary)generated);
                }
            }
        }
        List<Predicate> arbitraryFilters = node.getArbitraryFilters();
        for (Predicate predicate : arbitraryFilters) {
            generated = generated.filter(fixtureMonkeyOptions.getGenerateMaxTries(), predicate);
        }
        return generated;
    }

    private ArbitraryGenerator getArbitraryGenerator(@Nullable ArbitraryIntrospector arbitraryIntrospector) {
        FixtureMonkeyOptions fixtureMonkeyOptions = this.traverseContext.getMonkeyContext().getFixtureMonkeyOptions();
        ArbitraryGenerator arbitraryGenerator = fixtureMonkeyOptions.getDefaultArbitraryGenerator();
        boolean validOnly = this.traverseContext.isValidOnly();
        if (arbitraryIntrospector != null) {
            arbitraryGenerator = new CompositeArbitraryGenerator(Arrays.asList(new IntrospectedArbitraryGenerator(arbitraryIntrospector), arbitraryGenerator));
        }
        if (validOnly) {
            arbitraryGenerator = new CompositeArbitraryGenerator(Arrays.asList(arbitraryGenerator, new ValidateArbitraryGenerator(fixtureMonkeyOptions.getJavaConstraintGenerator(), fixtureMonkeyOptions.getDecomposedContainerValueFactory())));
        }
        return arbitraryGenerator;
    }
}

