/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.tree;

import com.navercorp.fixturemonkey.api.context.MonkeyContext;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.matcher.MatcherOperator;
import com.navercorp.fixturemonkey.api.property.MapEntryElementProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.tree.TreeProperty;
import com.navercorp.fixturemonkey.customizer.ContainerInfoManipulator;
import com.navercorp.fixturemonkey.tree.PropertyPredicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.INTERNAL)
public final class TraverseContext {
    private final List<TreeProperty> treeProperties;
    private final List<ContainerInfoManipulator> containerInfoManipulators;
    private final List<MatcherOperator<List<ContainerInfoManipulator>>> registeredContainerInfoManipulators;
    private final Map<Class<?>, List<Property>> propertyConfigurers;
    private final Map<Class<?>, ArbitraryIntrospector> arbitraryIntrospectorConfigurer;
    private final boolean validOnly;
    private final MonkeyContext monkeyContext;

    public TraverseContext(List<TreeProperty> treeProperties, List<ContainerInfoManipulator> containerInfoManipulators, List<MatcherOperator<List<ContainerInfoManipulator>>> registeredContainerInfoManipulators, Map<Class<?>, List<Property>> propertyConfigurers, Map<Class<?>, ArbitraryIntrospector> arbitraryIntrospectorConfigurer, boolean validOnly, MonkeyContext monkeyContext) {
        this.treeProperties = treeProperties;
        this.containerInfoManipulators = containerInfoManipulators;
        this.registeredContainerInfoManipulators = registeredContainerInfoManipulators;
        this.propertyConfigurers = propertyConfigurers;
        this.arbitraryIntrospectorConfigurer = arbitraryIntrospectorConfigurer;
        this.validOnly = validOnly;
        this.monkeyContext = monkeyContext;
    }

    @Nullable
    public TreeProperty getRootTreeProperty() {
        return this.treeProperties.get(0);
    }

    public List<TreeProperty> getTreeProperties() {
        return this.treeProperties;
    }

    public List<ContainerInfoManipulator> getContainerInfoManipulators() {
        return this.containerInfoManipulators;
    }

    public Map<Class<?>, List<Property>> getPropertyConfigurers() {
        return this.propertyConfigurers;
    }

    public Map<Class<?>, ArbitraryIntrospector> getArbitraryIntrospectorConfigurer() {
        return this.arbitraryIntrospectorConfigurer;
    }

    public boolean isValidOnly() {
        return this.validOnly;
    }

    public MonkeyContext getMonkeyContext() {
        return this.monkeyContext;
    }

    public TraverseContext appendArbitraryProperty(TreeProperty treeProperty) {
        ArrayList<TreeProperty> treeProperties = new ArrayList<TreeProperty>(this.treeProperties);
        treeProperties.add(treeProperty);
        List registeredContainerManipulators = this.registeredContainerInfoManipulators.stream().filter(it -> it.match(treeProperty.getObjectProperty().getProperty())).map(MatcherOperator::getOperator).findFirst().orElse(Collections.emptyList());
        List concatRegisteredContainerManipulator = registeredContainerManipulators.stream().map(it -> it.withPrependNextNodePredicate(new PropertyPredicate(treeProperty.getObjectProperty().getProperty()))).collect(Collectors.toList());
        ArrayList<ContainerInfoManipulator> concat = new ArrayList<ContainerInfoManipulator>();
        concat.addAll(concatRegisteredContainerManipulator);
        concat.addAll(this.containerInfoManipulators);
        return new TraverseContext(treeProperties, concat, this.registeredContainerInfoManipulators, this.propertyConfigurers, this.arbitraryIntrospectorConfigurer, this.validOnly, this.monkeyContext);
    }

    public boolean isTraversed(Property property) {
        return this.treeProperties.stream().skip(1L).anyMatch(it -> TraverseContext.isSameType(property, it.getObjectProperty().getProperty()));
    }

    public void addContainerInfoManipulator(ContainerInfoManipulator containerInfoManipulator) {
        if (!this.containerInfoManipulators.contains(containerInfoManipulator)) {
            this.containerInfoManipulators.add(containerInfoManipulator);
        }
    }

    @Nullable
    public TreeProperty getLastTreeProperty() {
        if (this.treeProperties.isEmpty()) {
            return null;
        }
        return this.treeProperties.get(this.treeProperties.size() - 1);
    }

    public TraverseContext withParentProperties() {
        ArrayList<TreeProperty> newTreeProperties = new ArrayList<TreeProperty>();
        if (!this.treeProperties.isEmpty()) {
            newTreeProperties.add(this.treeProperties.get(this.treeProperties.size() - 1));
        }
        return new TraverseContext(newTreeProperties, new ArrayList<ContainerInfoManipulator>(this.containerInfoManipulators), this.registeredContainerInfoManipulators, this.propertyConfigurers, this.arbitraryIntrospectorConfigurer, this.validOnly, this.monkeyContext);
    }

    private static boolean isSameType(Property p1, Property p2) {
        boolean notMapEntry = !(p1 instanceof MapEntryElementProperty) || !(p2 instanceof MapEntryElementProperty);
        return notMapEntry && p1.getAnnotatedType().getType().equals(p2.getAnnotatedType().getType());
    }
}

