/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.customizer;

import com.navercorp.fixturemonkey.tree.NextNodePredicate;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.5.0", status=API.Status.MAINTAINED)
final class InnerSpecState {
    @Nullable
    private NodeResolverObjectHolder objectHolder;
    @Nullable
    private ContainerInfoHolder containerInfoHolder;
    @Nullable
    private FilterHolder filterHolder;

    InnerSpecState() {
    }

    void setObjectHolder(@Nullable NodeResolverObjectHolder objectHolder) {
        this.objectHolder = objectHolder;
    }

    void setContainerInfoHolder(@Nullable ContainerInfoHolder containerInfoHolder) {
        this.containerInfoHolder = containerInfoHolder;
    }

    void setFilterHolder(@Nullable FilterHolder filterHolder) {
        this.filterHolder = filterHolder;
    }

    @Nullable
    NodeResolverObjectHolder getObjectHolder() {
        return this.objectHolder;
    }

    @Nullable
    ContainerInfoHolder getContainerInfoHolder() {
        return this.containerInfoHolder;
    }

    @Nullable
    FilterHolder getFilterHolder() {
        return this.filterHolder;
    }

    InnerSpecState withPrefix(List<NextNodePredicate> nextNodePredicates) {
        ArrayList<NextNodePredicate> concat;
        InnerSpecState newState = new InnerSpecState();
        if (this.objectHolder != null) {
            concat = new ArrayList<NextNodePredicate>(nextNodePredicates);
            concat.addAll(this.objectHolder.nextNodePredicates);
            newState.objectHolder = new NodeResolverObjectHolder(this.objectHolder.sequence, concat, this.objectHolder.value);
        }
        if (this.filterHolder != null) {
            concat = new ArrayList<NextNodePredicate>(nextNodePredicates);
            concat.addAll(this.filterHolder.nextNodePredicates);
            newState.filterHolder = new FilterHolder(this.filterHolder.sequence, concat, this.filterHolder.type, this.filterHolder.predicate);
        }
        if (this.containerInfoHolder != null) {
            concat = new ArrayList<NextNodePredicate>(nextNodePredicates);
            concat.addAll(this.containerInfoHolder.nextNodePredicates);
            newState.containerInfoHolder = new ContainerInfoHolder(this.containerInfoHolder.sequence, concat, this.containerInfoHolder.elementMinSize, this.containerInfoHolder.elementMaxSize);
        }
        return newState;
    }

    static final class ManipulatorHolderSet {
        private final List<NodeResolverObjectHolder> nodeResolverObjectHolders;
        private final List<ContainerInfoHolder> containerInfoManipulators;
        private final List<FilterHolder> postConditionManipulators;

        public ManipulatorHolderSet(List<NodeResolverObjectHolder> nodeResolverObjectHolders, List<ContainerInfoHolder> containerInfoManipulators, List<FilterHolder> postConditionManipulators) {
            this.nodeResolverObjectHolders = nodeResolverObjectHolders;
            this.containerInfoManipulators = containerInfoManipulators;
            this.postConditionManipulators = postConditionManipulators;
        }

        public List<NodeResolverObjectHolder> getNodeResolverObjectHolders() {
            return this.nodeResolverObjectHolders;
        }

        public List<ContainerInfoHolder> getContainerInfoManipulators() {
            return this.containerInfoManipulators;
        }

        public List<FilterHolder> getPostConditionManipulators() {
            return this.postConditionManipulators;
        }
    }

    public static class NodeResolverObjectHolder {
        private final int sequence;
        private final List<NextNodePredicate> nextNodePredicates;
        private final Object value;

        public NodeResolverObjectHolder(int sequence, List<NextNodePredicate> nextNodePredicates, Object value) {
            this.sequence = sequence;
            this.nextNodePredicates = nextNodePredicates;
            this.value = value;
        }

        List<NextNodePredicate> getNextNodePredicates() {
            return this.nextNodePredicates;
        }

        Object getValue() {
            return this.value;
        }

        int getSequence() {
            return this.sequence;
        }
    }

    public static class FilterHolder {
        private final int sequence;
        private final List<NextNodePredicate> nextNodePredicates;
        private final Class<?> type;
        private final Predicate<?> predicate;

        public FilterHolder(int sequence, List<NextNodePredicate> nextNodePredicates, Class<?> type, Predicate<?> predicate) {
            this.sequence = sequence;
            this.nextNodePredicates = nextNodePredicates;
            this.type = type;
            this.predicate = predicate;
        }

        public int getSequence() {
            return this.sequence;
        }

        List<NextNodePredicate> getNextNodePredicates() {
            return this.nextNodePredicates;
        }

        Class<?> getType() {
            return this.type;
        }

        Predicate<?> getPredicate() {
            return this.predicate;
        }
    }

    public static class ContainerInfoHolder {
        private final int sequence;
        private final List<NextNodePredicate> nextNodePredicates;
        private final int elementMinSize;
        private final int elementMaxSize;

        public ContainerInfoHolder(int sequence, List<NextNodePredicate> nextNodePredicates, int elementMinSize, int elementMaxSize) {
            this.sequence = sequence;
            this.nextNodePredicates = nextNodePredicates;
            this.elementMinSize = elementMinSize;
            this.elementMaxSize = elementMaxSize;
        }

        int getSequence() {
            return this.sequence;
        }

        List<NextNodePredicate> getNextNodePredicates() {
            return this.nextNodePredicates;
        }

        int getElementMinSize() {
            return this.elementMinSize;
        }

        int getElementMaxSize() {
            return this.elementMaxSize;
        }
    }
}

