/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.customizer;

import com.navercorp.fixturemonkey.api.ObjectBuilder;
import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.container.DecomposedContainerValueFactory;
import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.lazy.LazyArbitrary;
import com.navercorp.fixturemonkey.api.matcher.MatcherOperator;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.builder.ArbitraryBuilderContext;
import com.navercorp.fixturemonkey.builder.ArbitraryBuilderContextProvider;
import com.navercorp.fixturemonkey.builder.DefaultArbitraryBuilder;
import com.navercorp.fixturemonkey.customizer.ApplyNodeCountManipulator;
import com.navercorp.fixturemonkey.customizer.ArbitraryManipulator;
import com.navercorp.fixturemonkey.customizer.ContainerInfoManipulator;
import com.navercorp.fixturemonkey.customizer.InnerSpecState;
import com.navercorp.fixturemonkey.customizer.ManipulatorSet;
import com.navercorp.fixturemonkey.customizer.NodeCustomizerManipulator;
import com.navercorp.fixturemonkey.customizer.NodeFilterManipulator;
import com.navercorp.fixturemonkey.customizer.NodeManipulator;
import com.navercorp.fixturemonkey.customizer.NodeNullityManipulator;
import com.navercorp.fixturemonkey.customizer.NodeSetDecomposedValueManipulator;
import com.navercorp.fixturemonkey.customizer.NodeSetJustManipulator;
import com.navercorp.fixturemonkey.customizer.NodeSetLazyManipulator;
import com.navercorp.fixturemonkey.customizer.Values;
import com.navercorp.fixturemonkey.expression.MonkeyExpressionFactory;
import com.navercorp.fixturemonkey.tree.CompositeNodeResolver;
import com.navercorp.fixturemonkey.tree.NodePredicateResolver;
import com.navercorp.fixturemonkey.tree.NodeResolver;
import com.navercorp.fixturemonkey.tree.ObjectNode;
import com.navercorp.fixturemonkey.tree.StaticNodeResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.jqwik.api.Arbitrary;
import org.apiguardian.api.API;

@API(since="0.4.10", status=API.Status.MAINTAINED)
public final class MonkeyManipulatorFactory {
    private final AtomicInteger sequence;
    private final MonkeyExpressionFactory monkeyExpressionFactory;
    private final DecomposedContainerValueFactory decomposedContainerValueFactory;

    public MonkeyManipulatorFactory(AtomicInteger sequence, MonkeyExpressionFactory monkeyExpressionFactory, DecomposedContainerValueFactory decomposedContainerValueFactory) {
        this.sequence = sequence;
        this.monkeyExpressionFactory = monkeyExpressionFactory;
        this.decomposedContainerValueFactory = decomposedContainerValueFactory;
    }

    public ArbitraryManipulator newArbitraryManipulator(String expression, @Nullable Object value, int limit) {
        return new ArbitraryManipulator(this.monkeyExpressionFactory.from(expression).toNodeResolver(), this.convertToNodeManipulator(value, limit));
    }

    public ArbitraryManipulator newArbitraryManipulator(String expression, @Nullable Object value) {
        return new ArbitraryManipulator(this.monkeyExpressionFactory.from(expression).toNodeResolver(), this.convertToNodeManipulator(this.sequence.getAndIncrement(), value));
    }

    public <T> ArbitraryManipulator newArbitraryManipulator(String expression, Class<T> type, Predicate<T> filter, int limit) {
        return new ArbitraryManipulator(this.monkeyExpressionFactory.from(expression).toNodeResolver(), new ApplyNodeCountManipulator(new NodeFilterManipulator(type, filter), limit));
    }

    public <T> ArbitraryManipulator newArbitraryManipulator(String expression, Function<CombinableArbitrary<? extends T>, CombinableArbitrary<? extends T>> arbitraryCustomizer) {
        if (arbitraryCustomizer == null) {
            return this.newArbitraryManipulator(expression, (Object)null);
        }
        return new ArbitraryManipulator(this.monkeyExpressionFactory.from(expression).toNodeResolver(), new NodeCustomizerManipulator<T>(arbitraryCustomizer));
    }

    public ContainerInfoManipulator newContainerInfoManipulator(String expression, int min, int max) {
        int newSequence = this.sequence.getAndIncrement();
        return new ContainerInfoManipulator(this.monkeyExpressionFactory.from(expression).toNextNodePredicate(), new ArbitraryContainerInfo(min, max), newSequence);
    }

    public List<ArbitraryManipulator> newRegisteredArbitraryManipulators(List<MatcherOperator<? extends ObjectBuilder<?>>> registeredArbitraryBuilders, Map<Property, List<ObjectNode>> nodesByType) {
        ArrayList<ArbitraryManipulator> manipulators = new ArrayList<ArbitraryManipulator>();
        for (Map.Entry<Property, List<ObjectNode>> nodeByType : nodesByType.entrySet()) {
            Property property = nodeByType.getKey();
            List<ObjectNode> objectNodes = nodeByType.getValue();
            ArbitraryBuilderContextProvider registeredArbitraryBuilder = registeredArbitraryBuilders.stream().filter(it -> it.match(property)).findFirst().map(MatcherOperator::getOperator).map(ArbitraryBuilderContextProvider.class::cast).orElse(null);
            if (registeredArbitraryBuilder == null) continue;
            ArbitraryBuilderContext context = registeredArbitraryBuilder.getContext();
            List arbitraryManipulators = context.getManipulators().stream().map(it -> new ArbitraryManipulator(new CompositeNodeResolver(new StaticNodeResolver(objectNodes), it.getNodeResolver()), it.getNodeManipulator())).collect(Collectors.toList());
            manipulators.addAll(arbitraryManipulators);
        }
        return manipulators;
    }

    public ManipulatorSet newManipulatorSet(InnerSpecState.ManipulatorHolderSet manipulatorHolderSet) {
        int baseSequence = this.sequence.getAndIncrement();
        ArrayList<ArbitraryManipulator> arbitraryManipulators = new ArrayList<ArbitraryManipulator>();
        List setArbitraryManipulators = manipulatorHolderSet.getNodeResolverObjectHolders().stream().map(it -> {
            List<NodeResolver> nextNodeResolvers = it.getNextNodePredicates().stream().map(NodePredicateResolver::new).collect(Collectors.toList());
            CompositeNodeResolver compositeNodeResolver = new CompositeNodeResolver(nextNodeResolvers);
            return new ArbitraryManipulator(compositeNodeResolver, this.convertToNodeManipulator(baseSequence + it.getSequence(), it.getValue()));
        }).collect(Collectors.toList());
        List filterArbitraryManipulators = manipulatorHolderSet.getPostConditionManipulators().stream().map(it -> {
            List<NodeResolver> nextNodeResolvers = it.getNextNodePredicates().stream().map(NodePredicateResolver::new).collect(Collectors.toList());
            CompositeNodeResolver compositeNodeResolver = new CompositeNodeResolver(nextNodeResolvers);
            return new ArbitraryManipulator(compositeNodeResolver, new NodeFilterManipulator(it.getType(), it.getPredicate()));
        }).collect(Collectors.toList());
        arbitraryManipulators.addAll(setArbitraryManipulators);
        arbitraryManipulators.addAll(filterArbitraryManipulators);
        List<ContainerInfoManipulator> containerInfoManipulators = manipulatorHolderSet.getContainerInfoManipulators().stream().map(it -> new ContainerInfoManipulator(it.getNextNodePredicates(), new ArbitraryContainerInfo(it.getElementMinSize(), it.getElementMaxSize()), baseSequence + it.getSequence())).collect(Collectors.toList());
        this.sequence.set(this.sequence.get() + containerInfoManipulators.size() + arbitraryManipulators.size());
        return new ManipulatorSet(arbitraryManipulators, containerInfoManipulators);
    }

    public MonkeyManipulatorFactory copy() {
        return new MonkeyManipulatorFactory(new AtomicInteger(this.sequence.get()), this.monkeyExpressionFactory, this.decomposedContainerValueFactory);
    }

    private NodeManipulator convertToNodeManipulator(@Nullable Object value, int limit) {
        NodeManipulator nodeManipulator = this.convertToNodeManipulator(this.sequence.getAndIncrement(), value);
        return new ApplyNodeCountManipulator(nodeManipulator, limit);
    }

    private NodeManipulator convertToNodeManipulator(int sequence, @Nullable Object value) {
        if (value == null) {
            return new NodeNullityManipulator(true);
        }
        if (value == Values.NOT_NULL) {
            return new NodeNullityManipulator(false);
        }
        if (value instanceof Values.Just) {
            return new NodeSetJustManipulator((Values.Just)value);
        }
        if (value instanceof Arbitrary) {
            return new NodeSetLazyManipulator(sequence, this.decomposedContainerValueFactory, LazyArbitrary.lazy(() -> ((Arbitrary)value).sample()));
        }
        if (value instanceof DefaultArbitraryBuilder) {
            return new NodeSetLazyManipulator(sequence, this.decomposedContainerValueFactory, LazyArbitrary.lazy(() -> ((DefaultArbitraryBuilder)value).sample()));
        }
        if (value instanceof Supplier) {
            return new NodeSetLazyManipulator(sequence, this.decomposedContainerValueFactory, LazyArbitrary.lazy((Supplier)((Supplier)value)));
        }
        if (value instanceof LazyArbitrary) {
            return new NodeSetLazyManipulator(sequence, this.decomposedContainerValueFactory, (LazyArbitrary)value);
        }
        if (value instanceof Values.Unique) {
            return new NodeSetJustManipulator(Values.just(CombinableArbitrary.from(((Values.Unique)value).getValueSupplier()).unique()));
        }
        return new NodeSetDecomposedValueManipulator<Object>(sequence, this.decomposedContainerValueFactory, value);
    }
}

