/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.customizer;

import com.navercorp.fixturemonkey.api.type.Types;
import com.navercorp.fixturemonkey.customizer.NodeManipulator;
import com.navercorp.fixturemonkey.tree.ObjectNode;
import java.lang.reflect.Type;
import java.util.function.Predicate;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class NodeFilterManipulator
implements NodeManipulator {
    private final Class<?> type;
    private final Predicate filter;

    public NodeFilterManipulator(Class<?> type, Predicate filter) {
        this.type = type;
        this.filter = filter;
    }

    @Override
    public void manipulate(ObjectNode objectNode) {
        Class actualType = Types.getActualType((Type)objectNode.getOriginalProperty().getType());
        if (!Types.isAssignable((Class)actualType, this.type)) {
            throw new IllegalArgumentException("Wrong type filter is applied. Expected: " + this.type + ", Actual: " + actualType);
        }
        objectNode.getObjectNodeContext().addArbitraryFilter(this.filter);
    }
}

