/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.expression;

import com.navercorp.fixturemonkey.expression.MonkeyExpression;
import com.navercorp.fixturemonkey.tree.CompositeNodeResolver;
import com.navercorp.fixturemonkey.tree.ContainerElementPredicate;
import com.navercorp.fixturemonkey.tree.NextNodePredicate;
import com.navercorp.fixturemonkey.tree.NodePredicateResolver;
import com.navercorp.fixturemonkey.tree.NodeResolver;
import com.navercorp.fixturemonkey.tree.PropertyNameNodePredicate;
import com.navercorp.fixturemonkey.tree.StartNodePredicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apiguardian.api.API;

public final class ArbitraryExpression
implements MonkeyExpression,
Comparable<ArbitraryExpression> {
    private final List<Exp> expList;

    private ArbitraryExpression(List<Exp> expList) {
        this.expList = expList;
    }

    private ArbitraryExpression(String expression) {
        this.expList = Arrays.stream(expression.split("\\.")).map(Exp::new).collect(Collectors.toList());
    }

    public static ArbitraryExpression from(String expression) {
        return new ArbitraryExpression(expression);
    }

    public ArbitraryExpression addFirst(String expression) {
        String newStringExpression = expression + "." + this;
        return new ArbitraryExpression(newStringExpression);
    }

    public ArbitraryExpression addLast(String expression) {
        String newStringExpression = this + "." + expression;
        return new ArbitraryExpression(newStringExpression);
    }

    @API(since="0.4.0", status=API.Status.MAINTAINED)
    public ArbitraryExpression pollLast() {
        if (this.expList.isEmpty()) {
            return this;
        }
        ArrayList<Exp> newExpList = new ArrayList<Exp>(this.expList);
        int lastIndex = newExpList.size() - 1;
        Exp lastExp = (Exp)newExpList.get(lastIndex);
        newExpList.remove(lastIndex);
        if (!lastExp.indices.isEmpty()) {
            ArrayList newExpIndexList = new ArrayList(lastExp.indices);
            newExpIndexList.remove(newExpIndexList.size() - 1);
            lastExp = new Exp(lastExp.name, newExpIndexList);
            newExpList.add(lastExp);
        }
        return new ArbitraryExpression(newExpList);
    }

    @Override
    public int compareTo(ArbitraryExpression arbitraryExpression) {
        List<Exp> oExpList = arbitraryExpression.expList;
        if (this.expList.size() != oExpList.size()) {
            return Integer.compare(this.expList.size(), oExpList.size());
        }
        for (int i = 0; i < this.expList.size(); ++i) {
            Exp oExp;
            Exp exp = this.expList.get(i);
            int expCompare = exp.compareTo(oExp = oExpList.get(i));
            if (expCompare == 0) continue;
            return expCompare;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ArbitraryExpression other = (ArbitraryExpression)obj;
        return this.expList.equals(other.expList);
    }

    public int hashCode() {
        return Objects.hash(this.expList);
    }

    public String toString() {
        return this.expList.stream().map(Exp::toString).collect(Collectors.joining("."));
    }

    @Override
    public NodeResolver toNodeResolver() {
        NodeResolver nodeResolver = null;
        for (Exp exp : this.expList) {
            if (nodeResolver == null) {
                nodeResolver = exp.toNodeResolver();
                continue;
            }
            nodeResolver = new CompositeNodeResolver(nodeResolver, exp.toNodeResolver());
        }
        return nodeResolver;
    }

    @Override
    public List<NextNodePredicate> toNextNodePredicate() {
        ArrayList<NextNodePredicate> nextNodePredicates = new ArrayList<NextNodePredicate>();
        nextNodePredicates.add(StartNodePredicate.INSTANCE);
        for (Exp exp : this.expList) {
            nextNodePredicates.addAll(exp.toNextNodePredicates());
        }
        return nextNodePredicates;
    }

    private static final class Exp
    implements Comparable<Exp> {
        private final String name;
        private final List<ExpIndex> indices;

        private Exp(String name, List<ExpIndex> indices) {
            this.name = name;
            this.indices = indices;
        }

        public Exp(String expression) {
            this.indices = new ArrayList<ExpIndex>();
            int li = expression.indexOf(91);
            int ri = expression.indexOf(93);
            if (li != -1 && ri == -1 || li == -1 && ri != -1) {
                throw new IllegalArgumentException("expression is invalid. expression : " + expression);
            }
            if (li == -1) {
                this.name = expression;
            } else {
                this.name = expression.substring(0, li);
                while (li != -1 && ri != -1) {
                    if (ri - li > 1) {
                        String indexString = expression.substring(li + 1, ri);
                        int indexValue = indexString.equals("*") ? Integer.MAX_VALUE : Integer.parseInt(indexString);
                        this.indices.add(new ExpIndex(indexValue));
                    }
                    expression = expression.substring(ri + 1);
                    li = expression.indexOf(91);
                    ri = expression.indexOf(93);
                }
            }
        }

        public NodeResolver toNodeResolver() {
            NodeResolver nodeResolver = new NodePredicateResolver(StartNodePredicate.INSTANCE);
            if (!"$".equals(this.name)) {
                nodeResolver = new CompositeNodeResolver(nodeResolver, new NodePredicateResolver(new PropertyNameNodePredicate(this.name)));
            }
            for (ExpIndex index : this.indices) {
                nodeResolver = new CompositeNodeResolver(nodeResolver, new NodePredicateResolver(new ContainerElementPredicate(index.getIndex())));
            }
            return nodeResolver;
        }

        public List<NextNodePredicate> toNextNodePredicates() {
            ArrayList<NextNodePredicate> nextNodePredicates = new ArrayList<NextNodePredicate>();
            if (!"$".equals(this.name)) {
                nextNodePredicates.add(new PropertyNameNodePredicate(this.name));
            }
            for (ExpIndex index : this.indices) {
                nextNodePredicates.add(new ContainerElementPredicate(index.getIndex()));
            }
            return nextNodePredicates;
        }

        public String getName() {
            return this.name;
        }

        public List<ExpIndex> getIndices() {
            return this.indices;
        }

        public String toString() {
            String indexBrackets = this.indices.stream().map(i -> "[" + i.toString() + "]").collect(Collectors.joining());
            return this.name + indexBrackets;
        }

        @Override
        public int compareTo(Exp exp) {
            List<ExpIndex> indices = this.getIndices();
            List<ExpIndex> oIndices = exp.getIndices();
            if (exp.name.equals(this.name)) {
                int indexLength = Math.min(oIndices.size(), indices.size());
                for (int i = 0; i < indexLength; ++i) {
                    ExpIndex index = indices.get(i);
                    ExpIndex oIndex = oIndices.get(i);
                    int indexCompare = oIndex.compareTo(index);
                    if (indexCompare == 0) continue;
                    return indexCompare;
                }
            }
            return Integer.compare(indices.size(), oIndices.size());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Exp exp = (Exp)obj;
            return this.name.equals(exp.name) && this.indices.equals(exp.indices);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.indices);
        }
    }

    private static final class ExpIndex
    implements Comparable<ExpIndex> {
        public static final ExpIndex ALL_INDEX_EXP_INDEX = new ExpIndex(Integer.MAX_VALUE);
        private final int index;

        public ExpIndex(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean equalsIgnoreAllIndex(ExpIndex expIndex) {
            return this.index == expIndex.index;
        }

        @Override
        public int compareTo(ExpIndex expIndex) {
            return Integer.compare(this.index, expIndex.index);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ExpIndex expIndex = (ExpIndex)obj;
            return this.index == expIndex.index || this.index == Integer.MAX_VALUE || expIndex.index == Integer.MAX_VALUE;
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return this.index == Integer.MAX_VALUE ? "*" : String.valueOf(this.index);
        }
    }
}

