/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.resolver;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.context.MonkeyContext;
import com.navercorp.fixturemonkey.api.matcher.DefaultTreeMatcherMetadata;
import com.navercorp.fixturemonkey.api.matcher.TreeMatcherMetadata;
import com.navercorp.fixturemonkey.api.matcher.TreeMatcherOperator;
import com.navercorp.fixturemonkey.api.option.FixtureMonkeyOptions;
import com.navercorp.fixturemonkey.api.property.RootProperty;
import com.navercorp.fixturemonkey.builder.ArbitraryBuilderContext;
import com.navercorp.fixturemonkey.customizer.ArbitraryManipulator;
import com.navercorp.fixturemonkey.customizer.MonkeyManipulatorFactory;
import com.navercorp.fixturemonkey.resolver.ManipulatorOptimizer;
import com.navercorp.fixturemonkey.resolver.ResolvedCombinableArbitrary;
import com.navercorp.fixturemonkey.tree.ObjectTree;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class ArbitraryResolver {
    private final ManipulatorOptimizer manipulatorOptimizer;
    private final MonkeyManipulatorFactory monkeyManipulatorFactory;
    private final MonkeyContext monkeyContext;

    public ArbitraryResolver(ManipulatorOptimizer manipulatorOptimizer, MonkeyManipulatorFactory monkeyManipulatorFactory, MonkeyContext monkeyContext) {
        this.manipulatorOptimizer = manipulatorOptimizer;
        this.monkeyManipulatorFactory = monkeyManipulatorFactory;
        this.monkeyContext = monkeyContext;
    }

    public CombinableArbitrary<?> resolve(RootProperty rootProperty, ArbitraryBuilderContext builderContext) {
        FixtureMonkeyOptions fixtureMonkeyOptions = this.monkeyContext.getFixtureMonkeyOptions();
        List<ArbitraryManipulator> manipulators = builderContext.getManipulators();
        return new ResolvedCombinableArbitrary(rootProperty, () -> {
            ObjectTree objectTree = new ObjectTree(rootProperty, builderContext.newGenerateFixtureContext(), builderContext.newTraverseContext());
            fixtureMonkeyOptions.getBuilderContextInitializers().stream().filter(it -> it.match((TreeMatcherMetadata)new DefaultTreeMatcherMetadata(objectTree.getMetadata().getAnnotations()))).findFirst().map(TreeMatcherOperator::getOperator).ifPresent(it -> builderContext.setOptionValidOnly(it.isValidOnly()));
            return objectTree;
        }, objectTree -> {
            List<ArbitraryManipulator> registeredManipulators = this.monkeyManipulatorFactory.newRegisteredArbitraryManipulators(this.monkeyContext.getRegisteredArbitraryBuilders(), objectTree.getMetadata().getNodesByProperty());
            List<ArbitraryManipulator> joinedManipulators = Stream.concat(registeredManipulators.stream(), manipulators.stream()).collect(Collectors.toList());
            List<ArbitraryManipulator> optimizedManipulator = this.manipulatorOptimizer.optimize(joinedManipulators).getManipulators();
            for (ArbitraryManipulator manipulator : optimizedManipulator) {
                manipulator.manipulate((ObjectTree)objectTree);
            }
            return objectTree.generate();
        }, fixtureMonkeyOptions.getGenerateMaxTries(), fixtureMonkeyOptions.getDefaultArbitraryValidator(), builderContext::isValidOnly);
    }
}

