/*
 * Decompiled with CFR 0.152.
 */
package com.nhncorp.lucy.security.xss.config;

import com.nhncorp.lucy.security.xss.config.AttributeRule;
import com.nhncorp.lucy.security.xss.config.ElementRule;
import com.nhncorp.lucy.security.xss.event.AttributeListener;
import com.nhncorp.lucy.security.xss.event.ElementListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class XssSaxConfiguration {
    private static final String DEFAULT_CONFIG = "/lucy-xss-default-sax.xml";
    private Map<String, ElementRule> tags = new HashMap<String, ElementRule>();
    private Map<String, AttributeRule> atts = new HashMap<String, AttributeRule>();
    private String service = "UnknownService";
    private boolean blockingPrefixEnabled;
    private String blockingPrefix = "diabled_";
    private boolean filteringTagInCommentEnabled = true;
    private String filteringTagInCommentType = "strict";

    private XssSaxConfiguration() {
    }

    public static XssSaxConfiguration newInstance(String file) throws Exception {
        XssSaxConfiguration config = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            config = XssSaxConfiguration.create(builder, file);
            if (config == null) {
                throw new Exception(String.format("The XSS configuration file [%s] is not a expected xml document.", file));
            }
        }
        catch (Exception ex) {
            throw new Exception(String.format("Cannot parse the XSS configuration file [%s].", file), ex);
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static XssSaxConfiguration create(DocumentBuilder builder, String file) throws SAXException, IOException {
        XssSaxConfiguration config = null;
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(file);
        if (is == null) {
            is = XssSaxConfiguration.class.getResourceAsStream(DEFAULT_CONFIG);
        }
        try {
            int i;
            Element root = builder.parse(is).getDocumentElement();
            String extend = root.getAttribute("extends");
            if (extend != null && !"".equals(extend)) {
                config = XssSaxConfiguration.create(builder, extend);
            }
            if (config == null) {
                config = new XssSaxConfiguration();
            }
            NodeList list = root.getElementsByTagName("element");
            for (i = 0; list.getLength() > 0 && i < list.getLength(); ++i) {
                config.addElementRule((Element)Element.class.cast(list.item(i)));
            }
            list = root.getElementsByTagName("attribute");
            for (i = 0; list.getLength() > 0 && i < list.getLength(); ++i) {
                config.addAttributeRule((Element)Element.class.cast(list.item(i)));
            }
            list = root.getElementsByTagName("blockingPrefix");
            for (i = 0; list.getLength() > 0 && i < list.getLength(); ++i) {
                config.enableBlockingPrefix((Element)Element.class.cast(list.item(i)));
            }
            list = root.getElementsByTagName("filteringTagInComment");
            for (i = 0; list.getLength() > 0 && i < list.getLength(); ++i) {
                config.enableFilteringTagInComment((Element)Element.class.cast(list.item(i)));
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {}
            }
        }
        return config;
    }

    private void enableBlockingPrefix(Element element) {
        String enable = element.getAttribute("enable");
        String prefix = element.getAttribute("prefix");
        if (enable != null && ("true".equalsIgnoreCase(enable) || "false".equalsIgnoreCase(enable))) {
            this.setBlockingPrefixEnabled("true".equalsIgnoreCase(enable));
        }
        if (prefix != null && !prefix.isEmpty()) {
            this.setBlockingPrefix(prefix);
        }
    }

    public ElementRule getElementRule(String tagName) {
        ElementRule rule = null;
        if (tagName != null && this.tags != null && !this.tags.isEmpty()) {
            rule = this.tags.get(tagName.toLowerCase());
        }
        return rule;
    }

    public AttributeRule getAttributeRule(String attName) {
        AttributeRule rule = null;
        if (attName != null && this.atts != null && !this.atts.isEmpty()) {
            rule = this.atts.get(attName.toLowerCase());
        }
        return rule;
    }

    private void addElementRule(Element element) {
        String name = element.getAttribute("name");
        boolean override = !"false".equalsIgnoreCase(element.getAttribute("override"));
        String disable = element.getAttribute("disable");
        String removeTag = element.getAttribute("removeTag");
        if (name == null || "".equals(name)) {
            return;
        }
        ElementRule rule = null;
        if (override) {
            rule = this.tags.get(name);
        }
        if (rule == null || !override) {
            rule = new ElementRule(name);
            this.tags.put(name.toLowerCase(), rule);
        }
        if (removeTag != null && ("true".equalsIgnoreCase(removeTag) || "false".equalsIgnoreCase(removeTag))) {
            rule.setRemoveTag("true".equalsIgnoreCase(removeTag));
        }
        if (disable != null && ("true".equalsIgnoreCase(disable) || "false".equalsIgnoreCase(disable))) {
            rule.setDisabled("true".equalsIgnoreCase(disable));
        }
        NodeList list = element.getElementsByTagName("attributes");
        list = element.getElementsByTagName("listener");
        for (int i = 0; list.getLength() > 0 && i < list.getLength(); ++i) {
            String className = list.item(i).getTextContent();
            if (className == null) continue;
            try {
                Object obj = Class.forName(className.trim()).newInstance();
                rule.addListener((ElementListener)ElementListener.class.cast(obj));
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    private void addAttributeRule(Element element) {
        int i;
        String[] tokens;
        String name = element.getAttribute("name");
        boolean override = !"false".equalsIgnoreCase(element.getAttribute("override"));
        String disable = element.getAttribute("disable");
        String base64Decoding = element.getAttribute("base64Decoding");
        String exceptionTagList = element.getAttribute("exceptionTagList");
        if (name == null || "".equals(name)) {
            return;
        }
        AttributeRule rule = null;
        if (override) {
            rule = this.atts.get(name);
        }
        if (rule == null || !override) {
            rule = new AttributeRule(name);
            this.atts.put(name.toLowerCase(), rule);
        }
        if (disable != null && ("true".equalsIgnoreCase(disable) || "false".equalsIgnoreCase(disable))) {
            rule.setDisabled("true".equalsIgnoreCase(disable));
        }
        if (exceptionTagList != null && exceptionTagList.length() > 0 && (tokens = exceptionTagList.split(",")) != null) {
            for (i = 0; i < tokens.length; ++i) {
                if (tokens[i] == null) continue;
                String exceptionTag = tokens[i].trim();
                rule.addExceptionTag(exceptionTag);
            }
        }
        if (base64Decoding != null && ("true".equalsIgnoreCase(base64Decoding) || "false".equalsIgnoreCase(base64Decoding))) {
            rule.setBase64Decoding("true".equalsIgnoreCase(base64Decoding));
        }
        NodeList list = element.getElementsByTagName("allowedPattern");
        for (i = 0; list.getLength() > 0 && i < list.getLength(); ++i) {
            rule.addAllowedPattern(list.item(i).getTextContent());
        }
        list = element.getElementsByTagName("notAllowedPattern");
        for (i = 0; list.getLength() > 0 && i < list.getLength(); ++i) {
            rule.addNotAllowedPattern(list.item(i).getTextContent());
        }
        list = element.getElementsByTagName("listener");
        for (i = 0; list.getLength() > 0 && i < list.getLength(); ++i) {
            String className = list.item(i).getTextContent();
            if (className == null) continue;
            try {
                Object obj = Class.forName(className.trim()).newInstance();
                rule.addListener((AttributeListener)AttributeListener.class.cast(obj));
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getService() {
        return this.service;
    }

    public void setBlockingPrefixEnabled(boolean isEnableBlockingPrefix) {
        this.blockingPrefixEnabled = isEnableBlockingPrefix;
    }

    public boolean isEnableBlockingPrefix() {
        return this.blockingPrefixEnabled;
    }

    public void setBlockingPrefix(String blockingPrefix) {
        this.blockingPrefix = blockingPrefix;
    }

    public String getBlockingPrefix() {
        return this.blockingPrefix;
    }

    private void enableFilteringTagInComment(Element element) {
        String enable = element.getAttribute("enable");
        String type = element.getAttribute("type");
        if (enable != null && ("true".equalsIgnoreCase(enable) || "false".equalsIgnoreCase(enable))) {
            this.setFilteringTagInCommentEnabled("true".equalsIgnoreCase(enable));
        }
        if (type != null && !type.isEmpty()) {
            this.setFilteringTagInCommentType(type);
        }
    }

    private void setFilteringTagInCommentType(String type) {
        this.filteringTagInCommentType = type;
    }

    private void setFilteringTagInCommentEnabled(boolean enabled) {
        this.filteringTagInCommentEnabled = enabled;
    }

    public boolean isFilteringTagInCommentEnabled() {
        return this.filteringTagInCommentEnabled;
    }

    public boolean isNoTagAllowedInComment() {
        return "strict".endsWith(this.filteringTagInCommentType);
    }
}

