/*
 * Decompiled with CFR 0.152.
 */
package com.nhncorp.lucy.security.xss.listener;

import com.nhncorp.lucy.security.xss.event.ElementListener;
import com.nhncorp.lucy.security.xss.listener.SecurityUtils;
import com.nhncorp.lucy.security.xss.listener.WhiteUrlList;
import com.nhncorp.lucy.security.xss.markup.Element;

public class EmbedListener
implements ElementListener {
    public void handleElement(Element element) {
        boolean isWhiteUrl;
        if (element.isDisabled()) {
            return;
        }
        String srcUrl = element.getAttributeValue("src");
        boolean isVulnerable = SecurityUtils.checkVulnerable(element, srcUrl, isWhiteUrl = this.isWhiteUrl(srcUrl));
        if (isVulnerable) {
            element.setEnabled(false);
            return;
        }
        element.putAttribute("invokeURLs", "\"false\"");
        element.putAttribute("autostart", "\"false\"");
        element.putAttribute("allowScriptAccess", "\"never\"");
        if (isWhiteUrl) {
            element.putAttribute("allowNetworking", "\"all\"");
        } else {
            element.putAttribute("allowNetworking", "\"internal\"");
        }
    }

    private boolean isWhiteUrl(String url) {
        WhiteUrlList list = WhiteUrlList.getInstance();
        return list != null && list.contains(url);
    }
}

