/*
 * Decompiled with CFR 0.152.
 */
package com.nhncorp.lucy.security.xss.listener;

import com.nhncorp.lucy.security.xss.config.XssConfiguration;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class WhiteUrlList {
    private static final String CONFIG = "/white-url.xml";
    public static volatile WhiteUrlList instance;
    private List<Pattern> patterns = new ArrayList<Pattern>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WhiteUrlList() {
        URL url = XssConfiguration.class.getResource(CONFIG);
        FileInputStream is = null;
        try {
            is = new FileInputStream(url.getFile());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Element root = builder.parse(is).getDocumentElement();
            NodeList list = root.getElementsByTagName("pattern");
            if (list != null && list.getLength() > 0) {
                for (int i = 0; i < list.getLength(); ++i) {
                    String value = list.item(i).getTextContent();
                    if (value == null) continue;
                    this.patterns.add(WhiteUrlList.buildPattern(value.trim()));
                }
            }
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WhiteUrlList getInstance() {
        Class<WhiteUrlList> clazz = WhiteUrlList.class;
        synchronized (WhiteUrlList.class) {
            if (instance == null) {
                instance = new WhiteUrlList();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static WhiteUrlList reload() throws Exception {
        instance = null;
        return WhiteUrlList.getInstance();
    }

    public boolean contains(String url) {
        if (url == null || "".equals(url)) {
            return false;
        }
        if (this.patterns != null) {
            for (Pattern pattern : this.patterns) {
                if (!pattern.matcher(url).matches()) continue;
                return true;
            }
        }
        return false;
    }

    private static Pattern buildPattern(String raw) {
        StringWriter writer = new StringWriter();
        writer.write("['\"]?\\s*(?i:");
        int pos = 0;
        int length = raw.length();
        for (int i = 0; i < raw.length(); ++i) {
            char c = raw.charAt(i);
            switch (c) {
                case '$': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '}': {
                    if (i > pos) {
                        writer.write(raw, pos, i - pos);
                    }
                    if (c == '*') {
                        writer.write(".*");
                    } else {
                        writer.write("\\");
                        writer.write(c);
                    }
                    pos = i + 1;
                }
            }
        }
        if (length > pos) {
            writer.write(raw, pos, length - pos);
        }
        writer.write(")\\s*['\"]?");
        return Pattern.compile(writer.toString());
    }
}

