/*
 * Decompiled with CFR 0.152.
 */
package com.nhncorp.lucy.security.xss.markup;

import com.nhncorp.lucy.security.xss.CommonUtils;
import com.nhncorp.lucy.security.xss.markup.Attribute;
import com.nhncorp.lucy.security.xss.markup.Comment;
import com.nhncorp.lucy.security.xss.markup.Content;
import com.nhncorp.lucy.security.xss.markup.Description;
import com.nhncorp.lucy.security.xss.markup.Element;
import com.nhncorp.lucy.security.xss.markup.IEHackExtensionElement;
import com.nhncorp.lucy.security.xss.markup.Text;
import com.nhncorp.lucy.security.xss.markup.rule.CharArraySegment;
import com.nhncorp.lucy.security.xss.markup.rule.ParsingGrammar;
import com.nhncorp.lucy.security.xss.markup.rule.Token;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MarkupParser {
    private static ParsingGrammar grammar = ParsingGrammar.getInstance();

    private MarkupParser() {
    }

    public static Collection<Content> parse(String input) {
        Token token;
        if (input == null || input.length() == 0) {
            return null;
        }
        LinkedList<Content> result = new LinkedList<Content>();
        LinkedList<Element> stack = null;
        CharArraySegment charArraySegment = new CharArraySegment(input);
        while ((token = grammar.nextToken(charArraySegment)) != null) {
            String tokenName = token.getName();
            if ("description".equals(tokenName)) {
                String description = token.getText();
                result.add(new Description(description));
                continue;
            }
            if ("comment".equals(tokenName)) {
                String comment = token.getText();
                if (comment != null && comment.length() != 0) {
                    comment = comment.substring(4, comment.length() - 3);
                }
                result.add(new Comment(comment));
                continue;
            }
            if ("iEHExStartTag".endsWith(tokenName)) {
                IEHackExtensionElement element = new IEHackExtensionElement(token.getText());
                if (stack == null) {
                    stack = new LinkedList<Element>();
                }
                stack.addFirst(element);
                result.add(element);
                continue;
            }
            if ("startTag".equals(tokenName)) {
                Token closeStartEnd;
                Token tagNameToken = token.getChild("tagName");
                if (tagNameToken == null) continue;
                Element element = new Element(tagNameToken.getText());
                List<Token> attTokens = token.getChildren("attribute");
                if (attTokens != null) {
                    for (Token attToken : attTokens) {
                        Token attName = attToken.getChild("attName");
                        Token attValue = attToken.getChild("attValue");
                        if (attName != null && attValue == null) {
                            element.putAttribute(new Attribute(attName.getText()));
                            continue;
                        }
                        if (attName == null || attValue == null) continue;
                        String text = attValue.getText();
                        text = CommonUtils.getQuotePair(text);
                        element.putAttribute(new Attribute(attName.getText(), text));
                    }
                }
                if ((closeStartEnd = token.getChild("closeStartEnd")) == null) {
                    if (stack == null) {
                        stack = new LinkedList();
                    }
                    stack.addFirst(element);
                } else {
                    element.setStartClose(true);
                }
                result.add(element);
                continue;
            }
            if ("iEHExEndTag".endsWith(tokenName)) {
                boolean flag = false;
                if (stack != null) {
                    Element element;
                    LinkedList<Element> tmp = new LinkedList<Element>();
                    while (!stack.isEmpty() && (element = (Element)stack.removeFirst()) != null) {
                        if (element instanceof IEHackExtensionElement) {
                            Content content;
                            while (!result.isEmpty() && (content = result.getLast()) != null) {
                                if (content instanceof Element && content == element) {
                                    element.setClose(true);
                                    tmp.clear();
                                    break;
                                }
                                if (stack.contains(content)) {
                                    stack.remove(content);
                                }
                                element.addContent(0, result.removeLast());
                            }
                            flag = true;
                            break;
                        }
                        tmp.add(element);
                    }
                    if (tmp != null && !tmp.isEmpty()) {
                        stack = tmp;
                    }
                }
                if (flag) continue;
                result.add(new Text(token.getText()));
                continue;
            }
            if ("endTag".equals(tokenName)) {
                Token tagNameToken = token.getChild("tagName");
                boolean flag = false;
                if (tagNameToken == null) continue;
                String tagName = tagNameToken.getText();
                if (stack != null) {
                    Element element;
                    LinkedList<Element> tmp = new LinkedList<Element>();
                    while (!stack.isEmpty() && (element = (Element)stack.removeFirst()) != null) {
                        if (tagName.equalsIgnoreCase(element.getName())) {
                            Content content;
                            while (!result.isEmpty() && (content = result.getLast()) != null) {
                                if (content instanceof Element && content == element) {
                                    element.setClose(true);
                                    tmp.clear();
                                    break;
                                }
                                if (stack.contains(content)) {
                                    stack.remove(content);
                                }
                                element.addContent(0, result.removeLast());
                            }
                            flag = true;
                            break;
                        }
                        tmp.add(element);
                    }
                    if (tmp != null && !tmp.isEmpty()) {
                        stack = tmp;
                    }
                }
                if (flag) continue;
                result.add(new Text(token.getText()));
                continue;
            }
            result.add(new Text(token.getText()));
        }
        return result;
    }

    public static Collection<Content> parse(InputStream stream, Charset cs) throws IOException {
        return MarkupParser.parse(MarkupParser.read(new InputStreamReader(stream, cs)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String read(Reader reader) throws IOException {
        StringBuffer buffer = new StringBuffer();
        try {
            int rc;
            char[] cbuf = new char[1024];
            while ((rc = reader.read(cbuf)) > 0) {
                buffer.append(cbuf, 0, rc);
            }
        }
        finally {
            reader.close();
        }
        return buffer.toString();
    }

    public static String toString(Collection<Content> contents) {
        if (contents == null) {
            return "";
        }
        StringWriter writer = new StringWriter();
        for (Content content : contents) {
            try {
                content.serialize(writer);
            }
            catch (IOException e) {}
        }
        return writer.toString();
    }
}

