/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.jdbc.mssql;

import com.navercorp.pinpoint.bootstrap.context.DatabaseInfo;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.DefaultDatabaseInfo;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.JdbcUrlParserV2;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.StringMaker;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.UnKnownDatabaseInfo;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.plugin.jdbc.mssql.MssqlConstants;
import java.util.ArrayList;

public class MssqlJdbcUrlParser
implements JdbcUrlParserV2 {
    private static final String MSSQL_URL_PREFIX = "jdbc:sqlserver:";
    private static final String DATABASE_NAME_PROPERTY = "databaseName=";
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());

    public DatabaseInfo parse(String jdbcUrl) {
        if (jdbcUrl == null) {
            this.logger.info("jdbcUrl");
            return UnKnownDatabaseInfo.INSTANCE;
        }
        if (!jdbcUrl.startsWith(MSSQL_URL_PREFIX)) {
            this.logger.info("jdbcUrl has invalid prefix.(url:{}, prefix:{})", (Object)jdbcUrl, (Object)MSSQL_URL_PREFIX);
            return UnKnownDatabaseInfo.INSTANCE;
        }
        try {
            return this.parse0(jdbcUrl);
        }
        catch (Exception e) {
            this.logger.info("MssqlJdbcUrl parse error. url: {}, Caused: {}", new Object[]{jdbcUrl, e.getMessage(), e});
            return UnKnownDatabaseInfo.createUnknownDataBase((ServiceType)MssqlConstants.MSSQL_JDBC, (ServiceType)MssqlConstants.MSSQL_JDBC_QUERY, (String)jdbcUrl);
        }
    }

    private DatabaseInfo parse0(String url) {
        StringMaker maker = new StringMaker(url);
        maker.lower();
        String databaseNamePropertyLowerCase = DATABASE_NAME_PROPERTY.toLowerCase();
        maker.after(MSSQL_URL_PREFIX);
        String host = maker.after("//").before(';').value();
        ArrayList<String> hostList = new ArrayList<String>(1);
        hostList.add(host);
        String databaseId = maker.next().after(databaseNamePropertyLowerCase).before(';').value();
        String normalizedUrl = maker.clear().before(databaseNamePropertyLowerCase).value() + DATABASE_NAME_PROPERTY + databaseId;
        return new DefaultDatabaseInfo(MssqlConstants.MSSQL_JDBC, MssqlConstants.MSSQL_JDBC_QUERY, url, normalizedUrl, hostList, databaseId);
    }

    public ServiceType getServiceType() {
        return MssqlConstants.MSSQL_JDBC;
    }
}

