/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.jdbc.mssql;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilter;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.BindValueAccessor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.JdbcUrlParserV2;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.ParsingResultAccessor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.PreparedStatementBindingMethodFilter;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.CallableStatementRegisterOutParameterInterceptor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.ConnectionCloseInterceptor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.DriverConnectInterceptorV2;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementBindVariableInterceptor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementExecuteQueryInterceptor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementCreateInterceptor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteQueryInterceptor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteUpdateInterceptor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.TransactionCommitInterceptor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.TransactionRollbackInterceptor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.TransactionSetAutoCommitInterceptor;
import com.navercorp.pinpoint.bootstrap.plugin.util.InstrumentUtils;
import com.navercorp.pinpoint.common.util.VarArgs;
import com.navercorp.pinpoint.plugin.jdbc.mssql.MssqlConfig;
import com.navercorp.pinpoint.plugin.jdbc.mssql.MssqlConstants;
import com.navercorp.pinpoint.plugin.jdbc.mssql.MssqlJdbcUrlParser;
import java.security.ProtectionDomain;
import java.util.List;

public class MssqlPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private static final String MSSQL_SCOPE = "MSSQL_JDBC";
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final JdbcUrlParserV2 jdbcUrlParser = new MssqlJdbcUrlParser();
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        MssqlConfig config = new MssqlConfig(context.getConfig());
        if (!config.isPluginEnable()) {
            this.logger.info("{} disabled", (Object)this.getClass().getSimpleName());
            return;
        }
        this.logger.info("{} config:{}", (Object)this.getClass().getSimpleName(), (Object)config);
        context.addJdbcUrlParser(this.jdbcUrlParser);
        this.addConnectionTransformer();
        this.addDriverTransformer();
        this.addPreparedStatementTransformer();
        this.addCallableStatementTransformer();
        this.addStatementTransformer();
    }

    private void addConnectionTransformer() {
        this.transformTemplate.transform("com.microsoft.sqlserver.jdbc.SQLServerConnection", MssqlConnectionTransform.class);
    }

    private void addDriverTransformer() {
        this.transformTemplate.transform("com.microsoft.sqlserver.jdbc.SQLServerDriver", DriverTransformer.class);
    }

    private void addPreparedStatementTransformer() {
        this.transformTemplate.transform("com.microsoft.sqlserver.jdbc.SQLServerPreparedStatement", PreparedStatementTransform.class);
    }

    private void addStatementTransformer() {
        this.transformTemplate.transform("com.microsoft.sqlserver.jdbc.SQLServerStatement", MssqlStatementTransform.class);
    }

    private void addCallableStatementTransformer() {
        this.transformTemplate.transform("com.microsoft.sqlserver.jdbc.SQLServerCallableStatement", MssqlCallableStatementTransform.class);
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }

    public static class MssqlCallableStatementTransform
    implements TransformCallback {
        public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
            InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
            if (!target.isInterceptable()) {
                return null;
            }
            target.addField(DatabaseInfoAccessor.class);
            target.addField(ParsingResultAccessor.class);
            target.addField(BindValueAccessor.class);
            Class<CallableStatementRegisterOutParameterInterceptor> callableStatementInterceptor = CallableStatementRegisterOutParameterInterceptor.class;
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"registerOutParameter", (String[])new String[]{"int", "int"}).addScopedInterceptor(callableStatementInterceptor, MssqlPlugin.MSSQL_SCOPE);
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"registerOutParameter", (String[])new String[]{"int", "int", "int"}).addScopedInterceptor(callableStatementInterceptor, MssqlPlugin.MSSQL_SCOPE);
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"registerOutParameter", (String[])new String[]{"int", "int", "java.lang.String"}).addScopedInterceptor(callableStatementInterceptor, MssqlPlugin.MSSQL_SCOPE);
            return target.toBytecode();
        }
    }

    public static class MssqlStatementTransform
    implements TransformCallback {
        public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
            InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
            if (!target.isInterceptable()) {
                return null;
            }
            target.addField(DatabaseInfoAccessor.class);
            Class<StatementExecuteQueryInterceptor> executeQueryInterceptor = StatementExecuteQueryInterceptor.class;
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeQuery", (String[])new String[]{"java.lang.String"}).addScopedInterceptor(executeQueryInterceptor, MssqlPlugin.MSSQL_SCOPE);
            Class<StatementExecuteUpdateInterceptor> executeUpdateInterceptor = StatementExecuteUpdateInterceptor.class;
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeUpdate", (String[])new String[]{"java.lang.String"}).addScopedInterceptor(executeUpdateInterceptor, MssqlPlugin.MSSQL_SCOPE);
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeUpdate", (String[])new String[]{"java.lang.String", "int"}).addScopedInterceptor(executeUpdateInterceptor, MssqlPlugin.MSSQL_SCOPE);
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"execute", (String[])new String[]{"java.lang.String"}).addScopedInterceptor(executeUpdateInterceptor, MssqlPlugin.MSSQL_SCOPE);
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"execute", (String[])new String[]{"java.lang.String", "int"}).addScopedInterceptor(executeUpdateInterceptor, MssqlPlugin.MSSQL_SCOPE);
            return target.toBytecode();
        }
    }

    public static class PreparedStatementTransform
    implements TransformCallback {
        public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
            MssqlConfig config = new MssqlConfig(instrumentor.getProfilerConfig());
            InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
            target.addField(DatabaseInfoAccessor.class);
            target.addField(ParsingResultAccessor.class);
            target.addField(BindValueAccessor.class);
            int maxBindValueSize = config.getMaxSqlBindValueSize();
            Class<PreparedStatementExecuteQueryInterceptor> preparedStatementInterceptor = PreparedStatementExecuteQueryInterceptor.class;
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"execute", (String[])new String[0]).addScopedInterceptor(preparedStatementInterceptor, VarArgs.va((Object[])new Object[]{maxBindValueSize}), MssqlPlugin.MSSQL_SCOPE);
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeQuery", (String[])new String[0]).addScopedInterceptor(preparedStatementInterceptor, VarArgs.va((Object[])new Object[]{maxBindValueSize}), MssqlPlugin.MSSQL_SCOPE);
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeUpdate", (String[])new String[0]).addScopedInterceptor(preparedStatementInterceptor, VarArgs.va((Object[])new Object[]{maxBindValueSize}), MssqlPlugin.MSSQL_SCOPE);
            if (config.isTraceSqlBindValue()) {
                PreparedStatementBindingMethodFilter excludes = PreparedStatementBindingMethodFilter.excludes((String[])new String[]{"setRowId", "setNClob", "setSQLXML"});
                List declaredMethods = target.getDeclaredMethods((MethodFilter)excludes);
                for (InstrumentMethod method : declaredMethods) {
                    method.addScopedInterceptor(PreparedStatementBindVariableInterceptor.class, MssqlPlugin.MSSQL_SCOPE, ExecutionPolicy.BOUNDARY);
                }
            }
            return target.toBytecode();
        }
    }

    public static class DriverTransformer
    implements TransformCallback {
        public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
            InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
            target.addField(DatabaseInfoAccessor.class);
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"connect", (String[])new String[]{"java.lang.String", "java.util.Properties"}).addScopedInterceptor(DriverConnectInterceptorV2.class, VarArgs.va((Object[])new Object[]{MssqlConstants.MSSQL_JDBC, true}), MssqlPlugin.MSSQL_SCOPE, ExecutionPolicy.ALWAYS);
            return target.toBytecode();
        }
    }

    public static class MssqlConnectionTransform
    implements TransformCallback {
        public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
            MssqlConfig config = new MssqlConfig(instrumentor.getProfilerConfig());
            InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
            if (!target.isInterceptable()) {
                return null;
            }
            target.addField(DatabaseInfoAccessor.class);
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"close", (String[])new String[0]).addScopedInterceptor(ConnectionCloseInterceptor.class, MssqlPlugin.MSSQL_SCOPE);
            Class<StatementCreateInterceptor> statementCreate = StatementCreateInterceptor.class;
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"createStatement", (String[])new String[0]).addScopedInterceptor(statementCreate, MssqlPlugin.MSSQL_SCOPE);
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"createStatement", (String[])new String[]{"int", "int"}).addScopedInterceptor(statementCreate, MssqlPlugin.MSSQL_SCOPE);
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"createStatement", (String[])new String[]{"int", "int", "int"}).addScopedInterceptor(statementCreate, MssqlPlugin.MSSQL_SCOPE);
            Class<PreparedStatementCreateInterceptor> preparedStatementCreate = PreparedStatementCreateInterceptor.class;
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String"}).addScopedInterceptor(preparedStatementCreate, MssqlPlugin.MSSQL_SCOPE);
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "int"}).addScopedInterceptor(preparedStatementCreate, MssqlPlugin.MSSQL_SCOPE);
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "int[]"}).addScopedInterceptor(preparedStatementCreate, MssqlPlugin.MSSQL_SCOPE);
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "java.lang.String[]"}).addScopedInterceptor(preparedStatementCreate, MssqlPlugin.MSSQL_SCOPE);
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "int", "int"}).addScopedInterceptor(preparedStatementCreate, MssqlPlugin.MSSQL_SCOPE);
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "int", "int", "int"}).addScopedInterceptor(preparedStatementCreate, MssqlPlugin.MSSQL_SCOPE);
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareCall", (String[])new String[]{"java.lang.String"}).addScopedInterceptor(preparedStatementCreate, MssqlPlugin.MSSQL_SCOPE);
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareCall", (String[])new String[]{"java.lang.String", "int", "int"}).addScopedInterceptor(preparedStatementCreate, MssqlPlugin.MSSQL_SCOPE);
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareCall", (String[])new String[]{"java.lang.String", "int", "int", "int"}).addScopedInterceptor(preparedStatementCreate, MssqlPlugin.MSSQL_SCOPE);
            if (config.isProfileSetAutoCommit()) {
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"setAutoCommit", (String[])new String[]{"boolean"}).addScopedInterceptor(TransactionSetAutoCommitInterceptor.class, MssqlPlugin.MSSQL_SCOPE);
            }
            if (config.isProfileCommit()) {
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"commit", (String[])new String[0]).addScopedInterceptor(TransactionCommitInterceptor.class, MssqlPlugin.MSSQL_SCOPE);
            }
            if (config.isProfileRollback()) {
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"rollback", (String[])new String[0]).addScopedInterceptor(TransactionRollbackInterceptor.class, MssqlPlugin.MSSQL_SCOPE);
            }
            return target.toBytecode();
        }
    }
}

