/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.jdbc.mysql;

import com.navercorp.pinpoint.bootstrap.context.DatabaseInfo;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.DefaultDatabaseInfo;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.JdbcUrlParserV2;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.StringMaker;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.UnKnownDatabaseInfo;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.plugin.jdbc.mysql.MySqlConstants;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class MySqlJdbcUrlParser
implements JdbcUrlParserV2 {
    static final String URL_PREFIX = "jdbc:mysql:";
    private static final String LOADBALANCE_URL_PREFIX = "jdbc:mysql:loadbalance:";
    static final String EMPTY_DATABASE = "EMPTY_DATABASE";
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());

    public DatabaseInfo parse(String jdbcUrl) {
        if (jdbcUrl == null) {
            this.logger.info("jdbcUrl must not be null");
            return UnKnownDatabaseInfo.INSTANCE;
        }
        if (!jdbcUrl.startsWith(URL_PREFIX)) {
            this.logger.info("jdbcUrl has invalid prefix.(url:{}, prefix:{})", (Object)jdbcUrl, (Object)URL_PREFIX);
            return UnKnownDatabaseInfo.INSTANCE;
        }
        DatabaseInfo result = null;
        try {
            result = this.parse0(jdbcUrl);
        }
        catch (Exception e) {
            this.logger.info("MySqlJdbcUrl parse error. url: {}, Caused: {}", new Object[]{jdbcUrl, e.getMessage(), e});
            result = UnKnownDatabaseInfo.createUnknownDataBase((ServiceType)MySqlConstants.MYSQL, (ServiceType)MySqlConstants.MYSQL_EXECUTE_QUERY, (String)jdbcUrl);
        }
        return result;
    }

    private DatabaseInfo parse0(String jdbcUrl) {
        StringMaker maker = new StringMaker(jdbcUrl);
        maker.after(URL_PREFIX);
        String host = maker.after("//").before('/').value();
        List<String> hostList = this.parseHost(host);
        String databaseId = maker.next().after('/').before('?').value();
        databaseId = StringUtils.defaultIfEmpty((String)databaseId, (String)EMPTY_DATABASE);
        String normalizedUrl = maker.clear().before('?').value();
        return new DefaultDatabaseInfo(MySqlConstants.MYSQL, MySqlConstants.MYSQL_EXECUTE_QUERY, jdbcUrl, normalizedUrl, hostList, databaseId);
    }

    private List<String> parseHost(String host) {
        int multiHost = host.indexOf(",");
        if (multiHost == -1) {
            return Collections.singletonList(host);
        }
        String[] parsedHost = host.split(",");
        return Arrays.asList(parsedHost);
    }

    public ServiceType getServiceType() {
        return MySqlConstants.MYSQL;
    }
}

