/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.jdbc.mysql;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilter;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.logging.PluginLogManager;
import com.navercorp.pinpoint.bootstrap.logging.PluginLogger;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.BindValueAccessor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.JdbcUrlParserV2;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.ParsingResultAccessor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.PreparedStatementBindingMethodFilter;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.CallableStatementBindVariableInterceptor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.CallableStatementExecuteQueryInterceptor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.CallableStatementRegisterOutParameterInterceptor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.ConnectionCloseInterceptor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.DriverConnectInterceptorV2;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementBindVariableInterceptor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementExecuteQueryInterceptor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementCreateInterceptor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteQueryInterceptor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteUpdateInterceptor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.TransactionCommitInterceptor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.TransactionRollbackInterceptor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.TransactionSetAutoCommitInterceptor;
import com.navercorp.pinpoint.bootstrap.plugin.util.InstrumentUtils;
import com.navercorp.pinpoint.common.util.VarArgs;
import com.navercorp.pinpoint.plugin.jdbc.mysql.MySqlConfig;
import com.navercorp.pinpoint.plugin.jdbc.mysql.MySqlConstants;
import com.navercorp.pinpoint.plugin.jdbc.mysql.MySqlJdbcUrlParser;
import com.navercorp.pinpoint.plugin.jdbc.mysql.interceptor.MySQLConnectionCreateInterceptor;
import com.navercorp.pinpoint.plugin.jdbc.mysql.interceptor.MySQL_6_X_ConnectionCreateInterceptor;
import com.navercorp.pinpoint.plugin.jdbc.mysql.interceptor.getter.DatabaseGetter;
import com.navercorp.pinpoint.plugin.jdbc.mysql.interceptor.getter.OrigHostToConnectToGetter;
import com.navercorp.pinpoint.plugin.jdbc.mysql.interceptor.getter.OrigPortToConnectToGetter;
import java.security.ProtectionDomain;
import java.util.List;

public class MySqlPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private static final String MYSQL_SCOPE = "MYSQL_JDBC";
    private final PluginLogger logger = PluginLogManager.getLogger(this.getClass());
    private TransformTemplate transformTemplate;
    private final JdbcUrlParserV2 jdbcUrlParser = new MySqlJdbcUrlParser();

    public void setup(ProfilerPluginSetupContext context) {
        MySqlConfig config = new MySqlConfig(context.getConfig());
        if (!config.isPluginEnable()) {
            this.logger.info("{} disabled", (Object)this.getClass().getSimpleName());
            return;
        }
        this.logger.info("{} config:{}", (Object)this.getClass().getSimpleName(), (Object)config);
        context.addJdbcUrlParser(this.jdbcUrlParser);
        this.addConnectionTransformer(config);
        this.addDriverTransformer();
        this.addStatementTransformer();
        this.addPreparedStatementTransformer(config);
        this.addCallableStatementTransformer(config);
        this.addJDBC4PreparedStatementTransformer(config);
        this.addJDBC4CallableStatementTransformer(config);
    }

    private void addConnectionTransformer(MySqlConfig config) {
        this.transformTemplate.transform("com.mysql.jdbc.Connection", ConnectionTransform.class);
        this.transformTemplate.transform("com.mysql.jdbc.ConnectionImpl", ConnectionTransform.class);
        this.transformTemplate.transform("com.mysql.cj.jdbc.ConnectionImpl", ConnectionTransform.class);
    }

    private void addDriverTransformer() {
        this.transformTemplate.transform("com.mysql.jdbc.NonRegisteringDriver", DriverTransform.class);
        this.transformTemplate.transform("com.mysql.cj.jdbc.NonRegisteringDriver", DriverTransform.class);
    }

    private void addPreparedStatementTransformer(MySqlConfig config) {
        this.transformTemplate.transform("com.mysql.jdbc.PreparedStatement", PreparedStatementTransform.class);
        this.transformTemplate.transform("com.mysql.jdbc.ServerPreparedStatement", PreparedStatementTransform.class);
        this.transformTemplate.transform("com.mysql.cj.jdbc.PreparedStatement", PreparedStatementTransform.class);
        this.transformTemplate.transform("com.mysql.cj.jdbc.ClientPreparedStatement", PreparedStatementTransform.class);
        this.transformTemplate.transform("com.mysql.cj.jdbc.ServerPreparedStatement", PreparedStatementTransform.class);
    }

    private void addCallableStatementTransformer(MySqlConfig config) {
        this.transformTemplate.transform("com.mysql.jdbc.CallableStatement", CallableStatementTransform.class);
        this.transformTemplate.transform("com.mysql.cj.jdbc.CallableStatement", CallableStatementTransform.class);
    }

    private void addJDBC4PreparedStatementTransformer(MySqlConfig config) {
        this.transformTemplate.transform("com.mysql.jdbc.JDBC4PreparedStatement", JDBC4PreparedStatementTransform.class);
    }

    private void addJDBC4CallableStatementTransformer(MySqlConfig config) {
        this.transformTemplate.transform("com.mysql.jdbc.JDBC4CallableStatement", JDBC4CallableStatement.class);
    }

    private void addStatementTransformer() {
        this.transformTemplate.transform("com.mysql.jdbc.Statement", StatementTransformer.class);
        this.transformTemplate.transform("com.mysql.jdbc.StatementImpl", StatementTransformer.class);
        this.transformTemplate.transform("com.mysql.cj.jdbc.StatementImpl", StatementTransformer.class);
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }

    public static class StatementTransformer
    implements TransformCallback {
        public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
            InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
            if (!target.isInterceptable()) {
                return null;
            }
            target.addField(DatabaseInfoAccessor.class);
            Class<StatementExecuteQueryInterceptor> executeQueryInterceptor = StatementExecuteQueryInterceptor.class;
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeQuery", (String[])new String[]{"java.lang.String"}).addScopedInterceptor(executeQueryInterceptor, MySqlPlugin.MYSQL_SCOPE);
            Class<StatementExecuteUpdateInterceptor> executeUpdateInterceptor = StatementExecuteUpdateInterceptor.class;
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeUpdate", (String[])new String[]{"java.lang.String"}).addScopedInterceptor(executeUpdateInterceptor, MySqlPlugin.MYSQL_SCOPE);
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeUpdate", (String[])new String[]{"java.lang.String", "int"}).addScopedInterceptor(executeUpdateInterceptor, MySqlPlugin.MYSQL_SCOPE);
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"execute", (String[])new String[]{"java.lang.String"}).addScopedInterceptor(executeUpdateInterceptor, MySqlPlugin.MYSQL_SCOPE);
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"execute", (String[])new String[]{"java.lang.String", "int"}).addScopedInterceptor(executeUpdateInterceptor, MySqlPlugin.MYSQL_SCOPE);
            return target.toBytecode();
        }
    }

    public static class JDBC4CallableStatement
    implements TransformCallback {
        public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
            InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
            MySqlConfig config = new MySqlConfig(instrumentor.getProfilerConfig());
            if (config.isTraceSqlBindValue()) {
                PreparedStatementBindingMethodFilter includes = PreparedStatementBindingMethodFilter.includes((String[])new String[]{"setRowId", "setNClob", "setSQLXML"});
                List declaredMethods = target.getDeclaredMethods((MethodFilter)includes);
                for (InstrumentMethod method : declaredMethods) {
                    method.addScopedInterceptor(CallableStatementBindVariableInterceptor.class, MySqlPlugin.MYSQL_SCOPE, ExecutionPolicy.BOUNDARY);
                }
            }
            return target.toBytecode();
        }
    }

    public static class JDBC4PreparedStatementTransform
    implements TransformCallback {
        public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
            InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
            MySqlConfig config = new MySqlConfig(instrumentor.getProfilerConfig());
            if (config.isTraceSqlBindValue()) {
                PreparedStatementBindingMethodFilter includes = PreparedStatementBindingMethodFilter.includes((String[])new String[]{"setRowId", "setNClob", "setSQLXML"});
                List declaredMethods = target.getDeclaredMethods((MethodFilter)includes);
                for (InstrumentMethod method : declaredMethods) {
                    method.addScopedInterceptor(PreparedStatementBindVariableInterceptor.class, MySqlPlugin.MYSQL_SCOPE, ExecutionPolicy.BOUNDARY);
                }
            }
            return target.toBytecode();
        }
    }

    public static class CallableStatementTransform
    implements TransformCallback {
        public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
            InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
            target.addField(DatabaseInfoAccessor.class);
            target.addField(ParsingResultAccessor.class);
            target.addField(BindValueAccessor.class);
            MySqlConfig config = new MySqlConfig(instrumentor.getProfilerConfig());
            int maxBindValueSize = config.getMaxSqlBindValueSize();
            Class<CallableStatementExecuteQueryInterceptor> callableStatementExecuteQuery = CallableStatementExecuteQueryInterceptor.class;
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"execute", (String[])new String[0]).addScopedInterceptor(callableStatementExecuteQuery, VarArgs.va((Object[])new Object[]{maxBindValueSize}), MySqlPlugin.MYSQL_SCOPE);
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeQuery", (String[])new String[0]).addScopedInterceptor(callableStatementExecuteQuery, VarArgs.va((Object[])new Object[]{maxBindValueSize}), MySqlPlugin.MYSQL_SCOPE);
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeUpdate", (String[])new String[0]).addScopedInterceptor(callableStatementExecuteQuery, VarArgs.va((Object[])new Object[]{maxBindValueSize}), MySqlPlugin.MYSQL_SCOPE);
            Class<CallableStatementRegisterOutParameterInterceptor> registerOutParameterInterceptor = CallableStatementRegisterOutParameterInterceptor.class;
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"registerOutParameter", (String[])new String[]{"int", "int"}).addScopedInterceptor(registerOutParameterInterceptor, MySqlPlugin.MYSQL_SCOPE);
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"registerOutParameter", (String[])new String[]{"int", "int", "int"}).addScopedInterceptor(registerOutParameterInterceptor, MySqlPlugin.MYSQL_SCOPE);
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"registerOutParameter", (String[])new String[]{"int", "int", "java.lang.String"}).addScopedInterceptor(registerOutParameterInterceptor, MySqlPlugin.MYSQL_SCOPE);
            if (config.isTraceSqlBindValue()) {
                PreparedStatementBindingMethodFilter excludes = PreparedStatementBindingMethodFilter.excludes((String[])new String[]{"setRowId", "setNClob", "setSQLXML"});
                List declaredMethods = target.getDeclaredMethods((MethodFilter)excludes);
                for (InstrumentMethod method : declaredMethods) {
                    method.addScopedInterceptor(CallableStatementBindVariableInterceptor.class, MySqlPlugin.MYSQL_SCOPE, ExecutionPolicy.BOUNDARY);
                }
            }
            return target.toBytecode();
        }
    }

    public static class PreparedStatementTransform
    implements TransformCallback {
        public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
            InstrumentMethod executeUpdateMethod;
            InstrumentMethod executeQueryMethod;
            InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
            target.addField(DatabaseInfoAccessor.class);
            target.addField(ParsingResultAccessor.class);
            target.addField(BindValueAccessor.class);
            MySqlConfig config = new MySqlConfig(instrumentor.getProfilerConfig());
            int maxBindValueSize = config.getMaxSqlBindValueSize();
            Class<PreparedStatementExecuteQueryInterceptor> preparedStatementInterceptor = PreparedStatementExecuteQueryInterceptor.class;
            InstrumentMethod executeMethod = target.getDeclaredMethod("execute", new String[0]);
            if (executeMethod != null) {
                executeMethod.addScopedInterceptor(preparedStatementInterceptor, VarArgs.va((Object[])new Object[]{maxBindValueSize}), MySqlPlugin.MYSQL_SCOPE);
            }
            if ((executeQueryMethod = target.getDeclaredMethod("executeQuery", new String[0])) != null) {
                executeQueryMethod.addScopedInterceptor(preparedStatementInterceptor, VarArgs.va((Object[])new Object[]{maxBindValueSize}), MySqlPlugin.MYSQL_SCOPE);
            }
            if ((executeUpdateMethod = target.getDeclaredMethod("executeUpdate", new String[0])) != null) {
                executeUpdateMethod.addScopedInterceptor(preparedStatementInterceptor, VarArgs.va((Object[])new Object[]{maxBindValueSize}), MySqlPlugin.MYSQL_SCOPE);
            }
            if (config.isTraceSqlBindValue()) {
                PreparedStatementBindingMethodFilter excludes = PreparedStatementBindingMethodFilter.excludes((String[])new String[]{"setRowId", "setNClob", "setSQLXML"});
                List declaredMethods = target.getDeclaredMethods((MethodFilter)excludes);
                for (InstrumentMethod method : declaredMethods) {
                    method.addScopedInterceptor(PreparedStatementBindVariableInterceptor.class, MySqlPlugin.MYSQL_SCOPE, ExecutionPolicy.BOUNDARY);
                }
            }
            return target.toBytecode();
        }
    }

    public static class DriverTransform
    implements TransformCallback {
        public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
            InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"connect", (String[])new String[]{"java.lang.String", "java.util.Properties"}).addScopedInterceptor(DriverConnectInterceptorV2.class, VarArgs.va((Object[])new Object[]{MySqlConstants.MYSQL, false}), MySqlPlugin.MYSQL_SCOPE, ExecutionPolicy.ALWAYS);
            return target.toBytecode();
        }
    }

    public static class ConnectionTransform
    implements TransformCallback {
        public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
            InstrumentMethod constructor_6_X;
            InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
            if (!target.isInterceptable()) {
                return null;
            }
            target.addField(DatabaseInfoAccessor.class);
            InstrumentMethod constructor = target.getConstructor(new String[]{"java.lang.String", "int", "java.util.Properties", "java.lang.String", "java.lang.String"});
            if (constructor != null) {
                constructor.addInterceptor(MySQLConnectionCreateInterceptor.class);
            }
            if ((constructor_6_X = target.getConstructor(new String[]{"com.mysql.cj.core.ConnectionString", "java.lang.String", "int", "java.util.Properties"})) == null) {
                constructor_6_X = target.getConstructor(new String[]{"com.mysql.cj.core.conf.url.HostInfo"});
            }
            if (constructor_6_X == null) {
                constructor_6_X = target.getConstructor(new String[]{"com.mysql.cj.conf.HostInfo"});
            }
            if (constructor_6_X != null) {
                target.addGetter(OrigHostToConnectToGetter.class, "origHostToConnectTo");
                target.addGetter(OrigPortToConnectToGetter.class, "origPortToConnectTo");
                target.addGetter(DatabaseGetter.class, "database");
                constructor_6_X.addInterceptor(MySQL_6_X_ConnectionCreateInterceptor.class);
            }
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"close", (String[])new String[0]).addScopedInterceptor(ConnectionCloseInterceptor.class, MySqlPlugin.MYSQL_SCOPE);
            Class<StatementCreateInterceptor> statementCreate = StatementCreateInterceptor.class;
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"createStatement", (String[])new String[0]).addScopedInterceptor(statementCreate, MySqlPlugin.MYSQL_SCOPE);
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"createStatement", (String[])new String[]{"int", "int"}).addScopedInterceptor(statementCreate, MySqlPlugin.MYSQL_SCOPE);
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"createStatement", (String[])new String[]{"int", "int", "int"}).addScopedInterceptor(statementCreate, MySqlPlugin.MYSQL_SCOPE);
            Class<PreparedStatementCreateInterceptor> preparedStatementCreate = PreparedStatementCreateInterceptor.class;
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String"}).addScopedInterceptor(preparedStatementCreate, MySqlPlugin.MYSQL_SCOPE);
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "int"}).addScopedInterceptor(preparedStatementCreate, MySqlPlugin.MYSQL_SCOPE);
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "int[]"}).addScopedInterceptor(preparedStatementCreate, MySqlPlugin.MYSQL_SCOPE);
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "java.lang.String[]"}).addScopedInterceptor(preparedStatementCreate, MySqlPlugin.MYSQL_SCOPE);
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "int", "int"}).addScopedInterceptor(preparedStatementCreate, MySqlPlugin.MYSQL_SCOPE);
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "int", "int", "int"}).addScopedInterceptor(preparedStatementCreate, MySqlPlugin.MYSQL_SCOPE);
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareCall", (String[])new String[]{"java.lang.String"}).addScopedInterceptor(preparedStatementCreate, MySqlPlugin.MYSQL_SCOPE);
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareCall", (String[])new String[]{"java.lang.String", "int", "int"}).addScopedInterceptor(preparedStatementCreate, MySqlPlugin.MYSQL_SCOPE);
            InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareCall", (String[])new String[]{"java.lang.String", "int", "int", "int"}).addScopedInterceptor(preparedStatementCreate, MySqlPlugin.MYSQL_SCOPE);
            MySqlConfig config = new MySqlConfig(instrumentor.getProfilerConfig());
            if (config.isProfileSetAutoCommit()) {
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"setAutoCommit", (String[])new String[]{"boolean"}).addScopedInterceptor(TransactionSetAutoCommitInterceptor.class, MySqlPlugin.MYSQL_SCOPE);
            }
            if (config.isProfileCommit()) {
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"commit", (String[])new String[0]).addScopedInterceptor(TransactionCommitInterceptor.class, MySqlPlugin.MYSQL_SCOPE);
            }
            if (config.isProfileRollback()) {
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"rollback", (String[])new String[0]).addScopedInterceptor(TransactionRollbackInterceptor.class, MySqlPlugin.MYSQL_SCOPE);
            }
            return target.toBytecode();
        }
    }
}

