/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.pluginit.jdbc;

import com.navercorp.pinpoint.bootstrap.context.DatabaseInfo;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.JdbcUrlParserV2;
import com.navercorp.pinpoint.bootstrap.plugin.test.Expectations;
import com.navercorp.pinpoint.bootstrap.plugin.test.ExpectedAnnotation;
import com.navercorp.pinpoint.bootstrap.plugin.test.ExpectedTrace;
import com.navercorp.pinpoint.bootstrap.plugin.test.PluginTestVerifier;
import com.navercorp.pinpoint.bootstrap.plugin.test.PluginTestVerifierHolder;
import com.navercorp.pinpoint.pluginit.jdbc.DriverManagerUtils;
import com.navercorp.pinpoint.pluginit.jdbc.DriverProperties;
import com.navercorp.pinpoint.pluginit.jdbc.JDBCApi;
import com.navercorp.pinpoint.pluginit.jdbc.JDBCDriverClass;
import com.navercorp.pinpoint.pluginit.jdbc.JdbcUtils;
import com.navercorp.pinpoint.pluginit.jdbc.template.CallableStatementCallback;
import com.navercorp.pinpoint.pluginit.jdbc.template.DriverManagerDataSource;
import com.navercorp.pinpoint.pluginit.jdbc.template.PreparedStatementSetter;
import com.navercorp.pinpoint.pluginit.jdbc.template.ResultSetExtractor;
import com.navercorp.pinpoint.pluginit.jdbc.template.SimpleJdbcTemplate;
import com.navercorp.pinpoint.pluginit.jdbc.template.TransactionCallback;
import com.navercorp.pinpoint.pluginit.jdbc.template.TransactionDataSource;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataBaseTestCase {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String DB_TYPE;
    protected String DB_EXECUTE_QUERY;
    protected String jdbcUrl;
    protected String databaseId;
    protected String databaseIdPassword;
    protected String databaseAddress;
    protected String databaseName;
    protected JDBCApi jdbcApi;
    private DataSource dataSource;

    public void setup(String dbType, String executeQuery, DriverProperties driverProperties, JdbcUrlParserV2 jdbcUrlParser, JDBCApi jdbcApi) {
        this.DB_TYPE = dbType;
        this.DB_EXECUTE_QUERY = executeQuery;
        this.jdbcUrl = driverProperties.getUrl();
        DatabaseInfo databaseInfo = jdbcUrlParser.parse(this.jdbcUrl);
        this.databaseAddress = (String)databaseInfo.getHost().get(0);
        this.databaseName = databaseInfo.getDatabaseId();
        this.databaseId = driverProperties.getUser();
        this.databaseIdPassword = driverProperties.getPassword();
        this.dataSource = new DriverManagerDataSource(this.jdbcUrl, this.databaseId, this.databaseIdPassword);
        this.jdbcApi = jdbcApi;
        try {
            JDBCDriverClass jdbcDriverClass = this.getJDBCDriverClass();
            Driver driver = jdbcDriverClass.getDriver().newInstance();
            DriverManager.registerDriver(driver);
        }
        catch (Exception e) {
            throw new RuntimeException("driver register error", e);
        }
    }

    protected abstract JDBCDriverClass getJDBCDriverClass();

    @After
    public void deregisterDriver() {
        DriverManagerUtils.deregisterDriver();
    }

    @Test
    public void testStatement() throws Exception {
        String insertQuery = "INSERT INTO test (name, age) VALUES (?, ?)";
        String selectQuery = "SELECT * FROM test";
        String deleteQuery = "DELETE FROM test";
        TransactionDataSource transactionDataSource = new TransactionDataSource(this.dataSource);
        final SimpleJdbcTemplate template = new SimpleJdbcTemplate(transactionDataSource, SimpleJdbcTemplate.ConnectionInterceptor.EMPTY);
        transactionDataSource.doInTransaction(new TransactionCallback(){

            @Override
            public void doInTransaction() throws SQLException {
                template.execute("INSERT INTO test (name, age) VALUES (?, ?)", new PreparedStatementSetter(){

                    @Override
                    public void setValues(PreparedStatement ps) throws SQLException {
                        ps.setString(1, "maru");
                        ps.setInt(2, 5);
                    }
                });
                List<User> users = template.executeQuery("SELECT * FROM test", new ResultSetExtractor<List<User>>(){

                    @Override
                    public List<User> extractData(ResultSet rs) throws SQLException {
                        ArrayList<User> users = new ArrayList<User>();
                        while (rs.next()) {
                            int id = rs.getInt("id");
                            String name = rs.getString("name");
                            int age = rs.getInt("age");
                            users.add(new User(id, name, age));
                        }
                        return users;
                    }
                });
                DataBaseTestCase.this.logger.debug("users:{}", users);
                template.executeUpdate("DELETE FROM test");
            }
        });
        PluginTestVerifier verifier = PluginTestVerifierHolder.getInstance();
        verifier.printCache();
        Method connect = this.jdbcApi.getDriver().getConnect();
        verifier.verifyTrace(new ExpectedTrace[]{Expectations.event((String)this.DB_TYPE, (Member)connect, null, (String)this.databaseAddress, (String)this.databaseName, (ExpectedAnnotation[])Expectations.cachedArgs((Object[])new Object[]{this.jdbcUrl}))});
        JDBCApi.ConnectionClass connectionClass = this.jdbcApi.getConnection();
        Method setAutoCommit = connectionClass.getSetAutoCommit();
        verifier.verifyTrace(new ExpectedTrace[]{Expectations.event((String)this.DB_TYPE, (Member)setAutoCommit, null, (String)this.databaseAddress, (String)this.databaseName, (ExpectedAnnotation[])Expectations.args((Object[])new Object[]{false}))});
        Method prepareStatement = connectionClass.getPrepareStatement();
        verifier.verifyTrace(new ExpectedTrace[]{Expectations.event((String)this.DB_TYPE, (Member)prepareStatement, null, (String)this.databaseAddress, (String)this.databaseName, (ExpectedAnnotation[])new ExpectedAnnotation[]{Expectations.sql((String)"INSERT INTO test (name, age) VALUES (?, ?)", null, (Object[])new Object[0])})});
        Method execute = this.jdbcApi.getPreparedStatement().getExecute();
        verifier.verifyTrace(new ExpectedTrace[]{Expectations.event((String)this.DB_EXECUTE_QUERY, (Member)execute, null, (String)this.databaseAddress, (String)this.databaseName, (ExpectedAnnotation[])new ExpectedAnnotation[]{Expectations.sql((String)"INSERT INTO test (name, age) VALUES (?, ?)", null, (Object[])new Object[]{"maru, 5"})})});
        JDBCApi.StatementClass statementClass = this.jdbcApi.getStatement();
        Method executeQuery = statementClass.getExecuteQuery();
        verifier.verifyTrace(new ExpectedTrace[]{Expectations.event((String)this.DB_EXECUTE_QUERY, (Member)executeQuery, null, (String)this.databaseAddress, (String)this.databaseName, (ExpectedAnnotation[])new ExpectedAnnotation[]{Expectations.sql((String)"SELECT * FROM test", null, (Object[])new Object[0])})});
        Method executeUpdate = statementClass.getExecuteUpdate();
        verifier.verifyTrace(new ExpectedTrace[]{Expectations.event((String)this.DB_EXECUTE_QUERY, (Member)executeUpdate, null, (String)this.databaseAddress, (String)this.databaseName, (ExpectedAnnotation[])new ExpectedAnnotation[]{Expectations.sql((String)"DELETE FROM test", null, (Object[])new Object[0])})});
        Method commit = connectionClass.getCommit();
        verifier.verifyTrace(new ExpectedTrace[]{Expectations.event((String)this.DB_TYPE, (Member)commit, null, (String)this.databaseAddress, (String)this.databaseName, (ExpectedAnnotation[])new ExpectedAnnotation[0])});
    }

    @Test
    public void testStoredProcedure_with_IN_OUT_parameters() throws Exception {
        String param1 = "a";
        String param2 = "b";
        String storedProcedureQuery = "{ call concatCharacters(?, ?, ?) }";
        SimpleJdbcTemplate template = new SimpleJdbcTemplate(this.dataSource, SimpleJdbcTemplate.ConnectionInterceptor.EMPTY);
        String result = template.execute("{ call concatCharacters(?, ?, ?) }", new CallableStatementCallback<String>(){

            @Override
            public String doInCallableStatement(CallableStatement cs) throws SQLException {
                cs.setString(1, "a");
                cs.setString(2, "b");
                cs.registerOutParameter(3, 12);
                cs.execute();
                return cs.getString(3);
            }
        });
        Assert.assertEquals((Object)"a".concat("b"), (Object)result);
        PluginTestVerifier verifier = PluginTestVerifierHolder.getInstance();
        verifier.printCache();
        verifier.verifyTraceCount(4);
        Method connect = this.jdbcApi.getDriver().getConnect();
        verifier.verifyTrace(new ExpectedTrace[]{Expectations.event((String)this.DB_TYPE, (Member)connect, null, (String)this.databaseAddress, (String)this.databaseName, (ExpectedAnnotation[])Expectations.cachedArgs((Object[])new Object[]{this.jdbcUrl}))});
        JDBCApi.ConnectionClass connectionClass = this.jdbcApi.getConnection();
        Method prepareCall = connectionClass.getPrepareCall();
        verifier.verifyTrace(new ExpectedTrace[]{Expectations.event((String)this.DB_TYPE, (Member)prepareCall, null, (String)this.databaseAddress, (String)this.databaseName, (ExpectedAnnotation[])new ExpectedAnnotation[]{Expectations.sql((String)"{ call concatCharacters(?, ?, ?) }", null, (Object[])new Object[0])})});
        Method registerOutParameter = this.jdbcApi.getCallableStatement().getRegisterOutParameter();
        verifier.verifyTrace(new ExpectedTrace[]{Expectations.event((String)this.DB_TYPE, (Member)registerOutParameter, null, (String)this.databaseAddress, (String)this.databaseName, (ExpectedAnnotation[])Expectations.args((Object[])new Object[]{3, 12}))});
        Method execute = this.jdbcApi.getPreparedStatement().getExecute();
        verifier.verifyTrace(new ExpectedTrace[]{Expectations.event((String)this.DB_EXECUTE_QUERY, (Member)execute, null, (String)this.databaseAddress, (String)this.databaseName, (ExpectedAnnotation[])new ExpectedAnnotation[]{Expectations.sql((String)"{ call concatCharacters(?, ?, ?) }", null, (Object[])new Object[]{"a, b"})})});
    }

    @Test
    public void testStoredProcedure_with_INOUT_parameters() throws Exception {
        boolean param1 = true;
        int param2 = 2;
        String storedProcedureQuery = "{ call swapAndGetSum(?, ?) }";
        SimpleJdbcTemplate template = new SimpleJdbcTemplate(this.dataSource, SimpleJdbcTemplate.ConnectionInterceptor.EMPTY);
        SwapResult result = template.execute("{ call swapAndGetSum(?, ?) }", new CallableStatementCallback<SwapResult>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SwapResult doInCallableStatement(CallableStatement cs) throws SQLException {
                cs.setInt(1, 1);
                cs.setInt(2, 2);
                cs.registerOutParameter(1, 4);
                cs.registerOutParameter(2, 4);
                SwapResult swapResult = new SwapResult();
                ResultSet rs = null;
                try {
                    rs = cs.executeQuery();
                    while (rs.next()) {
                        int sum = rs.getInt(1);
                        swapResult.results.add(sum);
                    }
                }
                finally {
                    JdbcUtils.closeResultSet(rs);
                }
                int output1 = cs.getInt(1);
                int output2 = cs.getInt(2);
                swapResult.swap = new Swap(output1, output2);
                return swapResult;
            }
        });
        Assert.assertEquals((long)3L, (long)((Integer)result.results.get(0)).intValue());
        Assert.assertEquals((long)2L, (long)((SwapResult)result).swap.a);
        Assert.assertEquals((long)1L, (long)((SwapResult)result).swap.b);
        PluginTestVerifier verifier = PluginTestVerifierHolder.getInstance();
        verifier.printCache();
        verifier.verifyTraceCount(5);
        Method connect = this.jdbcApi.getDriver().getConnect();
        verifier.verifyTrace(new ExpectedTrace[]{Expectations.event((String)this.DB_TYPE, (Member)connect, null, (String)this.databaseAddress, (String)this.databaseName, (ExpectedAnnotation[])Expectations.cachedArgs((Object[])new Object[]{this.jdbcUrl}))});
        Method prepareCall = this.jdbcApi.getConnection().getPrepareCall();
        verifier.verifyTrace(new ExpectedTrace[]{Expectations.event((String)this.DB_TYPE, (Member)prepareCall, null, (String)this.databaseAddress, (String)this.databaseName, (ExpectedAnnotation[])new ExpectedAnnotation[]{Expectations.sql((String)"{ call swapAndGetSum(?, ?) }", null, (Object[])new Object[0])})});
        Method registerOutParameter = this.jdbcApi.getCallableStatement().getRegisterOutParameter();
        verifier.verifyTrace(new ExpectedTrace[]{Expectations.event((String)this.DB_TYPE, (Member)registerOutParameter, null, (String)this.databaseAddress, (String)this.databaseName, (ExpectedAnnotation[])Expectations.args((Object[])new Object[]{1, 4}))});
        verifier.verifyTrace(new ExpectedTrace[]{Expectations.event((String)this.DB_TYPE, (Member)registerOutParameter, null, (String)this.databaseAddress, (String)this.databaseName, (ExpectedAnnotation[])Expectations.args((Object[])new Object[]{2, 4}))});
        Method executeQuery = this.jdbcApi.getPreparedStatement().getExecuteQuery();
        verifier.verifyTrace(new ExpectedTrace[]{Expectations.event((String)this.DB_EXECUTE_QUERY, (Member)executeQuery, null, (String)this.databaseAddress, (String)this.databaseName, (ExpectedAnnotation[])new ExpectedAnnotation[]{Expectations.sql((String)"{ call swapAndGetSum(?, ?) }", null, (Object[])new Object[]{"1, 2"})})});
    }

    public static class SwapResult {
        private List<Integer> results = new ArrayList<Integer>();
        private Swap swap;
    }

    private static class Swap {
        int a;
        int b;

        public Swap(int a, int b) {
            this.a = a;
            this.b = b;
        }
    }

    public static class User {
        private final int id;
        private final String name;
        private final int age;

        public User(int id, String name, int age) {
            this.id = id;
            this.name = name;
            this.age = age;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public int getAge() {
            return this.age;
        }

        public String toString() {
            return "User{id=" + this.id + ", name='" + this.name + '\'' + ", age=" + this.age + '}';
        }
    }
}

