/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.pluginit.jdbc;

import com.navercorp.pinpoint.pluginit.jdbc.JDBCApi;
import com.navercorp.pinpoint.pluginit.jdbc.JDBCDriverClass;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Objects;
import java.util.Properties;

public class DefaultJDBCApi
implements JDBCApi {
    public final JDBCDriverClass jdbcDriverClass;

    public DefaultJDBCApi(JDBCDriverClass jdbcDriverClass) {
        this.jdbcDriverClass = Objects.requireNonNull(jdbcDriverClass, "jdbcDriverClass");
    }

    @Override
    public JDBCDriverClass getJDBCDriverClass() {
        return this.jdbcDriverClass;
    }

    @Override
    public JDBCApi.DriverClass getDriver() {
        return new DefaultDriverClass(this.getJDBCDriverClass());
    }

    @Override
    public JDBCApi.ConnectionClass getConnection() {
        return new DefaultConnectionClass(this.getJDBCDriverClass());
    }

    @Override
    public JDBCApi.StatementClass getStatement() {
        return new DefaultStatementClass(this.getJDBCDriverClass());
    }

    @Override
    public JDBCApi.PreparedStatementClass getPreparedStatement() {
        return new DefaultPreparedStatementClass(this.getJDBCDriverClass());
    }

    @Override
    public JDBCApi.CallableStatementClass getCallableStatement() {
        return new DefaultCallableStatementClass(this.getJDBCDriverClass());
    }

    public static Method getDeclaredMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(clazz.getName() + "." + name + Arrays.toString(parameterTypes), e);
        }
    }

    public static class DefaultCallableStatementClass
    implements JDBCApi.CallableStatementClass {
        private final JDBCDriverClass jdbcDriverClass;

        public DefaultCallableStatementClass(JDBCDriverClass jdbcDriverClass) {
            this.jdbcDriverClass = Objects.requireNonNull(jdbcDriverClass, "jdbcDriverClass");
        }

        protected Class<CallableStatement> getCallableStatement() {
            return this.jdbcDriverClass.getCallableStatement();
        }

        @Override
        public Method getRegisterOutParameter() {
            Class<CallableStatement> callableStatement = this.getCallableStatement();
            return DefaultJDBCApi.getDeclaredMethod(callableStatement, "registerOutParameter", Integer.TYPE, Integer.TYPE);
        }

        @Override
        public Method getExecute() {
            Class<CallableStatement> callableStatement = this.getCallableStatement();
            return DefaultJDBCApi.getDeclaredMethod(callableStatement, "execute", new Class[0]);
        }

        @Override
        public Method getExecuteQuery() {
            Class<CallableStatement> callableStatement = this.getCallableStatement();
            return DefaultJDBCApi.getDeclaredMethod(callableStatement, "executeQuery", new Class[0]);
        }
    }

    public static class DefaultPreparedStatementClass
    implements JDBCApi.PreparedStatementClass {
        private final JDBCDriverClass jdbcDriverClass;

        public DefaultPreparedStatementClass(JDBCDriverClass jdbcDriverClass) {
            this.jdbcDriverClass = Objects.requireNonNull(jdbcDriverClass, "jdbcDriverClass");
        }

        protected Class<PreparedStatement> getPreparedStatement() {
            return this.jdbcDriverClass.getPreparedStatement();
        }

        @Override
        public Method getExecute() {
            Class<PreparedStatement> statement = this.getPreparedStatement();
            return DefaultJDBCApi.getDeclaredMethod(statement, "execute", new Class[0]);
        }

        @Override
        public Method getExecuteQuery() {
            Class<PreparedStatement> statement = this.getPreparedStatement();
            return DefaultJDBCApi.getDeclaredMethod(statement, "executeQuery", new Class[0]);
        }
    }

    public static class DefaultStatementClass
    implements JDBCApi.StatementClass {
        final JDBCDriverClass jdbcDriverClass;

        public DefaultStatementClass(JDBCDriverClass jdbcDriverClass) {
            this.jdbcDriverClass = Objects.requireNonNull(jdbcDriverClass, "jdbcDriverClass");
        }

        protected Class<Statement> getStatement() {
            return this.jdbcDriverClass.getStatement();
        }

        @Override
        public Method getExecuteQuery() {
            Class<Statement> statement = this.getStatement();
            return DefaultJDBCApi.getDeclaredMethod(statement, "executeQuery", String.class);
        }

        @Override
        public Method getExecuteUpdate() {
            Class<Statement> statement = this.getStatement();
            return DefaultJDBCApi.getDeclaredMethod(statement, "executeUpdate", String.class);
        }
    }

    public static class DefaultConnectionClass
    implements JDBCApi.ConnectionClass {
        private final JDBCDriverClass jdbcDriverClass;

        public DefaultConnectionClass(JDBCDriverClass jdbcDriverClass) {
            this.jdbcDriverClass = Objects.requireNonNull(jdbcDriverClass, "jdbcDriverClass");
        }

        protected Class<Connection> getConnection() {
            return this.jdbcDriverClass.getConnection();
        }

        @Override
        public Method getSetAutoCommit() {
            Class<Connection> connection = this.getConnection();
            return DefaultJDBCApi.getDeclaredMethod(connection, "setAutoCommit", Boolean.TYPE);
        }

        @Override
        public Method getPrepareStatement() {
            Class<Connection> connection = this.getConnection();
            return DefaultJDBCApi.getDeclaredMethod(connection, "prepareStatement", String.class);
        }

        @Override
        public Method getPrepareCall() {
            Class<Connection> connection = this.getConnection();
            return DefaultJDBCApi.getDeclaredMethod(connection, "prepareCall", String.class);
        }

        @Override
        public Method getCommit() {
            Class<Connection> connection = this.getConnection();
            return DefaultJDBCApi.getDeclaredMethod(connection, "commit", new Class[0]);
        }
    }

    public static class DefaultDriverClass
    implements JDBCApi.DriverClass {
        private final JDBCDriverClass jdbcDriverClass;

        public DefaultDriverClass(JDBCDriverClass jdbcDriverClass) {
            this.jdbcDriverClass = Objects.requireNonNull(jdbcDriverClass, "jdbcDriverClass");
        }

        protected Class<Driver> getConnection() {
            return this.jdbcDriverClass.getDriver();
        }

        @Override
        public Method getConnect() {
            Class<Driver> connection = this.getConnection();
            return DefaultJDBCApi.getDeclaredMethod(connection, "connect", String.class, Properties.class);
        }
    }
}

