/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.pluginit.jdbc;

import com.navercorp.pinpoint.common.util.PropertyUtils;
import java.io.IOException;
import java.util.Properties;

public class DriverProperties {
    private final Properties properties;
    private static final String URL = "url";
    private static final String USER = "user";
    private static final String PASSWARD = "password";
    private final String url;
    private final String user;
    private final String password;

    public static DriverProperties load(String propertyPath, String prefix) {
        Properties properties = DriverProperties.load(propertyPath);
        String url = DriverProperties.getDatabaseProperty(properties, prefix, URL);
        String user = DriverProperties.getDatabaseProperty(properties, prefix, USER);
        String password = DriverProperties.getDatabaseProperty(properties, prefix, PASSWARD);
        return new DriverProperties(url, user, password, properties);
    }

    public DriverProperties(String url, String user, String password, Properties properties) {
        this.properties = properties;
        this.url = url;
        this.user = user;
        this.password = password;
    }

    private static String getDatabaseProperty(Properties properties, String prefix, String postfix) {
        String key = prefix + "." + postfix;
        String value = properties.getProperty(key);
        if (value == null) {
            throw new IllegalArgumentException(key + " not found");
        }
        return value;
    }

    private static Properties load(String propertyPath) {
        try {
            return PropertyUtils.loadPropertyFromClassPath((String)propertyPath);
        }
        catch (IOException ex) {
            throw new IllegalStateException(propertyPath + " load fail", ex);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DriverProperties{");
        sb.append("properties=").append(this.properties);
        sb.append(", url='").append(this.url).append('\'');
        sb.append(", user='").append(this.user).append('\'');
        sb.append(", password='").append(this.password).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

