/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.pluginit.jdbc.template;

import com.navercorp.pinpoint.pluginit.jdbc.JdbcUtils;
import com.navercorp.pinpoint.pluginit.jdbc.template.CallableStatementCallback;
import com.navercorp.pinpoint.pluginit.jdbc.template.PreparedStatementSetter;
import com.navercorp.pinpoint.pluginit.jdbc.template.ResultSetExtractor;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;

public class SimpleJdbcTemplate {
    private final DataSource datasource;
    private final ConnectionInterceptor connectionInterceptor;

    public SimpleJdbcTemplate(DataSource dataSource) {
        this.datasource = dataSource;
        this.connectionInterceptor = new AutoCommitConnectionInterceptor();
    }

    public SimpleJdbcTemplate(DataSource dataSource, ConnectionInterceptor connectionInterceptor) {
        this.datasource = dataSource;
        this.connectionInterceptor = connectionInterceptor;
    }

    private Connection getConnection() throws SQLException {
        Connection connection = this.datasource.getConnection();
        this.connectionInterceptor.before(connection);
        return connection;
    }

    private void closeConnection(Connection connection) throws SQLException {
        try {
            this.connectionInterceptor.after(connection);
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            JdbcUtils.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeQuery(String sql, ResultSetExtractor<T> resultExtractor) throws SQLException {
        T t;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(sql);
            t = resultExtractor.extractData(resultSet);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(statement);
            this.closeConnection(connection);
            throw throwable;
        }
        JdbcUtils.closeResultSet(resultSet);
        JdbcUtils.closeStatement(statement);
        this.closeConnection(connection);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sql) throws SQLException {
        Connection connection = null;
        Statement ps = null;
        try {
            connection = this.getConnection();
            Statement statement = connection.createStatement();
            int n = statement.executeUpdate(sql);
            return n;
        }
        finally {
            JdbcUtils.closeStatement(ps);
            this.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeQuery(String sql, PreparedStatementSetter pss, ResultSetExtractor<T> resultExtractor) throws SQLException {
        T t;
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            ps = connection.prepareStatement(sql);
            pss.setValues(ps);
            resultSet = ps.executeQuery();
            t = resultExtractor.extractData(resultSet);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(ps);
            this.closeConnection(connection);
            throw throwable;
        }
        JdbcUtils.closeResultSet(resultSet);
        JdbcUtils.closeStatement(ps);
        this.closeConnection(connection);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String sql, PreparedStatementSetter pss) throws SQLException {
        boolean bl;
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            connection = this.getConnection();
            ps = connection.prepareStatement(sql);
            pss.setValues(ps);
            bl = ps.execute();
        }
        catch (Throwable throwable) {
            JdbcUtils.closeStatement(ps);
            this.closeConnection(connection);
            throw throwable;
        }
        JdbcUtils.closeStatement(ps);
        this.closeConnection(connection);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(String sql, CallableStatementCallback<T> callback) throws SQLException {
        T t;
        Connection connection = null;
        CallableStatement cs = null;
        try {
            connection = this.getConnection();
            cs = connection.prepareCall(sql);
            t = callback.doInCallableStatement(cs);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeStatement(cs);
            this.closeConnection(connection);
            throw throwable;
        }
        JdbcUtils.closeStatement(cs);
        this.closeConnection(connection);
        return t;
    }

    public static class AutoCommitConnectionInterceptor
    implements ConnectionInterceptor {
        @Override
        public void before(Connection connection) throws SQLException {
            connection.setAutoCommit(false);
        }

        @Override
        public void after(Connection connection) throws SQLException {
            connection.commit();
        }
    }

    public static interface ConnectionInterceptor {
        public static final ConnectionInterceptor EMPTY = new ConnectionInterceptor(){

            @Override
            public void before(Connection connection) throws SQLException {
            }

            @Override
            public void after(Connection connection) throws SQLException {
            }
        };

        public void before(Connection var1) throws SQLException;

        public void after(Connection var1) throws SQLException;
    }
}

