/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.storage;

import com.navercorp.pinpoint.profiler.context.Span;
import com.navercorp.pinpoint.profiler.context.SpanEvent;
import com.navercorp.pinpoint.profiler.context.storage.Storage;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TraceLogDelegateStorage
implements Storage {
    private final Logger logger = LogManager.getLogger(TraceLogDelegateStorage.class);
    private final Storage delegate;

    public TraceLogDelegateStorage(Storage delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
    }

    @Override
    public void store(SpanEvent spanEvent) {
        if (this.logger.isTraceEnabled()) {
            Thread th = Thread.currentThread();
            this.logger.trace("[DefaultTrace] Write {} thread{id={}, name={}}", (Object)spanEvent, (Object)th.getId(), (Object)th.getName());
        }
        this.delegate.store(spanEvent);
    }

    @Override
    public void store(Span span) {
        if (this.logger.isTraceEnabled()) {
            Thread th = Thread.currentThread();
            this.logger.trace("[DefaultTrace] Write {} thread{id={}, name={}}", (Object)span, (Object)th.getId(), (Object)th.getName());
        }
        this.delegate.store(span);
    }

    @Override
    public void flush() {
        this.delegate.flush();
    }

    @Override
    public void close() {
        this.delegate.close();
    }
}

