/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.monitor.metric.response;

import com.google.inject.Inject;
import com.navercorp.pinpoint.profiler.monitor.metric.response.ResponseTimeValue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;

public class ReuseResponseTimeCollector
implements com.navercorp.pinpoint.profiler.monitor.metric.response.ResponseTimeCollector {
    private volatile ResponseTimeCollector currentResponseTimeCollector = new ResponseTimeCollector();

    @Inject
    public ReuseResponseTimeCollector() {
    }

    @Override
    public void add(long value) {
        this.currentResponseTimeCollector.add(value);
    }

    @Override
    public ResponseTimeValue resetAndGetValue() {
        ResponseTimeCollector reset = this.reset();
        long totalValue = reset.getTotalValue();
        long maxValue = reset.getMaxValue();
        long transactionCount = reset.getTransactionCount();
        return new ResponseTimeValue0(totalValue, maxValue, transactionCount);
    }

    private ResponseTimeCollector reset() {
        ResponseTimeCollector newValue = new ResponseTimeCollector();
        ResponseTimeCollector copy = this.currentResponseTimeCollector;
        this.currentResponseTimeCollector = newValue;
        return copy;
    }

    private static class ResponseTimeValue0
    implements ResponseTimeValue {
        private final long totalResponseTime;
        private final long maxResponseTime;
        private final long transactionCount;

        private ResponseTimeValue0(long totalResponseTime, long maxResponseTime, long transactionCount) {
            this.totalResponseTime = totalResponseTime;
            this.maxResponseTime = maxResponseTime;
            this.transactionCount = transactionCount;
        }

        @Override
        public long getAvg() {
            if (this.transactionCount == 0L) {
                return this.totalResponseTime;
            }
            return this.totalResponseTime / this.transactionCount;
        }

        @Override
        public long getMax() {
            return this.maxResponseTime;
        }

        @Override
        public long getTotal() {
            return this.totalResponseTime;
        }

        @Override
        public long getTransactionCount() {
            return this.transactionCount;
        }

        public String toString() {
            return "ResponseTimeValue0{totalResponseTime=" + this.totalResponseTime + ", maxResponseTime=" + this.maxResponseTime + ", transactionCount=" + this.transactionCount + '}';
        }
    }

    private static class ResponseTimeCollector {
        private final LongAdder totalValue;
        private final LongAdder transactionCount;
        private final AtomicLong maxValue = new AtomicLong(0L);

        private ResponseTimeCollector() {
            this.totalValue = new LongAdder();
            this.transactionCount = new LongAdder();
        }

        void add(long value) {
            this.transactionCount.increment();
            this.totalValue.add(value);
            boolean success = this.setMaxValue(value);
            while (!success) {
                success = this.setMaxValue(value);
            }
        }

        private boolean setMaxValue(long value) {
            long currentMaxValue = this.maxValue.get();
            if (currentMaxValue < value) {
                return this.maxValue.compareAndSet(currentMaxValue, value);
            }
            return true;
        }

        public long getTotalValue() {
            return this.totalValue.longValue();
        }

        public long getMaxValue() {
            return this.maxValue.get();
        }

        public long getTransactionCount() {
            return this.transactionCount.longValue();
        }
    }
}

