/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.packet.stream;

import com.navercorp.pinpoint.rpc.packet.PayloadPacket;
import com.navercorp.pinpoint.rpc.packet.stream.BasicStreamPacket;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class StreamCreatePacket
extends BasicStreamPacket {
    private static final short PACKET_TYPE = 10;
    private final byte[] payload;

    public StreamCreatePacket(int streamChannelId, byte[] payload) {
        super(streamChannelId);
        this.payload = Objects.requireNonNull(payload, "payload");
    }

    @Override
    public short getPacketType() {
        return 10;
    }

    @Override
    public byte[] getPayload() {
        return this.payload;
    }

    @Override
    public ChannelBuffer toBuffer() {
        ChannelBuffer header = ChannelBuffers.buffer((int)10);
        header.writeShort((int)this.getPacketType());
        header.writeInt(this.getStreamChannelId());
        return PayloadPacket.appendPayload(header, this.payload);
    }

    public static StreamCreatePacket readBuffer(short packetType, ChannelBuffer buffer) {
        assert (packetType == 10);
        if (buffer.readableBytes() < 8) {
            buffer.resetReaderIndex();
            return null;
        }
        int streamChannelId = buffer.readInt();
        ChannelBuffer payload = PayloadPacket.readPayload(buffer);
        if (payload == null) {
            return null;
        }
        StreamCreatePacket packet = new StreamCreatePacket(streamChannelId, payload.array());
        return packet;
    }
}

