/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.stream;

import com.navercorp.pinpoint.rpc.packet.stream.StreamCode;
import com.navercorp.pinpoint.rpc.stream.StreamChannel;
import com.navercorp.pinpoint.rpc.stream.StreamChannelRepository;
import com.navercorp.pinpoint.rpc.stream.StreamChannelState;
import com.navercorp.pinpoint.rpc.stream.StreamChannelStateChangeEventHandler;
import com.navercorp.pinpoint.rpc.stream.StreamChannelStateCode;
import com.navercorp.pinpoint.rpc.stream.StreamException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractStreamChannel
implements StreamChannel {
    protected final Logger logger = LogManager.getLogger(this.getClass());
    private final ConcurrentMap<String, Object> attribute = new ConcurrentHashMap<String, Object>();
    private final int streamChannelId;
    protected final StreamChannelState state = new StreamChannelState();
    private final CountDownLatch openLatch = new CountDownLatch(1);
    protected final StreamChannelRepository streamChannelRepository;

    public AbstractStreamChannel(int streamId, StreamChannelRepository streamChannelRepository) {
        this.streamChannelId = streamId;
        this.streamChannelRepository = streamChannelRepository;
    }

    protected abstract StreamChannelStateChangeEventHandler getStateChangeEventHandler();

    @Override
    public void init() throws StreamException {
        this.changeStateTo(StreamChannelStateCode.OPEN, true);
        this.streamChannelRepository.registerIfAbsent(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean changeStateConnected() {
        try {
            boolean bl = this.changeStateTo(StreamChannelStateCode.CONNECTED);
            return bl;
        }
        finally {
            this.openLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean changeStateClose() {
        try {
            if (this.state.checkState(StreamChannelStateCode.CLOSED)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.changeStateTo(StreamChannelStateCode.CLOSED);
            return bl;
        }
        finally {
            this.openLatch.countDown();
        }
    }

    @Override
    public boolean awaitOpen(long timeoutMillis) {
        try {
            this.openLatch.await(timeoutMillis, TimeUnit.MILLISECONDS);
            return this.state.checkState(StreamChannelStateCode.CONNECTED);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public StreamChannelStateCode getCurrentState() {
        return this.state.getCurrentState();
    }

    @Override
    public void close() {
        this.close(StreamCode.STATE_CLOSED);
    }

    protected void clearStreamChannelResource() {
        this.streamChannelRepository.unregister(this);
        this.changeStateClose();
    }

    @Override
    public void disconnect() {
        this.disconnect(StreamCode.STATE_CLOSED);
    }

    @Override
    public void disconnect(StreamCode streamCode) {
        this.logger.info("disconnect. local => {}(streamId:{}, state:{}) message:{}", (Object)this.getRemoteAddress(), (Object)this.getStreamId(), (Object)this.getCurrentState(), (Object)streamCode);
        this.clearStreamChannelResource();
    }

    @Override
    public int getStreamId() {
        return this.streamChannelId;
    }

    protected boolean changeStateTo(StreamChannelStateCode nextState, boolean throwException) throws StreamException {
        StreamChannelStateCode currentState = this.getCurrentState();
        boolean changed = this.changeStateTo(currentState, nextState);
        if (!changed && throwException) {
            throw new StreamException(StreamCode.STATE_ERROR, "Failed to change state. updateWanted:<" + (Object)((Object)nextState) + ">, current:<" + (Object)((Object)currentState) + ">");
        }
        return changed;
    }

    protected boolean changeStateTo(StreamChannelStateCode nextState) {
        StreamChannelStateCode currentState = this.getCurrentState();
        return this.changeStateTo(currentState, nextState);
    }

    protected boolean changeStateTo(StreamChannelStateCode currentState, StreamChannelStateCode nextState) {
        boolean isChanged = this.state.to(currentState, nextState);
        if (!isChanged && this.getCurrentState() != StreamChannelStateCode.ILLEGAL_STATE) {
            this.changeStateTo(StreamChannelStateCode.ILLEGAL_STATE);
        }
        if (isChanged) {
            try {
                this.getStateChangeEventHandler().stateUpdated(this, nextState);
            }
            catch (Exception e) {
                this.logger.warn("Please handling exception in StreamChannelStateChangeEventHandler.stateUpdated method. message:{}", (Object)e.getMessage(), (Object)e);
            }
        }
        return isChanged;
    }

    public final Object getAttribute(String key) {
        return this.attribute.get(key);
    }

    public final Object setAttributeIfAbsent(String key, Object value) {
        return this.attribute.putIfAbsent(key, value);
    }

    public final Object removeAttribute(String key) {
        return this.attribute.remove(key);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[RemoteAddress:");
        sb.append(this.getRemoteAddress());
        sb.append(", StreamId:");
        sb.append(this.getStreamId());
        sb.append(", State:");
        sb.append((Object)this.getCurrentState());
        sb.append("].");
        return sb.toString();
    }
}

